/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTransmitter;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalConductor;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAluminumWire;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAluminumWireSwitch;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAluminumWire
extends BlockTransmitter
implements ITileEntityProvider,
IShiftDescription,
ISortableBlock {
    public static final PropertyEnum<EnumWireType> WIRE_TYPE = PropertyEnum.func_177709_a((String)"wiretype", EnumWireType.class);
    private static final float MIN = 0.38f;
    private static final float MINH = 0.3f;
    private static final float MAX = 0.62f;
    private static final float MAXH = 0.7f;
    protected static final AxisAlignedBB[] BOUNDING_BOXES = new AxisAlignedBB[]{new AxisAlignedBB((double)0.38f, (double)0.38f, (double)0.38f, (double)0.62f, (double)0.62f, (double)0.62f), new AxisAlignedBB((double)0.38f, (double)0.38f, (double)0.38f, (double)0.62f, (double)0.62f, 1.0), new AxisAlignedBB(0.0, (double)0.38f, (double)0.38f, (double)0.62f, (double)0.62f, (double)0.62f), new AxisAlignedBB(0.0, (double)0.38f, (double)0.38f, (double)0.62f, (double)0.62f, 1.0), new AxisAlignedBB((double)0.38f, (double)0.38f, 0.0, (double)0.62f, (double)0.62f, (double)0.62f), new AxisAlignedBB((double)0.38f, (double)0.38f, 0.0, (double)0.62f, (double)0.62f, 1.0), new AxisAlignedBB(0.0, (double)0.38f, 0.0, (double)0.62f, (double)0.62f, (double)0.62f), new AxisAlignedBB(0.0, (double)0.38f, 0.0, (double)0.62f, (double)0.62f, 1.0), new AxisAlignedBB((double)0.38f, (double)0.38f, (double)0.38f, 1.0, (double)0.62f, (double)0.62f), new AxisAlignedBB((double)0.38f, (double)0.38f, (double)0.38f, 1.0, (double)0.62f, 1.0), new AxisAlignedBB(0.0, (double)0.38f, (double)0.38f, 1.0, (double)0.62f, (double)0.62f), new AxisAlignedBB(0.0, (double)0.38f, (double)0.38f, 1.0, (double)0.62f, 1.0), new AxisAlignedBB((double)0.38f, (double)0.38f, 0.0, 1.0, (double)0.62f, (double)0.62f), new AxisAlignedBB((double)0.38f, (double)0.38f, 0.0, 1.0, (double)0.62f, 1.0), new AxisAlignedBB(0.0, (double)0.38f, 0.0, 1.0, (double)0.62f, (double)0.62f), new AxisAlignedBB(0.0, (double)0.38f, 0.0, 1.0, (double)0.62f, 1.0), new AxisAlignedBB((double)0.38f, 0.0, (double)0.38f, (double)0.62f, (double)0.62f, (double)0.62f), new AxisAlignedBB((double)0.38f, 0.0, (double)0.38f, (double)0.62f, (double)0.62f, 1.0), new AxisAlignedBB(0.0, 0.0, (double)0.38f, (double)0.62f, (double)0.62f, (double)0.62f), new AxisAlignedBB(0.0, 0.0, (double)0.38f, (double)0.62f, (double)0.62f, 1.0), new AxisAlignedBB((double)0.38f, 0.0, 0.0, (double)0.62f, (double)0.62f, (double)0.62f), new AxisAlignedBB((double)0.38f, 0.0, 0.0, (double)0.62f, (double)0.62f, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.62f, (double)0.62f, (double)0.62f), new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.62f, (double)0.62f, 1.0), new AxisAlignedBB((double)0.38f, 0.0, (double)0.38f, 1.0, (double)0.62f, (double)0.62f), new AxisAlignedBB((double)0.38f, 0.0, (double)0.38f, 1.0, (double)0.62f, 1.0), new AxisAlignedBB(0.0, 0.0, (double)0.38f, 1.0, (double)0.62f, (double)0.62f), new AxisAlignedBB(0.0, 0.0, (double)0.38f, 1.0, (double)0.62f, 1.0), new AxisAlignedBB((double)0.38f, 0.0, 0.0, 1.0, (double)0.62f, (double)0.62f), new AxisAlignedBB((double)0.38f, 0.0, 0.0, 1.0, (double)0.62f, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.62f, (double)0.62f), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.62f, 1.0), new AxisAlignedBB((double)0.38f, (double)0.38f, (double)0.38f, (double)0.62f, 1.0, (double)0.62f), new AxisAlignedBB((double)0.38f, (double)0.38f, (double)0.38f, (double)0.62f, 1.0, 1.0), new AxisAlignedBB(0.0, (double)0.38f, (double)0.38f, (double)0.62f, 1.0, (double)0.62f), new AxisAlignedBB(0.0, (double)0.38f, (double)0.38f, (double)0.62f, 1.0, 1.0), new AxisAlignedBB((double)0.38f, (double)0.38f, 0.0, (double)0.62f, 1.0, (double)0.62f), new AxisAlignedBB((double)0.38f, (double)0.38f, 0.0, (double)0.62f, 1.0, 1.0), new AxisAlignedBB(0.0, (double)0.38f, 0.0, (double)0.62f, 1.0, (double)0.62f), new AxisAlignedBB(0.0, (double)0.38f, 0.0, (double)0.62f, 1.0, 1.0), new AxisAlignedBB((double)0.38f, (double)0.38f, (double)0.38f, 1.0, 1.0, (double)0.62f), new AxisAlignedBB((double)0.38f, (double)0.38f, (double)0.38f, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, (double)0.38f, (double)0.38f, 1.0, 1.0, (double)0.62f), new AxisAlignedBB(0.0, (double)0.38f, (double)0.38f, 1.0, 1.0, 1.0), new AxisAlignedBB((double)0.38f, (double)0.38f, 0.0, 1.0, 1.0, (double)0.62f), new AxisAlignedBB((double)0.38f, (double)0.38f, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, (double)0.38f, 0.0, 1.0, 1.0, (double)0.62f), new AxisAlignedBB(0.0, (double)0.38f, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB((double)0.38f, 0.0, (double)0.38f, (double)0.62f, 1.0, (double)0.62f), new AxisAlignedBB((double)0.38f, 0.0, (double)0.38f, (double)0.62f, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, (double)0.38f, (double)0.62f, 1.0, (double)0.62f), new AxisAlignedBB(0.0, 0.0, (double)0.38f, (double)0.62f, 1.0, 1.0), new AxisAlignedBB((double)0.38f, 0.0, 0.0, (double)0.62f, 1.0, (double)0.62f), new AxisAlignedBB((double)0.38f, 0.0, 0.0, (double)0.62f, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.62f, 1.0, (double)0.62f), new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.62f, 1.0, 1.0), new AxisAlignedBB((double)0.38f, 0.0, (double)0.38f, 1.0, 1.0, (double)0.62f), new AxisAlignedBB((double)0.38f, 0.0, (double)0.38f, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, (double)0.38f, 1.0, 1.0, (double)0.62f), new AxisAlignedBB(0.0, 0.0, (double)0.38f, 1.0, 1.0, 1.0), new AxisAlignedBB((double)0.38f, 0.0, 0.0, 1.0, 1.0, (double)0.62f), new AxisAlignedBB((double)0.38f, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)0.62f), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB((double)0.3f, (double)0.3f, (double)0.3f, (double)0.7f, (double)0.7f, (double)0.7f), new AxisAlignedBB((double)0.3f, (double)0.3f, (double)0.3f, (double)0.7f, (double)0.7f, 1.0), new AxisAlignedBB(0.0, (double)0.3f, (double)0.3f, (double)0.7f, (double)0.7f, (double)0.7f), new AxisAlignedBB(0.0, (double)0.3f, (double)0.3f, (double)0.7f, (double)0.7f, 1.0), new AxisAlignedBB((double)0.3f, (double)0.3f, 0.0, (double)0.7f, (double)0.7f, (double)0.7f), new AxisAlignedBB((double)0.3f, (double)0.3f, 0.0, (double)0.7f, (double)0.7f, 1.0), new AxisAlignedBB(0.0, (double)0.3f, 0.0, (double)0.7f, (double)0.7f, (double)0.7f), new AxisAlignedBB(0.0, (double)0.3f, 0.0, (double)0.7f, (double)0.7f, 1.0), new AxisAlignedBB((double)0.3f, (double)0.3f, (double)0.3f, 1.0, (double)0.7f, (double)0.7f), new AxisAlignedBB((double)0.3f, (double)0.3f, (double)0.3f, 1.0, (double)0.7f, 1.0), new AxisAlignedBB(0.0, (double)0.3f, (double)0.3f, 1.0, (double)0.7f, (double)0.7f), new AxisAlignedBB(0.0, (double)0.3f, (double)0.3f, 1.0, (double)0.7f, 1.0), new AxisAlignedBB((double)0.3f, (double)0.3f, 0.0, 1.0, (double)0.7f, (double)0.7f), new AxisAlignedBB((double)0.3f, (double)0.3f, 0.0, 1.0, (double)0.7f, 1.0), new AxisAlignedBB(0.0, (double)0.3f, 0.0, 1.0, (double)0.7f, (double)0.7f), new AxisAlignedBB(0.0, (double)0.3f, 0.0, 1.0, (double)0.7f, 1.0), new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, (double)0.7f, (double)0.7f), new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, (double)0.7f, 1.0), new AxisAlignedBB(0.0, 0.0, (double)0.3f, (double)0.7f, (double)0.7f, (double)0.7f), new AxisAlignedBB(0.0, 0.0, (double)0.3f, (double)0.7f, (double)0.7f, 1.0), new AxisAlignedBB((double)0.3f, 0.0, 0.0, (double)0.7f, (double)0.7f, (double)0.7f), new AxisAlignedBB((double)0.3f, 0.0, 0.0, (double)0.7f, (double)0.7f, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.7f, (double)0.7f, (double)0.7f), new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.7f, (double)0.7f, 1.0), new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, 1.0, (double)0.7f, (double)0.7f), new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, 1.0, (double)0.7f, 1.0), new AxisAlignedBB(0.0, 0.0, (double)0.3f, 1.0, (double)0.7f, (double)0.7f), new AxisAlignedBB(0.0, 0.0, (double)0.3f, 1.0, (double)0.7f, 1.0), new AxisAlignedBB((double)0.3f, 0.0, 0.0, 1.0, (double)0.7f, (double)0.7f), new AxisAlignedBB((double)0.3f, 0.0, 0.0, 1.0, (double)0.7f, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.7f, (double)0.7f), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.7f, 1.0), new AxisAlignedBB((double)0.3f, (double)0.3f, (double)0.3f, (double)0.7f, 1.0, (double)0.7f), new AxisAlignedBB((double)0.3f, (double)0.3f, (double)0.3f, (double)0.7f, 1.0, 1.0), new AxisAlignedBB(0.0, (double)0.3f, (double)0.3f, (double)0.7f, 1.0, (double)0.7f), new AxisAlignedBB(0.0, (double)0.3f, (double)0.3f, (double)0.7f, 1.0, 1.0), new AxisAlignedBB((double)0.3f, (double)0.3f, 0.0, (double)0.7f, 1.0, (double)0.7f), new AxisAlignedBB((double)0.3f, (double)0.3f, 0.0, (double)0.7f, 1.0, 1.0), new AxisAlignedBB(0.0, (double)0.3f, 0.0, (double)0.7f, 1.0, (double)0.7f), new AxisAlignedBB(0.0, (double)0.3f, 0.0, (double)0.7f, 1.0, 1.0), new AxisAlignedBB((double)0.3f, (double)0.3f, (double)0.3f, 1.0, 1.0, (double)0.7f), new AxisAlignedBB((double)0.3f, (double)0.3f, (double)0.3f, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, (double)0.3f, (double)0.3f, 1.0, 1.0, (double)0.7f), new AxisAlignedBB(0.0, (double)0.3f, (double)0.3f, 1.0, 1.0, 1.0), new AxisAlignedBB((double)0.3f, (double)0.3f, 0.0, 1.0, 1.0, (double)0.7f), new AxisAlignedBB((double)0.3f, (double)0.3f, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, (double)0.3f, 0.0, 1.0, 1.0, (double)0.7f), new AxisAlignedBB(0.0, (double)0.3f, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, 1.0, (double)0.7f), new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, (double)0.7f, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, (double)0.3f, (double)0.7f, 1.0, (double)0.7f), new AxisAlignedBB(0.0, 0.0, (double)0.3f, (double)0.7f, 1.0, 1.0), new AxisAlignedBB((double)0.3f, 0.0, 0.0, (double)0.7f, 1.0, (double)0.7f), new AxisAlignedBB((double)0.3f, 0.0, 0.0, (double)0.7f, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.7f, 1.0, (double)0.7f), new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.7f, 1.0, 1.0), new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, 1.0, 1.0, (double)0.7f), new AxisAlignedBB((double)0.3f, 0.0, (double)0.3f, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, (double)0.3f, 1.0, 1.0, (double)0.7f), new AxisAlignedBB(0.0, 0.0, (double)0.3f, 1.0, 1.0, 1.0), new AxisAlignedBB((double)0.3f, 0.0, 0.0, 1.0, 1.0, (double)0.7f), new AxisAlignedBB((double)0.3f, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)0.7f), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};

    public BlockAluminumWire(String assetName) {
        super(Material.field_151580_n);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149752_b(0.2f);
        this.func_149711_c(0.075f);
        this.func_149663_c(assetName);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        return BOUNDING_BOXES[BlockAluminumWire.getBoundingBoxIdx(state)];
    }

    private static int getBoundingBoxIdx(IBlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            i |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            i |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            i |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            i |= 1 << EnumFacing.WEST.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            i |= 0x10;
        }
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            i |= 0x20;
        }
        if (((EnumWireType)((Object)state.func_177229_b(WIRE_TYPE))).ordinal() % 2 == 1) {
            i |= 0x40;
        }
        return i;
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        TileBaseUniversalConductor tile;
        switch (metadata) {
            case 0: {
                tile = new TileEntityAluminumWire(1);
                break;
            }
            case 1: {
                tile = new TileEntityAluminumWire(2);
                break;
            }
            case 2: {
                tile = new TileEntityAluminumWireSwitch(1);
                break;
            }
            case 3: {
                tile = new TileEntityAluminumWireSwitch(2);
                break;
            }
            default: {
                return null;
            }
        }
        return tile;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 1));
        list.add((Object)new ItemStack((Block)this, 1, 2));
        list.add((Object)new ItemStack((Block)this, 1, 3));
    }

    @Override
    public NetworkType getNetworkType(IBlockState state) {
        return NetworkType.POWER;
    }

    @Override
    public String getShiftDescription(int itemDamage) {
        switch (itemDamage) {
            case 0: {
                return GCCoreUtil.translate("tile.aluminum_wire.alu_wire.description");
            }
            case 1: {
                return GCCoreUtil.translate("tile.aluminum_wire.alu_wire_heavy.description");
            }
            case 2: {
                return GCCoreUtil.translate("tile.aluminum_wire.alu_wire_switch.description");
            }
            case 3: {
                return GCCoreUtil.translate("tile.aluminum_wire.alu_wire_switch_heavy.description");
            }
        }
        return "";
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(WIRE_TYPE, (Comparable)((Object)EnumWireType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumWireType)((Object)state.func_177229_b(WIRE_TYPE))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{WIRE_TYPE, UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    @Override
    public boolean showDescription(int itemDamage) {
        return true;
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.TRANSMITTER;
    }

    public static enum EnumWireType implements IStringSerializable
    {
        ALUMINUM_WIRE(0, "alu_wire"),
        ALUMINUM_WIRE_HEAVY(1, "alu_wire_heavy"),
        ALUMINUM_WIRE_SWITCHED(2, "alu_wire_switch"),
        ALUMINUM_WIRE_SWITCHED_HEAVY(3, "alu_wire_switch_heavy");

        private final int meta;
        private final String name;

        private EnumWireType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumWireType byMetadata(int meta) {
            return EnumWireType.values()[meta];
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

