/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.config.FuzzyMode;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.Platform;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;

public abstract class AbstractCellInventory<T extends IAEStack<T>>
implements ICellInventory<T> {
    private static final int MAX_ITEM_TYPES = 63;
    private static final String ITEM_TYPE_TAG = "it";
    private static final String ITEM_COUNT_TAG = "ic";
    private static final String ITEM_SLOT = "#";
    private static final String ITEM_SLOT_COUNT = "@";
    protected static final String ITEM_PRE_FORMATTED_COUNT = "PF";
    protected static final String ITEM_PRE_FORMATTED_SLOT = "PF#";
    protected static final String ITEM_PRE_FORMATTED_NAME = "PN";
    protected static final String ITEM_PRE_FORMATTED_FUZZY = "FP";
    private static final String[] ITEM_SLOT_KEYS = new String[63];
    private static final String[] ITEM_SLOT_COUNT_KEYS = new String[63];
    private final NBTTagCompound tagCompound;
    protected final ISaveProvider container;
    private int maxItemTypes = 63;
    private short storedItems = 0;
    private int storedItemCount = 0;
    protected IItemList<T> cellItems;
    private final ItemStack i;
    protected final IStorageCell<T> cellType;
    protected final int itemsPerByte;
    private boolean isPersisted = true;

    protected AbstractCellInventory(IStorageCell<T> cellType, ItemStack o, ISaveProvider container) {
        this.i = o;
        this.cellType = cellType;
        this.itemsPerByte = this.cellType.getChannel().getUnitsPerByte();
        this.maxItemTypes = this.cellType.getTotalTypes(this.i);
        if (this.maxItemTypes > 63) {
            this.maxItemTypes = 63;
        }
        if (this.maxItemTypes < 1) {
            this.maxItemTypes = 1;
        }
        this.container = container;
        this.tagCompound = Platform.openNbtData(o);
        this.storedItems = this.tagCompound.func_74765_d(ITEM_TYPE_TAG);
        this.storedItemCount = this.tagCompound.func_74762_e(ITEM_COUNT_TAG);
        this.cellItems = null;
    }

    protected IItemList<T> getCellItems() {
        if (this.cellItems == null) {
            this.cellItems = this.getChannel().createList();
            this.loadCellItems();
        }
        return this.cellItems;
    }

    @Override
    public void persist() {
        if (this.isPersisted) {
            return;
        }
        int itemCount = 0;
        int x = 0;
        for (IAEStack v : this.cellItems) {
            itemCount = (int)((long)itemCount + v.getStackSize());
            NBTTagCompound g = new NBTTagCompound();
            v.writeToNBT(g);
            this.tagCompound.func_74782_a(ITEM_SLOT_KEYS[x], (NBTBase)g);
            this.tagCompound.func_74768_a(ITEM_SLOT_COUNT_KEYS[x], (int)v.getStackSize());
            ++x;
        }
        int oldStoredItems = this.storedItems;
        this.storedItems = (short)this.cellItems.size();
        if (this.cellItems.isEmpty()) {
            this.tagCompound.func_82580_o(ITEM_TYPE_TAG);
        } else {
            this.tagCompound.func_74777_a(ITEM_TYPE_TAG, this.storedItems);
        }
        this.storedItemCount = itemCount;
        if (itemCount == 0) {
            this.tagCompound.func_82580_o(ITEM_COUNT_TAG);
        } else {
            this.tagCompound.func_74768_a(ITEM_COUNT_TAG, itemCount);
        }
        while (x < oldStoredItems && x < this.maxItemTypes) {
            this.tagCompound.func_82580_o(ITEM_SLOT_KEYS[x]);
            this.tagCompound.func_82580_o(ITEM_SLOT_COUNT_KEYS[x]);
            ++x;
        }
        this.isPersisted = true;
    }

    protected void saveChanges() {
        this.storedItems = (short)this.cellItems.size();
        this.storedItemCount = 0;
        for (IAEStack v : this.cellItems) {
            this.storedItemCount = (int)((long)this.storedItemCount + v.getStackSize());
        }
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges(this);
        } else {
            this.persist();
        }
    }

    private void loadCellItems() {
        if (this.cellItems == null) {
            this.cellItems = this.getChannel().createList();
        }
        this.cellItems.resetStatus();
        int types = (int)this.getStoredItemTypes();
        for (int slot = 0; slot < types; ++slot) {
            NBTTagCompound compoundTag = this.tagCompound.func_74775_l(ITEM_SLOT_KEYS[slot]);
            int stackSize = this.tagCompound.func_74762_e(ITEM_SLOT_COUNT_KEYS[slot]);
            this.loadCellItem(compoundTag, stackSize);
        }
    }

    protected abstract void loadCellItem(NBTTagCompound var1, int var2);

    @Override
    public IItemList<T> getAvailableItems(IItemList<T> out) {
        for (IAEStack item : this.getCellItems()) {
            out.add(item);
        }
        return out;
    }

    @Override
    public ItemStack getItemStack() {
        return this.i;
    }

    @Override
    public double getIdleDrain() {
        return this.cellType.getIdleDrain();
    }

    @Override
    public FuzzyMode getFuzzyMode() {
        return this.cellType.getFuzzyMode(this.i);
    }

    @Override
    public IItemHandler getConfigInventory() {
        return this.cellType.getConfigInventory(this.i);
    }

    @Override
    public IItemHandler getUpgradesInventory() {
        return this.cellType.getUpgradesInventory(this.i);
    }

    @Override
    public int getBytesPerType() {
        return this.cellType.getBytesPerType(this.i);
    }

    @Override
    public boolean canHoldNewItem() {
        long bytesFree = this.getFreeBytes();
        return (bytesFree > (long)this.getBytesPerType() || bytesFree == (long)this.getBytesPerType() && this.getUnusedItemCount() > 0) && this.getRemainingItemTypes() > 0L;
    }

    @Override
    public long getTotalBytes() {
        return this.cellType.getBytes(this.i);
    }

    @Override
    public long getFreeBytes() {
        return this.getTotalBytes() - this.getUsedBytes();
    }

    @Override
    public long getTotalItemTypes() {
        return this.maxItemTypes;
    }

    @Override
    public long getStoredItemCount() {
        return this.storedItemCount;
    }

    @Override
    public long getStoredItemTypes() {
        return this.storedItems;
    }

    @Override
    public long getRemainingItemTypes() {
        long baseOnTotal;
        long basedOnStorage = this.getFreeBytes() / (long)this.getBytesPerType();
        return basedOnStorage > (baseOnTotal = this.getTotalItemTypes() - this.getStoredItemTypes()) ? baseOnTotal : basedOnStorage;
    }

    @Override
    public long getUsedBytes() {
        long bytesForItemCount = (this.getStoredItemCount() + (long)this.getUnusedItemCount()) / (long)this.itemsPerByte;
        return this.getStoredItemTypes() * (long)this.getBytesPerType() + bytesForItemCount;
    }

    @Override
    public long getRemainingItemCount() {
        long remaining = this.getFreeBytes() * (long)this.itemsPerByte + (long)this.getUnusedItemCount();
        return remaining > 0L ? remaining : 0L;
    }

    @Override
    public int getUnusedItemCount() {
        int div = (int)(this.getStoredItemCount() % 8L);
        if (div == 0) {
            return 0;
        }
        return this.itemsPerByte - div;
    }

    @Override
    public int getStatusForCell() {
        if (this.canHoldNewItem()) {
            return 1;
        }
        if (this.getRemainingItemCount() > 0L) {
            return 2;
        }
        return 3;
    }

    static {
        for (int x = 0; x < 63; ++x) {
            AbstractCellInventory.ITEM_SLOT_KEYS[x] = ITEM_SLOT + x;
            AbstractCellInventory.ITEM_SLOT_COUNT_KEYS[x] = ITEM_SLOT_COUNT + x;
        }
    }
}

