/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.core.event.EventWakePlayer;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import micdoodle8.mods.galacticraft.core.network.PacketBase;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.mars.client.gui.GuiCargoRocket;
import micdoodle8.mods.galacticraft.planets.mars.client.gui.GuiLaunchControllerAdvanced;
import micdoodle8.mods.galacticraft.planets.mars.client.gui.GuiSlimelingInventory;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityCargoRocket;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntitySlimeling;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityCryogenicChamber;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityLaunchController;
import micdoodle8.mods.galacticraft.planets.mars.util.MarsUtil;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketSimpleMars
extends PacketBase {
    private EnumSimplePacketMars type;
    private List<Object> data;

    public PacketSimpleMars() {
    }

    public PacketSimpleMars(EnumSimplePacketMars packetType, int dimID, Object[] data) {
        this(packetType, dimID, Arrays.asList(data));
    }

    public PacketSimpleMars(EnumSimplePacketMars packetType, int dimID, List<Object> data) {
        super(dimID);
        if (packetType.getDecodeClasses().length != data.size()) {
            GCLog.info((String)("Mars Simple Packet found data length different than packet type: " + packetType.name()));
        }
        this.type = packetType;
        this.data = data;
    }

    public void encodeInto(ByteBuf buffer) {
        super.encodeInto(buffer);
        buffer.writeInt(this.type.ordinal());
        try {
            NetworkUtil.encodeData((ByteBuf)buffer, this.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void decodeInto(ByteBuf buffer) {
        super.decodeInto(buffer);
        this.type = EnumSimplePacketMars.values()[buffer.readInt()];
        if (this.type.getDecodeClasses().length > 0) {
            this.data = NetworkUtil.decodeData((Class[])this.type.getDecodeClasses(), (ByteBuf)buffer);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        EntityPlayerSP playerBaseClient = null;
        if (player instanceof EntityPlayerSP) {
            playerBaseClient = (EntityPlayerSP)player;
        }
        switch (this.type) {
            case C_OPEN_CUSTOM_GUI: {
                int entityID = 0;
                Entity entity = null;
                switch ((Integer)this.data.get(1)) {
                    case 0: {
                        entityID = (Integer)this.data.get(2);
                        entity = player.field_70170_p.func_73045_a(entityID);
                        if (entity != null && entity instanceof EntitySlimeling) {
                            FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiSlimelingInventory(player, (EntitySlimeling)entity));
                        }
                        player.field_71070_bA.field_75152_c = (Integer)this.data.get(0);
                        break;
                    }
                    case 1: {
                        entityID = (Integer)this.data.get(2);
                        entity = player.field_70170_p.func_73045_a(entityID);
                        if (entity != null && entity instanceof EntityCargoRocket) {
                            FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiCargoRocket((IInventory)player.field_71071_by, (EntityCargoRocket)entity));
                        }
                        player.field_71070_bA.field_75152_c = (Integer)this.data.get(0);
                    }
                }
                break;
            }
            case C_OPEN_CUSTOM_GUI_TILE: {
                switch ((Integer)this.data.get(1)) {
                    case 0: {
                        BlockPos pos = (BlockPos)this.data.get(2);
                        TileEntity tile = player.field_70170_p.func_175625_s(pos);
                        if (tile != null && tile instanceof TileEntityLaunchController) {
                            FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiLaunchControllerAdvanced(player.field_71071_by, (TileEntityLaunchController)tile));
                        }
                        player.field_71070_bA.field_75152_c = (Integer)this.data.get(0);
                    }
                }
                break;
            }
            case C_BEGIN_CRYOGENIC_SLEEP: {
                BlockPos pos = (BlockPos)this.data.get(0);
                TileEntity tile = player.field_70170_p.func_175625_s(pos);
                if (!(tile instanceof TileEntityCryogenicChamber)) break;
                ((TileEntityCryogenicChamber)tile).sleepInBedAt(player, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
    }

    public void handleServerSide(EntityPlayer player) {
        EntityPlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player, (boolean)false);
        block0 : switch (this.type) {
            case S_UPDATE_SLIMELING_DATA: {
                Entity entity = player.field_70170_p.func_73045_a(((Integer)this.data.get(0)).intValue());
                if (!(entity instanceof EntitySlimeling)) break;
                EntitySlimeling slimeling = (EntitySlimeling)entity;
                int subType = (Integer)this.data.get(1);
                switch (subType) {
                    case 0: {
                        if (player != slimeling.func_70902_q() || slimeling.field_70170_p.field_72995_K) break;
                        slimeling.setSittingAI(!slimeling.func_70906_o());
                        slimeling.func_70637_d(false);
                        slimeling.func_70661_as().func_75499_g();
                        slimeling.func_70624_b(null);
                        break;
                    }
                    case 1: {
                        if (player != slimeling.func_70902_q() || slimeling.field_70170_p.field_72995_K) break;
                        slimeling.slimelingName = (String)this.data.get(2);
                        slimeling.setName(slimeling.slimelingName);
                        break;
                    }
                    case 2: {
                        if (player != slimeling.func_70902_q() || slimeling.field_70170_p.field_72995_K) break;
                        slimeling.age += 5000;
                        break;
                    }
                    case 3: {
                        if (slimeling.func_70880_s() || player != slimeling.func_70902_q() || slimeling.field_70170_p.field_72995_K) break;
                        slimeling.func_146082_f((EntityPlayer)playerBase);
                        break;
                    }
                    case 4: {
                        if (player != slimeling.func_70902_q() || slimeling.field_70170_p.field_72995_K) break;
                        slimeling.attackDamage = Math.min(slimeling.attackDamage + 0.1f, 1.0f);
                        break;
                    }
                    case 5: {
                        if (player != slimeling.func_70902_q() || slimeling.field_70170_p.field_72995_K) break;
                        slimeling.func_70606_j(slimeling.func_110143_aJ() + 5.0f);
                        break;
                    }
                    case 6: {
                        if (player != slimeling.func_70902_q() || slimeling.field_70170_p.field_72995_K) break;
                        MarsUtil.openSlimelingInventory(playerBase, slimeling);
                    }
                }
                break;
            }
            case S_WAKE_PLAYER: {
                BlockPos c = playerBase.field_71081_bT;
                if (c == null) break;
                EventWakePlayer event = new EventWakePlayer((EntityPlayer)playerBase, c, true, true, false, true);
                MinecraftForge.EVENT_BUS.post((Event)event);
                playerBase.func_70999_a(true, true, false);
                break;
            }
            case S_UPDATE_ADVANCED_GUI: {
                TileEntity tile = player.field_70170_p.func_175625_s((BlockPos)this.data.get(1));
                switch ((Integer)this.data.get(0)) {
                    case 0: {
                        if (!(tile instanceof TileEntityLaunchController)) break block0;
                        TileEntityLaunchController launchController = (TileEntityLaunchController)tile;
                        launchController.setFrequency((Integer)this.data.get(2));
                        break block0;
                    }
                    case 1: {
                        if (!(tile instanceof TileEntityLaunchController)) break block0;
                        TileEntityLaunchController launchController = (TileEntityLaunchController)tile;
                        launchController.setLaunchDropdownSelection((Integer)this.data.get(2));
                        break block0;
                    }
                    case 2: {
                        if (!(tile instanceof TileEntityLaunchController)) break block0;
                        TileEntityLaunchController launchController = (TileEntityLaunchController)tile;
                        launchController.setDestinationFrequency((Integer)this.data.get(2));
                        break block0;
                    }
                    case 3: {
                        if (!(tile instanceof TileEntityLaunchController)) break block0;
                        TileEntityLaunchController launchController = (TileEntityLaunchController)tile;
                        launchController.launchPadRemovalDisabled = (Integer)this.data.get(2) == 1;
                        break block0;
                    }
                    case 4: {
                        if (!(tile instanceof TileEntityLaunchController)) break block0;
                        TileEntityLaunchController launchController = (TileEntityLaunchController)tile;
                        launchController.setLaunchSchedulingEnabled((Integer)this.data.get(2) == 1);
                        break block0;
                    }
                    case 5: {
                        if (!(tile instanceof TileEntityLaunchController)) break block0;
                        TileEntityLaunchController launchController = (TileEntityLaunchController)tile;
                        launchController.requiresClientUpdate = true;
                        break block0;
                    }
                }
                break;
            }
            case S_UPDATE_CARGO_ROCKET_STATUS: {
                Entity entity2 = player.field_70170_p.func_73045_a(((Integer)this.data.get(0)).intValue());
                if (!(entity2 instanceof EntityCargoRocket)) break;
                EntityCargoRocket rocket = (EntityCargoRocket)entity2;
                int subType = (Integer)this.data.get(1);
                switch (subType) {
                    default: 
                }
                rocket.statusValid = rocket.checkLaunchValidity();
                break;
            }
            case S_SWITCH_LAUNCH_CONTROLLER_GUI: {
                BlockPos pos = (BlockPos)this.data.get(0);
                TileEntity tile1 = player.field_70170_p.func_175625_s(pos);
                if (!(tile1 instanceof TileEntityLaunchController)) break;
                TileEntityLaunchController launchController = (TileEntityLaunchController)tile1;
                switch ((Integer)this.data.get(1)) {
                    case 0: {
                        MarsUtil.openAdvancedLaunchController(playerBase, launchController);
                        break;
                    }
                    case 1: {
                        player.openGui((Object)GalacticraftPlanets.instance, 2, player.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    }
                }
                break;
            }
        }
    }

    public static enum EnumSimplePacketMars {
        S_UPDATE_SLIMELING_DATA(Side.SERVER, Integer.class, Integer.class, String.class),
        S_WAKE_PLAYER(Side.SERVER, new Class[0]),
        S_UPDATE_ADVANCED_GUI(Side.SERVER, Integer.class, BlockPos.class, Integer.class),
        S_UPDATE_CARGO_ROCKET_STATUS(Side.SERVER, Integer.class, Integer.class),
        S_SWITCH_LAUNCH_CONTROLLER_GUI(Side.SERVER, BlockPos.class, Integer.class),
        C_OPEN_CUSTOM_GUI(Side.CLIENT, Integer.class, Integer.class, Integer.class),
        C_OPEN_CUSTOM_GUI_TILE(Side.CLIENT, Integer.class, Integer.class, BlockPos.class),
        C_BEGIN_CRYOGENIC_SLEEP(Side.CLIENT, BlockPos.class);

        private Side targetSide;
        private Class<?>[] decodeAs;

        private EnumSimplePacketMars(Side targetSide, Class<?> ... decodeAs) {
            this.targetSide = targetSide;
            this.decodeAs = decodeAs;
        }

        public Side getTargetSide() {
            return this.targetSide;
        }

        public Class<?>[] getDecodeClasses() {
            return this.decodeAs;
        }
    }
}

