/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.proxy;

import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.ClientRegistryHandler;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.render.RenderBatteryBox;
import de.ellpeck.actuallyadditions.mod.blocks.render.RenderDisplayStand;
import de.ellpeck.actuallyadditions.mod.blocks.render.RenderEmpowerer;
import de.ellpeck.actuallyadditions.mod.blocks.render.RenderLaserRelay;
import de.ellpeck.actuallyadditions.mod.blocks.render.RenderReconstructorLens;
import de.ellpeck.actuallyadditions.mod.blocks.render.RenderSmileyCloud;
import de.ellpeck.actuallyadditions.mod.entity.InitEntities;
import de.ellpeck.actuallyadditions.mod.entity.RenderWorm;
import de.ellpeck.actuallyadditions.mod.event.ClientEvents;
import de.ellpeck.actuallyadditions.mod.misc.special.SpecialRenderInit;
import de.ellpeck.actuallyadditions.mod.proxy.IProxy;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityAtomicReconstructor;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBatteryBox;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityCompost;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityDisplayStand;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityEmpowerer;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergy;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergyAdvanced;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergyExtreme;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayFluids;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayItem;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayItemWhitelist;
import de.ellpeck.actuallyadditions.mod.tile.TileEntitySmileyCloud;
import de.ellpeck.actuallyadditions.mod.util.IColorProvidingBlock;
import de.ellpeck.actuallyadditions.mod.util.IColorProvidingItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ClientProxy
implements IProxy {
    private static final List<Item> COLOR_PRODIVIDING_ITEMS_FOR_REGISTERING = new ArrayList<Item>();
    private static final List<Block> COLOR_PRODIVIDING_BLOCKS_FOR_REGISTERING = new ArrayList<Block>();

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        ActuallyAdditions.LOGGER.info("PreInitializing ClientProxy...");
        MinecraftForge.EVENT_BUS.register((Object)new ClientRegistryHandler());
        InitEntities.initClient();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        ActuallyAdditions.LOGGER.info("Initializing ClientProxy...");
        RenderWorm.fixItemStack();
        new ClientEvents();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityAtomicReconstructor.class, (TileEntitySpecialRenderer)new RenderReconstructorLens());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySmileyCloud.class, (TileEntitySpecialRenderer)new RenderSmileyCloud());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDisplayStand.class, (TileEntitySpecialRenderer)new RenderDisplayStand());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEmpowerer.class, (TileEntitySpecialRenderer)new RenderEmpowerer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBatteryBox.class, (TileEntitySpecialRenderer)new RenderBatteryBox());
        RenderLaserRelay laser = new RenderLaserRelay();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLaserRelayEnergy.class, (TileEntitySpecialRenderer)laser);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLaserRelayEnergyAdvanced.class, (TileEntitySpecialRenderer)laser);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLaserRelayEnergyExtreme.class, (TileEntitySpecialRenderer)laser);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLaserRelayItem.class, (TileEntitySpecialRenderer)laser);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLaserRelayItemWhitelist.class, (TileEntitySpecialRenderer)laser);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityLaserRelayFluids.class, (TileEntitySpecialRenderer)laser);
        for (Item item : COLOR_PRODIVIDING_ITEMS_FOR_REGISTERING) {
            if (!(item instanceof IColorProvidingItem)) continue;
            Minecraft.func_71410_x().getItemColors().func_186730_a(((IColorProvidingItem)item).getItemColor(), new Item[]{item});
        }
        for (Block block : COLOR_PRODIVIDING_BLOCKS_FOR_REGISTERING) {
            if (block instanceof IColorProvidingBlock) {
                Minecraft.func_71410_x().func_184125_al().func_186722_a(((IColorProvidingBlock)block).getBlockColor(), new Block[]{block});
            }
            if (!(block instanceof IColorProvidingItem)) continue;
            Minecraft.func_71410_x().getItemColors().func_186731_a(((IColorProvidingItem)block).getItemColor(), new Block[]{block});
        }
        IBlockColor color = (state, world, pos, tint) -> {
            TileEntity tileentity;
            if (world != null && pos != null && (tileentity = world.func_175625_s(pos)) instanceof TileEntityCompost && ((TileEntityCompost)tileentity).getCurrentDisplay().func_177230_c() != state.func_177230_c()) {
                IBlockState iblockstate = ((TileEntityCompost)tileentity).getCurrentDisplay();
                return Minecraft.func_71410_x().func_184125_al().func_186724_a(iblockstate, world, pos, tint);
            }
            return -1;
        };
        Minecraft.func_71410_x().func_184125_al().func_186722_a(color, new Block[]{InitBlocks.blockCompost});
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        ActuallyAdditions.LOGGER.info("PostInitializing ClientProxy...");
        new SpecialRenderInit();
    }

    @Override
    public void addRenderRegister(ItemStack stack, ResourceLocation location, String variant) {
        ClientRegistryHandler.MODEL_LOCATIONS_FOR_REGISTERING.put(stack, new ModelResourceLocation(location, variant));
    }

    @Override
    public void addColoredItem(Item item) {
        COLOR_PRODIVIDING_ITEMS_FOR_REGISTERING.add(item);
    }

    @Override
    public void addColoredBlock(Block block) {
        COLOR_PRODIVIDING_BLOCKS_FOR_REGISTERING.add(block);
    }

    @Override
    public EntityPlayer getCurrentPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void sendBreakPacket(BlockPos pos) {
        NetHandlerPlayClient netHandlerPlayClient = Minecraft.func_71410_x().func_147114_u();
        assert (netHandlerPlayClient != null);
        netHandlerPlayClient.func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
    }
}

