/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal;

import codechicken.lib.internal.CCLLog;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;

public class ModDescriptionEnhancer {
    private static boolean hasInit = false;
    private static Map<String, List<String>> supporters = new HashMap<String, List<String>>();
    private static Map<String, ModMetadata> mods = new HashMap<String, ModMetadata>();
    private static long lastDownload = 0L;
    private static boolean shouldDownload;

    public static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        File marker = new File("config/codechicken/supporters.marker");
        File supporters_file = new File("config/codechicken/supporters.json");
        shouldDownload = !supporters_file.exists();
        Date date = new Date();
        if (marker.exists()) {
            try {
                FileReader reader = new FileReader(marker);
                lastDownload = Long.valueOf(IOUtils.toString((Reader)reader));
                IOUtils.closeQuietly((Reader)reader);
            }
            catch (IOException e) {
                CCLLog.log(Level.WARN, "Error reading supporters marker file. Deleting..");
                marker.delete();
                lastDownload = 0L;
            }
        } else {
            shouldDownload = true;
            try {
                if (!marker.getParentFile().exists()) {
                    marker.getParentFile().mkdirs();
                }
                if (!marker.exists()) {
                    marker.createNewFile();
                }
                PrintWriter writer = new PrintWriter(new FileOutputStream(marker));
                writer.print(date.getTime());
                writer.flush();
                IOUtils.closeQuietly((Writer)writer);
            }
            catch (IOException e) {
                CCLLog.log(Level.WARN, e, (Object)"Error writing supporters marker file.");
            }
        }
        Thread thread = new Thread(() -> {
            try {
                if (shouldDownload || date.getTime() >= lastDownload + 86400000L) {
                    if (!supporters_file.exists()) {
                        supporters_file.createNewFile();
                    }
                    URL url = new URL("http://chickenbones.net/Files/supporters.json");
                    URLConnection connection = url.openConnection();
                    connection.setConnectTimeout(5000);
                    connection.setReadTimeout(5000);
                    connection.setRequestProperty("User-Agent", "CC Supporters Downloader.");
                    InputStream is = connection.getInputStream();
                    FileOutputStream fos = new FileOutputStream(supporters_file);
                    IOUtils.copy((InputStream)is, (OutputStream)fos);
                    IOUtils.closeQuietly((Closeable[])new Closeable[]{is, fos});
                }
                ModDescriptionEnhancer.parse(supporters_file);
                ModDescriptionEnhancer.applySupporters();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        thread.setDaemon(true);
        thread.setName("CC Supporters Downloader");
        thread.start();
    }

    private static void parse(File supporters_file) throws IOException {
        JsonReader reader = new JsonReader((Reader)new FileReader(supporters_file));
        reader.setLenient(true);
        JsonParser parser = new JsonParser();
        JsonArray array = parser.parse(reader).getAsJsonArray();
        for (JsonElement element : array) {
            JsonObject object = element.getAsJsonObject();
            String mod = object.get("mod").getAsString();
            ArrayList<String> supporters = new ArrayList<String>();
            for (JsonElement s : object.get("supporters").getAsJsonArray()) {
                supporters.add(s.getAsString());
            }
            ModDescriptionEnhancer.supporters.put(mod, supporters);
        }
    }

    private static void applySupporters() {
        for (Map.Entry<String, List<String>> entry : supporters.entrySet()) {
            if (!mods.containsKey(entry.getKey())) continue;
            ModMetadata metadata = mods.get(entry.getKey());
            String supporters_string = ModDescriptionEnhancer.generateList(entry.getValue());
            if (metadata.description.contains("<supporters>")) {
                metadata.description = metadata.description.replace("<supporters>", supporters_string);
                continue;
            }
            metadata.description = metadata.description + supporters_string;
        }
    }

    private static String generateList(List<String> supporters) {
        StringBuilder builder = new StringBuilder("\n");
        builder.append(TextFormatting.GOLD).append("Supporters:");
        for (String supporter : supporters) {
            builder.append("\n").append("    ");
            builder.append(TextFormatting.AQUA).append(supporter);
        }
        return builder.toString();
    }

    public static void registerEnhancement(String mod_id, String json_name) {
        mods.put(json_name, FMLCommonHandler.instance().findContainerFor((Object)mod_id).getMetadata());
    }

    @Deprecated
    public static void enhanceMod(Object mod) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        mc.getMetadata().description = ModDescriptionEnhancer.enhanceDesc(mc.getMetadata().description);
    }

    @Deprecated
    public static String enhanceDesc(String desc) {
        int supportersIdx = desc.indexOf("Supporters:");
        if (supportersIdx < 0) {
            return desc;
        }
        String supportersList = desc.substring(supportersIdx);
        supportersList = supportersList.replaceAll("\\b(\\w+)\\b", TextFormatting.AQUA + "$1");
        return desc.substring(0, supportersIdx) + supportersList;
    }
}

