/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client;

import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.item.ItemLayerWrapper;
import mekanism.generators.client.gui.GuiBioGenerator;
import mekanism.generators.client.gui.GuiGasGenerator;
import mekanism.generators.client.gui.GuiHeatGenerator;
import mekanism.generators.client.gui.GuiIndustrialTurbine;
import mekanism.generators.client.gui.GuiReactorController;
import mekanism.generators.client.gui.GuiReactorFuel;
import mekanism.generators.client.gui.GuiReactorHeat;
import mekanism.generators.client.gui.GuiReactorLogicAdapter;
import mekanism.generators.client.gui.GuiReactorStats;
import mekanism.generators.client.gui.GuiSolarGenerator;
import mekanism.generators.client.gui.GuiTurbineStats;
import mekanism.generators.client.gui.GuiWindGenerator;
import mekanism.generators.client.render.RenderAdvancedSolarGenerator;
import mekanism.generators.client.render.RenderBioGenerator;
import mekanism.generators.client.render.RenderGasGenerator;
import mekanism.generators.client.render.RenderHeatGenerator;
import mekanism.generators.client.render.RenderIndustrialTurbine;
import mekanism.generators.client.render.RenderReactor;
import mekanism.generators.client.render.RenderSolarGenerator;
import mekanism.generators.client.render.RenderTurbineRotor;
import mekanism.generators.client.render.RenderWindGenerator;
import mekanism.generators.client.render.item.RenderGeneratorItem;
import mekanism.generators.common.GeneratorsBlocks;
import mekanism.generators.common.GeneratorsCommonProxy;
import mekanism.generators.common.GeneratorsItems;
import mekanism.generators.common.block.states.BlockStateGenerator;
import mekanism.generators.common.block.states.BlockStateReactor;
import mekanism.generators.common.tile.TileEntityAdvancedSolarGenerator;
import mekanism.generators.common.tile.TileEntityBioGenerator;
import mekanism.generators.common.tile.TileEntityGasGenerator;
import mekanism.generators.common.tile.TileEntityHeatGenerator;
import mekanism.generators.common.tile.TileEntitySolarGenerator;
import mekanism.generators.common.tile.TileEntityWindGenerator;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import mekanism.generators.common.tile.reactor.TileEntityReactorLogicAdapter;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import mekanism.generators.common.tile.turbine.TileEntityTurbineRotor;
import mekanism.generators.common.tile.turbine.TileEntityTurbineValve;
import mekanism.generators.common.tile.turbine.TileEntityTurbineVent;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GeneratorsClientProxy
extends GeneratorsCommonProxy {
    private static final IStateMapper generatorMapper = new BlockStateGenerator.GeneratorBlockStateMapper();
    private static final IStateMapper reactorMapper = new BlockStateReactor.ReactorBlockStateMapper();

    @Override
    public void registerTESRs() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityAdvancedSolarGenerator.class, (TileEntitySpecialRenderer)new RenderAdvancedSolarGenerator());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBioGenerator.class, (TileEntitySpecialRenderer)new RenderBioGenerator());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGasGenerator.class, (TileEntitySpecialRenderer)new RenderGasGenerator());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityHeatGenerator.class, (TileEntitySpecialRenderer)new RenderHeatGenerator());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityReactorController.class, (TileEntitySpecialRenderer)new RenderReactor());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySolarGenerator.class, (TileEntitySpecialRenderer)new RenderSolarGenerator());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTurbineCasing.class, (TileEntitySpecialRenderer)new RenderIndustrialTurbine());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTurbineRotor.class, (TileEntitySpecialRenderer)new RenderTurbineRotor());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTurbineValve.class, (TileEntitySpecialRenderer)new RenderIndustrialTurbine());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTurbineVent.class, (TileEntitySpecialRenderer)new RenderIndustrialTurbine());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWindGenerator.class, (TileEntitySpecialRenderer)new RenderWindGenerator());
    }

    @Override
    public void registerItemRenders() {
        this.registerItemRender(GeneratorsItems.SolarPanel);
        this.registerItemRender((Item)GeneratorsItems.Hohlraum);
        this.registerItemRender(GeneratorsItems.TurbineBlade);
        Item.func_150898_a((Block)GeneratorsBlocks.Generator).setTileEntityItemStackRenderer((TileEntityItemStackRenderer)new RenderGeneratorItem());
    }

    @Override
    public void registerBlockRenders() {
        ModelLoader.setCustomStateMapper((Block)GeneratorsBlocks.Generator, (IStateMapper)generatorMapper);
        ModelLoader.setCustomStateMapper((Block)GeneratorsBlocks.Reactor, (IStateMapper)reactorMapper);
        ModelLoader.setCustomStateMapper((Block)GeneratorsBlocks.ReactorGlass, (IStateMapper)reactorMapper);
        for (BlockStateGenerator.GeneratorType generatorType : BlockStateGenerator.GeneratorType.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)generatorType.blockType.getBlock()), (int)generatorType.meta, (ModelResourceLocation)new ModelResourceLocation("mekanismgenerators:" + generatorType.func_176610_l(), "inventory"));
        }
        for (Enum enum_ : BlockStateReactor.ReactorBlockType.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)((BlockStateReactor.ReactorBlockType)enum_).blockType.getBlock()), (int)((BlockStateReactor.ReactorBlockType)enum_).meta, (ModelResourceLocation)new ModelResourceLocation("mekanismgenerators:" + ((BlockStateReactor.ReactorBlockType)enum_).func_176610_l(), "inventory"));
        }
    }

    public void registerItemRender(Item item) {
        MekanismRenderer.registerItemRender((String)"mekanismgenerators", (Item)item);
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        IRegistry modelRegistry = event.getModelRegistry();
        this.generatorModelBake((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, BlockStateGenerator.GeneratorType.HEAT_GENERATOR);
        this.generatorModelBake((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, BlockStateGenerator.GeneratorType.SOLAR_GENERATOR);
        this.generatorModelBake((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, BlockStateGenerator.GeneratorType.BIO_GENERATOR);
        this.generatorModelBake((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, BlockStateGenerator.GeneratorType.WIND_GENERATOR);
        this.generatorModelBake((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, BlockStateGenerator.GeneratorType.GAS_GENERATOR);
        this.generatorModelBake((IRegistry<ModelResourceLocation, IBakedModel>)modelRegistry, BlockStateGenerator.GeneratorType.ADVANCED_SOLAR_GENERATOR);
    }

    private void generatorModelBake(IRegistry<ModelResourceLocation, IBakedModel> modelRegistry, BlockStateGenerator.GeneratorType type) {
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation("mekanismgenerators:" + type.func_176610_l(), "inventory");
        ItemLayerWrapper itemLayerWrapper = new ItemLayerWrapper((IBakedModel)modelRegistry.func_82594_a((Object)modelResourceLocation));
        RenderGeneratorItem.modelMap.put(type, itemLayerWrapper);
        modelRegistry.func_82595_a((Object)modelResourceLocation, (Object)itemLayerWrapper);
    }

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public GuiScreen getClientGui(int ID, EntityPlayer player, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        switch (ID) {
            case 0: {
                return new GuiHeatGenerator(player.field_71071_by, (TileEntityHeatGenerator)tileEntity);
            }
            case 1: {
                return new GuiSolarGenerator(player.field_71071_by, (TileEntitySolarGenerator)tileEntity);
            }
            case 3: {
                return new GuiGasGenerator(player.field_71071_by, (TileEntityGasGenerator)tileEntity);
            }
            case 4: {
                return new GuiBioGenerator(player.field_71071_by, (TileEntityBioGenerator)tileEntity);
            }
            case 5: {
                return new GuiWindGenerator(player.field_71071_by, (TileEntityWindGenerator)tileEntity);
            }
            case 6: {
                return new GuiIndustrialTurbine(player.field_71071_by, (TileEntityTurbineCasing)tileEntity);
            }
            case 7: {
                return new GuiTurbineStats(player.field_71071_by, (TileEntityTurbineCasing)tileEntity);
            }
            case 10: {
                return new GuiReactorController(player.field_71071_by, (TileEntityReactorController)tileEntity);
            }
            case 11: {
                return new GuiReactorHeat(player.field_71071_by, (TileEntityReactorController)tileEntity);
            }
            case 12: {
                return new GuiReactorFuel(player.field_71071_by, (TileEntityReactorController)tileEntity);
            }
            case 13: {
                return new GuiReactorStats(player.field_71071_by, (TileEntityReactorController)tileEntity);
            }
            case 15: {
                return new GuiReactorLogicAdapter(player.field_71071_by, (TileEntityReactorLogicAdapter)tileEntity);
            }
        }
        return null;
    }

    @SubscribeEvent
    public void onStitch(TextureStitchEvent.Pre event) {
    }
}

