/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui;

import java.text.DecimalFormat;
import java.util.Arrays;
import mekanism.api.EnumColor;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.gui.element.GuiSlot;
import mekanism.common.config.MekanismConfig;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.inventory.container.ContainerWindGenerator;
import mekanism.generators.common.tile.TileEntityWindGenerator;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiWindGenerator
extends GuiMekanismTile<TileEntityWindGenerator> {
    private DecimalFormat powerFormat = new DecimalFormat("0.##");

    public GuiWindGenerator(InventoryPlayer inventory, TileEntityWindGenerator tile) {
        super((TileEntityContainerBlock)tile, (Container)new ContainerWindGenerator(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement((GuiElement)new GuiRedstoneControl((IGuiWrapper)this, (TileEntity)this.tileEntity, resource));
        this.addGuiElement((GuiElement)new GuiSecurityTab((IGuiWrapper)this, (TileEntity)this.tileEntity, resource));
        this.addGuiElement((GuiElement)new GuiEnergyInfo(() -> Arrays.asList(LangUtils.localize((String)"gui.producing") + ": " + MekanismUtils.getEnergyDisplay((double)(((TileEntityWindGenerator)this.tileEntity).getActive() ? MekanismConfig.generators.windGenerationMin * (double)((TileEntityWindGenerator)this.tileEntity).getCurrentMultiplier() : 0.0)) + "/t", LangUtils.localize((String)"gui.maxOutput") + ": " + MekanismUtils.getEnergyDisplay((double)((TileEntityWindGenerator)this.tileEntity).getMaxOutput()) + "/t"), (IGuiWrapper)this, resource));
        this.addGuiElement((GuiElement)new GuiPowerBar((IGuiWrapper)this, (IStrictEnergyStorage)this.tileEntity, resource, 164, 15));
        this.addGuiElement((GuiElement)new GuiSlot(GuiSlot.SlotType.NORMAL, (IGuiWrapper)this, resource, 142, 34).with(GuiSlot.SlotOverlay.POWER));
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityWindGenerator)this.tileEntity).func_70005_c_(), 45, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize((String)"container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        this.field_146289_q.func_78276_b(MekanismUtils.getEnergyDisplay((double)((TileEntityWindGenerator)this.tileEntity).getEnergy(), (double)((TileEntityWindGenerator)this.tileEntity).getMaxEnergy()), 51, 26, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize((String)"gui.power") + ": " + this.powerFormat.format(MekanismUtils.convertToDisplay((double)(MekanismConfig.generators.windGenerationMin * (double)((TileEntityWindGenerator)this.tileEntity).getCurrentMultiplier()))), 51, 35, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize((String)"gui.out") + ": " + MekanismUtils.getEnergyDisplay((double)((TileEntityWindGenerator)this.tileEntity).getMaxOutput()) + "/t", 51, 44, 52480);
        int size = 44;
        if (!((TileEntityWindGenerator)this.tileEntity).getActive()) {
            size += 9;
            String reason = "gui.skyBlocked";
            if (((TileEntityWindGenerator)this.tileEntity).isBlacklistDimension()) {
                reason = "gui.noWind";
            }
            this.field_146289_q.func_78276_b(EnumColor.DARK_RED + LangUtils.localize((String)reason), 51, size, 52480);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(this.getGuiLocation());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(guiWidth + 20, guiHeight + 37, 176, ((TileEntityWindGenerator)this.tileEntity).getActive() ? 52 : 64, 12, 12);
        super.func_146976_a(partialTick, mouseX, mouseY);
    }

    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)"GuiWindTurbine.png");
    }
}

