/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import io.netty.buffer.ByteBuf;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityWindGenerator
extends TileEntityGenerator
implements IBoundingBlock {
    public static final float SPEED = 32.0f;
    public static final float SPEED_SCALED = 8.0f;
    static final String[] methods = new String[]{"getEnergy", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getMultiplier"};
    private double angle;
    private float currentMultiplier;
    private boolean isBlacklistDimension = false;

    public TileEntityWindGenerator() {
        super("wind", "WindGenerator", 200000.0, MekanismConfig.generators.windGenerationMax * 2.0);
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    }

    public void onLoad() {
        super.onLoad();
        this.isBlacklistDimension = MekanismConfig.generators.windGenerationDimBlacklist.contains(this.field_145850_b.field_73011_w.getDimension());
        if (this.isBlacklistDimension) {
            this.setActive(false);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.charge((int)0, (IStrictEnergyStorage)this);
            if (this.isBlacklistDimension) {
                return;
            }
            if (this.ticker % 20 == 0) {
                this.currentMultiplier = this.getMultiplier();
                this.setActive(this.currentMultiplier > 0.0f);
            }
            if (this.getActive()) {
                this.setEnergy(this.electricityStored + MekanismConfig.generators.windGenerationMin * (double)this.currentMultiplier);
            }
        } else if (this.getActive()) {
            this.angle = (this.angle + (double)(((float)this.func_174877_v().func_177956_o() + 4.0f) / 8.0f)) % 360.0;
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            this.currentMultiplier = dataStream.readFloat();
            this.isBlacklistDimension = dataStream.readBoolean();
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add((Object)Float.valueOf(this.currentMultiplier));
        data.add((Object)this.isBlacklistDimension);
        return data;
    }

    public float getMultiplier() {
        if (this.field_145850_b.func_175678_i(this.func_174877_v().func_177982_a(0, 4, 0))) {
            float minY = MekanismConfig.generators.windGenerationMinY;
            float maxY = MekanismConfig.generators.windGenerationMaxY;
            float minG = (float)MekanismConfig.generators.windGenerationMin;
            float maxG = (float)MekanismConfig.generators.windGenerationMax;
            float slope = (maxG - minG) / (maxY - minY);
            float intercept = minG - slope * minY;
            float clampedY = Math.min(maxY, Math.max(minY, (float)(this.func_174877_v().func_177956_o() + 4)));
            float toGen = slope * clampedY + intercept;
            return toGen / minG;
        }
        return 0.0f;
    }

    protected float getInitialVolume() {
        return 1.5f * super.getInitialVolume();
    }

    public String[] getMethods() {
        return methods;
    }

    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.BASE_MAX_ENERGY};
            }
            case 3: {
                return new Object[]{this.BASE_MAX_ENERGY - this.electricityStored};
            }
            case 4: {
                return new Object[]{Float.valueOf(this.getMultiplier())};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public boolean canOperate() {
        return this.electricityStored < this.BASE_MAX_ENERGY && this.getMultiplier() > 0.0f && MekanismUtils.canFunction((TileEntity)this);
    }

    public void onPlace() {
        Coord4D current = Coord4D.get((TileEntity)this);
        MekanismUtils.makeBoundingBlock((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177967_a(EnumFacing.UP, 1), (Coord4D)current);
        MekanismUtils.makeBoundingBlock((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177967_a(EnumFacing.UP, 2), (Coord4D)current);
        MekanismUtils.makeBoundingBlock((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177967_a(EnumFacing.UP, 3), (Coord4D)current);
        MekanismUtils.makeBoundingBlock((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177967_a(EnumFacing.UP, 4), (Coord4D)current);
        this.isBlacklistDimension = MekanismConfig.generators.windGenerationDimBlacklist.contains(this.field_145850_b.field_73011_w.getDimension());
    }

    public void onBreak() {
        this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(0, 1, 0));
        this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(0, 2, 0));
        this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(0, 3, 0));
        this.field_145850_b.func_175698_g(this.func_174877_v().func_177982_a(0, 4, 0));
        this.field_145850_b.func_175698_g(this.func_174877_v());
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    public float getCurrentMultiplier() {
        return this.currentMultiplier;
    }

    public double getAngle() {
        return this.angle;
    }

    public boolean isBlacklistDimension() {
        return this.isBlacklistDimension;
    }
}

