/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.reactor;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismFluids;
import mekanism.common.base.IActiveState;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TileUtils;
import mekanism.generators.common.FusionReactor;
import mekanism.generators.common.tile.reactor.TileEntityReactorBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityReactorController
extends TileEntityReactorBlock
implements IActiveState {
    public static final int MAX_WATER = 100000;
    public static final int MAX_STEAM = 10000000;
    public static final int MAX_FUEL = 1000;
    public FluidTank waterTank = new FluidTank(100000);
    public FluidTank steamTank = new FluidTank(10000000);
    public GasTank deuteriumTank = new GasTank(1000);
    public GasTank tritiumTank = new GasTank(1000);
    public GasTank fuelTank = new GasTank(1000);
    public AxisAlignedBB box;
    public double clientTemp = 0.0;
    public boolean clientBurning = false;
    private SoundEvent soundEvent = new SoundEvent(new ResourceLocation("mekanism", "tile.machine.fusionreactor"));
    @SideOnly(value=Side.CLIENT)
    private ISound activeSound;
    private int playSoundCooldown = 0;

    public TileEntityReactorController() {
        super("ReactorController", 1.0E9);
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    }

    @Override
    public boolean isFrame() {
        return false;
    }

    public void radiateNeutrons(int neutrons) {
    }

    public void formMultiblock(boolean keepBurning) {
        if (this.getReactor() == null) {
            this.setReactor(new FusionReactor(this));
        }
        this.getReactor().formMultiblock(keepBurning);
    }

    public double getPlasmaTemp() {
        if (this.getReactor() == null || !this.getReactor().isFormed()) {
            return 0.0;
        }
        return this.getReactor().getPlasmaTemp();
    }

    public double getCaseTemp() {
        if (this.getReactor() == null || !this.getReactor().isFormed()) {
            return 0.0;
        }
        return this.getReactor().getCaseTemp();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K) {
            this.updateSound();
        }
        if (this.isFormed()) {
            this.getReactor().simulate();
            if (!this.field_145850_b.field_72995_K && (this.getReactor().isBurning() != this.clientBurning || Math.abs(this.getReactor().getPlasmaTemp() - this.clientTemp) > 1000000.0)) {
                Mekanism.packetHandler.sendToAllAround((IMessage)new PacketTileEntity.TileEntityMessage(Coord4D.get((TileEntity)this), this.getNetworkedData(new TileNetworkList())), Coord4D.get((TileEntity)this).getTargetPoint(50.0));
                this.clientBurning = this.getReactor().isBurning();
                this.clientTemp = this.getReactor().getPlasmaTemp();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSound() {
        if (!MekanismConfig.client.enableMachineSounds) {
            return;
        }
        if (this.isBurning() && !this.func_145837_r()) {
            if (--this.playSoundCooldown > 0) {
                return;
            }
            if (this.activeSound == null || !Minecraft.func_71410_x().func_147118_V().func_147692_c(this.activeSound)) {
                this.activeSound = SoundHandler.startTileSound((ResourceLocation)this.soundEvent.func_187503_a(), (float)1.0f, (BlockPos)this.func_174877_v());
                this.playSoundCooldown = 20;
            }
        } else if (this.activeSound != null) {
            SoundHandler.stopTileSound((BlockPos)this.func_174877_v());
            this.activeSound = null;
            this.playSoundCooldown = 0;
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.updateSound();
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.formMultiblock(true);
    }

    @Override
    public void onAdded() {
        super.onAdded();
        this.formMultiblock(false);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("formed", this.isFormed());
        if (this.isFormed()) {
            tag.func_74780_a("plasmaTemp", this.getReactor().getPlasmaTemp());
            tag.func_74780_a("caseTemp", this.getReactor().getCaseTemp());
            tag.func_74768_a("injectionRate", this.getReactor().getInjectionRate());
            tag.func_74757_a("burning", this.getReactor().isBurning());
        } else {
            tag.func_74780_a("plasmaTemp", 0.0);
            tag.func_74780_a("caseTemp", 0.0);
            tag.func_74768_a("injectionRate", 0);
            tag.func_74757_a("burning", false);
        }
        tag.func_74782_a("fuelTank", (NBTBase)this.fuelTank.write(new NBTTagCompound()));
        tag.func_74782_a("deuteriumTank", (NBTBase)this.deuteriumTank.write(new NBTTagCompound()));
        tag.func_74782_a("tritiumTank", (NBTBase)this.tritiumTank.write(new NBTTagCompound()));
        tag.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("steamTank", (NBTBase)this.steamTank.writeToNBT(new NBTTagCompound()));
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        boolean formed = tag.func_74767_n("formed");
        if (formed) {
            this.setReactor(new FusionReactor(this));
            this.getReactor().setPlasmaTemp(tag.func_74769_h("plasmaTemp"));
            this.getReactor().setCaseTemp(tag.func_74769_h("caseTemp"));
            this.getReactor().setInjectionRate(tag.func_74762_e("injectionRate"));
            this.getReactor().setBurning(tag.func_74767_n("burning"));
            this.getReactor().updateTemperatures();
        }
        this.fuelTank.read(tag.func_74775_l("fuelTank"));
        this.deuteriumTank.read(tag.func_74775_l("deuteriumTank"));
        this.tritiumTank.read(tag.func_74775_l("tritiumTank"));
        this.waterTank.readFromNBT(tag.func_74775_l("waterTank"));
        this.steamTank.readFromNBT(tag.func_74775_l("steamTank"));
    }

    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add((Object)(this.getReactor() != null && this.getReactor().isFormed() ? 1 : 0));
        if (this.getReactor() != null) {
            data.add((Object)this.getReactor().getPlasmaTemp());
            data.add((Object)this.getReactor().getCaseTemp());
            data.add((Object)this.getReactor().getInjectionRate());
            data.add((Object)this.getReactor().isBurning());
            data.add((Object)this.fuelTank.getStored());
            data.add((Object)this.deuteriumTank.getStored());
            data.add((Object)this.tritiumTank.getStored());
            TileUtils.addTankData((TileNetworkList)data, (FluidTank)this.waterTank);
            TileUtils.addTankData((TileNetworkList)data, (FluidTank)this.steamTank);
        }
        return data;
    }

    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int type = dataStream.readInt();
            if (type == 0 && this.getReactor() != null) {
                this.getReactor().setInjectionRate(dataStream.readInt());
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            boolean formed = dataStream.readBoolean();
            if (formed) {
                if (this.getReactor() == null || !this.getReactor().formed) {
                    Mekanism.proxy.doGenericSparkle((TileEntity)this, tile -> tile instanceof TileEntityReactorBlock);
                }
                if (this.getReactor() == null) {
                    this.setReactor(new FusionReactor(this));
                    MekanismUtils.updateBlock((World)this.field_145850_b, (BlockPos)this.func_174877_v());
                }
                this.getReactor().formed = true;
                this.getReactor().setPlasmaTemp(dataStream.readDouble());
                this.getReactor().setCaseTemp(dataStream.readDouble());
                this.getReactor().setInjectionRate(dataStream.readInt());
                this.getReactor().setBurning(dataStream.readBoolean());
                this.fuelTank.setGas(new GasStack(MekanismFluids.FusionFuel, dataStream.readInt()));
                this.deuteriumTank.setGas(new GasStack(MekanismFluids.Deuterium, dataStream.readInt()));
                this.tritiumTank.setGas(new GasStack(MekanismFluids.Tritium, dataStream.readInt()));
                TileUtils.readTankData((ByteBuf)dataStream, (FluidTank)this.waterTank);
                TileUtils.readTankData((ByteBuf)dataStream, (FluidTank)this.steamTank);
            } else if (this.getReactor() != null) {
                this.setReactor(null);
                MekanismUtils.updateBlock((World)this.field_145850_b, (BlockPos)this.func_174877_v());
            }
        }
    }

    public boolean isFormed() {
        return this.getReactor() != null && this.getReactor().isFormed();
    }

    public boolean isBurning() {
        return this.getActive() && this.getReactor().isBurning();
    }

    public boolean getActive() {
        return this.isFormed();
    }

    public void setActive(boolean active) {
        if (active == (this.getReactor() == null)) {
            this.setReactor(active ? new FusionReactor(this) : null);
        }
    }

    public boolean renderUpdate() {
        return true;
    }

    public boolean lightUpdate() {
        return false;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.box == null) {
            this.box = new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 1), (double)(this.func_174877_v().func_177956_o() - 3), (double)(this.func_174877_v().func_177952_p() - 1), (double)(this.func_174877_v().func_177958_n() + 2), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() + 2));
        }
        return this.box;
    }
}

