/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import mekanism.api.IClientTicker;
import mekanism.api.gas.GasStack;
import mekanism.client.HolidayManager;
import mekanism.client.MekanismClient;
import mekanism.client.render.RenderTickHandler;
import mekanism.common.CommonPlayerTickHandler;
import mekanism.common.KeySync;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.frequency.Frequency;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.ItemFlamethrower;
import mekanism.common.item.ItemFreeRunners;
import mekanism.common.item.ItemGasMask;
import mekanism.common.item.ItemJetpack;
import mekanism.common.item.ItemScubaTank;
import mekanism.common.network.PacketFreeRunnerData;
import mekanism.common.network.PacketItemStack;
import mekanism.common.network.PacketPortableTeleporter;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientTickHandler {
    public static Minecraft mc = FMLClientHandler.instance().getClient();
    public static Random rand = new Random();
    public static Set<IClientTicker> tickingSet = new HashSet<IClientTicker>();
    public static Map<EntityPlayer, TeleportData> portableTeleports = new HashMap<EntityPlayer, TeleportData>();
    public static int wheelStatus = 0;
    public boolean initHoliday = false;
    public boolean shouldReset = false;

    public static void killDeadNetworks() {
        tickingSet.removeIf(iClientTicker -> !iClientTicker.needsTicks());
    }

    public static boolean isJetpackActive(EntityPlayer player) {
        ItemJetpack jetpack;
        if (player != ClientTickHandler.mc.field_71439_g) {
            return Mekanism.playerState.isJetpackOn(player);
        }
        ItemStack stack = (ItemStack)player.field_71071_by.field_70460_b.get(2);
        if (!stack.func_190926_b() && !player.func_184812_l_() && !player.func_175149_v() && stack.func_77973_b() instanceof ItemJetpack && (jetpack = (ItemJetpack)stack.func_77973_b()).getGas(stack) != null) {
            if (ClientTickHandler.mc.field_71474_y.field_74314_A.func_151470_d() && jetpack.getMode(stack) == ItemJetpack.JetpackMode.NORMAL && ClientTickHandler.mc.field_71462_r == null) {
                return true;
            }
            if (jetpack.getMode(stack) == ItemJetpack.JetpackMode.HOVER) {
                if (!ClientTickHandler.mc.field_71474_y.field_74314_A.func_151470_d() && !ClientTickHandler.mc.field_71474_y.field_74311_E.func_151470_d() || ClientTickHandler.mc.field_71474_y.field_74314_A.func_151470_d() && ClientTickHandler.mc.field_71474_y.field_74311_E.func_151470_d() || ClientTickHandler.mc.field_71462_r != null) {
                    return !CommonPlayerTickHandler.isOnGround(player);
                }
                if (ClientTickHandler.mc.field_71474_y.field_74311_E.func_151470_d() && ClientTickHandler.mc.field_71462_r == null) {
                    return !CommonPlayerTickHandler.isOnGround(player);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isGasMaskOn(EntityPlayer player) {
        ItemScubaTank scubaTank;
        if (player != ClientTickHandler.mc.field_71439_g) {
            return Mekanism.playerState.isGasmaskOn(player);
        }
        ItemStack tank = (ItemStack)player.field_71071_by.field_70460_b.get(2);
        ItemStack mask = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        if (!tank.func_190926_b() && !mask.func_190926_b() && tank.func_77973_b() instanceof ItemScubaTank && mask.func_77973_b() instanceof ItemGasMask && (scubaTank = (ItemScubaTank)tank.func_77973_b()).getGas(tank) != null) {
            return scubaTank.getFlowing(tank);
        }
        return false;
    }

    public static boolean isFreeRunnerOn(EntityPlayer player) {
        if (player != ClientTickHandler.mc.field_71439_g) {
            return Mekanism.freeRunnerOn.contains(player.func_70005_c_());
        }
        ItemStack stack = player.func_184582_a(EntityEquipmentSlot.FEET);
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemFreeRunners) {
            ItemFreeRunners freeRunners = (ItemFreeRunners)stack.func_77973_b();
            return freeRunners.getMode(stack) == ItemFreeRunners.FreeRunnerMode.NORMAL;
        }
        return false;
    }

    public static boolean isFlamethrowerOn(EntityPlayer player) {
        if (player != ClientTickHandler.mc.field_71439_g) {
            return Mekanism.playerState.isFlamethrowerOn(player);
        }
        if (ClientTickHandler.hasFlamethrower(player)) {
            return ClientTickHandler.mc.field_71474_y.field_74313_G.func_151470_d();
        }
        return false;
    }

    public static boolean hasFlamethrower(EntityPlayer player) {
        if (!player.field_71071_by.func_70448_g().func_190926_b() && player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemFlamethrower) {
            ItemFlamethrower flamethrower = (ItemFlamethrower)player.field_71071_by.func_70448_g().func_77973_b();
            return flamethrower.getGas(player.field_71071_by.func_70448_g()) != null;
        }
        return false;
    }

    public static void portableTeleport(EntityPlayer player, EnumHand hand, Frequency freq) {
        if (MekanismConfig.general.portableTeleporterDelay == 0) {
            Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.TELEPORT, hand, freq));
        } else {
            portableTeleports.put(player, new TeleportData(hand, freq, ClientTickHandler.mc.field_71441_e.func_72820_D() + (long)MekanismConfig.general.portableTeleporterDelay));
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.tickStart();
        }
    }

    public void tickStart() {
        ++MekanismClient.ticksPassed;
        if (!Mekanism.proxy.isPaused()) {
            Iterator<IClientTicker> iter = tickingSet.iterator();
            while (iter.hasNext()) {
                IClientTicker ticker = iter.next();
                if (ticker.needsTicks()) {
                    ticker.clientTick();
                    continue;
                }
                iter.remove();
            }
        }
        if (ClientTickHandler.mc.field_71441_e != null) {
            this.shouldReset = true;
        } else if (this.shouldReset) {
            MekanismClient.reset();
            this.shouldReset = false;
        }
        if (ClientTickHandler.mc.field_71441_e != null && ClientTickHandler.mc.field_71439_g != null && !Mekanism.proxy.isPaused()) {
            ItemStack bootStack;
            if (!(this.initHoliday && MekanismClient.ticksPassed % 1200L != 0L || ClientTickHandler.mc.field_71439_g == null)) {
                HolidayManager.check();
                this.initHoliday = true;
            }
            if (Mekanism.freeRunnerOn.contains(ClientTickHandler.mc.field_71439_g.func_70005_c_()) != ClientTickHandler.isFreeRunnerOn((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                if (ClientTickHandler.isFreeRunnerOn((EntityPlayer)ClientTickHandler.mc.field_71439_g) && ClientTickHandler.mc.field_71462_r == null) {
                    Mekanism.freeRunnerOn.add(ClientTickHandler.mc.field_71439_g.func_70005_c_());
                } else {
                    Mekanism.freeRunnerOn.remove(ClientTickHandler.mc.field_71439_g.func_70005_c_());
                }
                Mekanism.packetHandler.sendToServer(new PacketFreeRunnerData.FreeRunnerDataMessage(PacketFreeRunnerData.FreeRunnerPacket.UPDATE, ClientTickHandler.mc.field_71439_g.func_70005_c_(), ClientTickHandler.isFreeRunnerOn((EntityPlayer)ClientTickHandler.mc.field_71439_g)));
            }
            if (!(bootStack = ClientTickHandler.mc.field_71439_g.func_184582_a(EntityEquipmentSlot.FEET)).func_190926_b() && bootStack.func_77973_b() instanceof ItemFreeRunners && ClientTickHandler.isFreeRunnerOn((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                ClientTickHandler.mc.field_71439_g.field_70138_W = 1.002f;
            } else if (ClientTickHandler.mc.field_71439_g.field_70138_W == 1.002f) {
                ClientTickHandler.mc.field_71439_g.field_70138_W = 0.6f;
            }
            Mekanism.playerState.setJetpackState(ClientTickHandler.mc.field_71439_g.func_70005_c_(), ClientTickHandler.isJetpackActive((EntityPlayer)ClientTickHandler.mc.field_71439_g), true);
            Mekanism.playerState.setGasmaskState(ClientTickHandler.mc.field_71439_g.func_70005_c_(), ClientTickHandler.isGasMaskOn((EntityPlayer)ClientTickHandler.mc.field_71439_g), true);
            Mekanism.playerState.setFlamethrowerState(ClientTickHandler.mc.field_71439_g.func_70005_c_(), ClientTickHandler.isFlamethrowerOn((EntityPlayer)ClientTickHandler.mc.field_71439_g), true);
            Iterator<Map.Entry<EntityPlayer, TeleportData>> iter = portableTeleports.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<EntityPlayer, TeleportData> entry = iter.next();
                for (int i = 0; i < 100; ++i) {
                    double x = entry.getKey().field_70165_t + rand.nextDouble() - 0.5;
                    double y = entry.getKey().field_70163_u + rand.nextDouble() * 2.0 - 2.0;
                    double z = entry.getKey().field_70161_v + rand.nextDouble() - 0.5;
                    ClientTickHandler.mc.field_71441_e.func_175688_a(EnumParticleTypes.PORTAL, x, y, z, 0.0, 1.0, 0.0, new int[0]);
                }
                if (ClientTickHandler.mc.field_71441_e.func_72820_D() != entry.getValue().teleportTime) continue;
                Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.TELEPORT, entry.getValue().hand, entry.getValue().freq));
                iter.remove();
            }
            ItemStack chestStack = ClientTickHandler.mc.field_71439_g.func_184582_a(EntityEquipmentSlot.CHEST);
            if (!chestStack.func_190926_b() && chestStack.func_77973_b() instanceof ItemJetpack) {
                MekanismClient.updateKey(ClientTickHandler.mc.field_71474_y.field_74314_A, KeySync.ASCEND);
                MekanismClient.updateKey(ClientTickHandler.mc.field_71474_y.field_74311_E, KeySync.DESCEND);
            }
            if (ClientTickHandler.isFlamethrowerOn((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                ItemFlamethrower flamethrower = (ItemFlamethrower)ClientTickHandler.mc.field_71439_g.field_71071_by.func_70448_g().func_77973_b();
                if (!ClientTickHandler.mc.field_71439_g.func_184812_l_() && !ClientTickHandler.mc.field_71439_g.func_175149_v()) {
                    flamethrower.useGas(ClientTickHandler.mc.field_71439_g.field_71071_by.func_70448_g());
                }
            }
            if (ClientTickHandler.isJetpackActive((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                ItemJetpack jetpack = (ItemJetpack)chestStack.func_77973_b();
                if (jetpack.getMode(chestStack) == ItemJetpack.JetpackMode.NORMAL) {
                    ClientTickHandler.mc.field_71439_g.field_70181_x = Math.min(ClientTickHandler.mc.field_71439_g.field_70181_x + 0.15, 0.5);
                    ClientTickHandler.mc.field_71439_g.field_70143_R = 0.0f;
                } else if (jetpack.getMode(chestStack) == ItemJetpack.JetpackMode.HOVER) {
                    if (!ClientTickHandler.mc.field_71474_y.field_74314_A.func_151470_d() && !ClientTickHandler.mc.field_71474_y.field_74311_E.func_151470_d() || ClientTickHandler.mc.field_71474_y.field_74314_A.func_151470_d() && ClientTickHandler.mc.field_71474_y.field_74311_E.func_151470_d() || ClientTickHandler.mc.field_71462_r != null) {
                        if (ClientTickHandler.mc.field_71439_g.field_70181_x > 0.0) {
                            ClientTickHandler.mc.field_71439_g.field_70181_x = Math.max(ClientTickHandler.mc.field_71439_g.field_70181_x - 0.15, 0.0);
                        } else if (ClientTickHandler.mc.field_71439_g.field_70181_x < 0.0 && !CommonPlayerTickHandler.isOnGround((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                            ClientTickHandler.mc.field_71439_g.field_70181_x = Math.min(ClientTickHandler.mc.field_71439_g.field_70181_x + 0.15, 0.0);
                        }
                    } else if (ClientTickHandler.mc.field_71474_y.field_74314_A.func_151470_d() && ClientTickHandler.mc.field_71462_r == null) {
                        ClientTickHandler.mc.field_71439_g.field_70181_x = Math.min(ClientTickHandler.mc.field_71439_g.field_70181_x + 0.15, 0.2);
                    } else if (ClientTickHandler.mc.field_71474_y.field_74311_E.func_151470_d() && ClientTickHandler.mc.field_71462_r == null && !CommonPlayerTickHandler.isOnGround((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                        ClientTickHandler.mc.field_71439_g.field_70181_x = Math.max(ClientTickHandler.mc.field_71439_g.field_70181_x - 0.15, -0.2);
                    }
                    ClientTickHandler.mc.field_71439_g.field_70143_R = 0.0f;
                }
                jetpack.useGas(chestStack);
            }
            if (ClientTickHandler.isGasMaskOn((EntityPlayer)ClientTickHandler.mc.field_71439_g)) {
                ItemScubaTank tank = (ItemScubaTank)chestStack.func_77973_b();
                int max = 300;
                tank.useGas(chestStack);
                GasStack received = tank.useGas(chestStack, 300 - ClientTickHandler.mc.field_71439_g.func_70086_ai());
                if (received != null) {
                    ClientTickHandler.mc.field_71439_g.func_70050_g(ClientTickHandler.mc.field_71439_g.func_70086_ai() + received.amount);
                }
                if (ClientTickHandler.mc.field_71439_g.func_70086_ai() == 300) {
                    for (Object obj : ClientTickHandler.mc.field_71439_g.func_70651_bq()) {
                        if (!(obj instanceof PotionEffect)) continue;
                        for (int i = 0; i < 9; ++i) {
                            ((PotionEffect)obj).func_76455_a((EntityLivingBase)ClientTickHandler.mc.field_71439_g);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        if (MekanismConfig.client.allowConfiguratorModeScroll && ClientTickHandler.mc.field_71439_g != null && ClientTickHandler.mc.field_71439_g.func_70093_af()) {
            ItemStack stack = ClientTickHandler.mc.field_71439_g.func_184614_ca();
            int delta = event.getDwheel();
            if (stack.func_77973_b() instanceof ItemConfigurator && delta != 0) {
                ItemConfigurator configurator = (ItemConfigurator)stack.func_77973_b();
                RenderTickHandler.modeSwitchTimer = 100;
                int scaledDelta = (wheelStatus += event.getDwheel()) / 120;
                wheelStatus %= 120;
                int newVal = configurator.getState(stack).ordinal() + scaledDelta % ItemConfigurator.ConfiguratorMode.values().length;
                if (newVal > 0) {
                    newVal %= ItemConfigurator.ConfiguratorMode.values().length;
                } else if (newVal < 0) {
                    newVal = ItemConfigurator.ConfiguratorMode.values().length + newVal;
                }
                configurator.setState(stack, ItemConfigurator.ConfiguratorMode.values()[newVal]);
                Mekanism.packetHandler.sendToServer(new PacketItemStack.ItemStackMessage(EnumHand.MAIN_HAND, Lists.newArrayList((Object[])new Object[]{newVal})));
                event.setCanceled(true);
            }
        }
    }

    private static class TeleportData {
        private EnumHand hand;
        private Frequency freq;
        private long teleportTime;

        public TeleportData(EnumHand h, Frequency f, long t) {
            this.hand = h;
            this.freq = f;
            this.teleportTime = t;
        }
    }
}

