/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import com.google.common.collect.Lists;
import mekanism.api.EnumColor;
import mekanism.client.MekKeyHandler;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismSounds;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.item.ItemBlockMachine;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.ItemElectricBow;
import mekanism.common.item.ItemFlamethrower;
import mekanism.common.item.ItemFreeRunners;
import mekanism.common.item.ItemJetpack;
import mekanism.common.item.ItemScubaTank;
import mekanism.common.item.ItemWalkieTalkie;
import mekanism.common.network.PacketFlamethrowerData;
import mekanism.common.network.PacketFreeRunnerData;
import mekanism.common.network.PacketItemStack;
import mekanism.common.network.PacketJetpackData;
import mekanism.common.network.PacketScubaTankData;
import mekanism.common.util.LangUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MekanismKeyHandler
extends MekKeyHandler {
    public static final String keybindCategory = "Mekanica";
    public static KeyBinding modeSwitchKey = new KeyBinding("Mekanism " + LangUtils.localize("key.mode"), 50, "Mekanica");
    public static KeyBinding armorModeSwitchKey = new KeyBinding("Mekanism " + LangUtils.localize("key.armorMode"), 34, "Mekanica");
    public static KeyBinding freeRunnerModeSwitchKey = new KeyBinding("Mekanism " + LangUtils.localize("key.feetMode"), 35, "Mekanica");
    public static KeyBinding sneakKey = Minecraft.func_71410_x().field_71474_y.field_74311_E;
    public static KeyBinding jumpKey = Minecraft.func_71410_x().field_71474_y.field_74314_A;

    public MekanismKeyHandler() {
        super(new KeyBinding[]{modeSwitchKey, armorModeSwitchKey, freeRunnerModeSwitchKey}, new boolean[]{false, false, true});
        ClientRegistry.registerKeyBinding((KeyBinding)modeSwitchKey);
        ClientRegistry.registerKeyBinding((KeyBinding)armorModeSwitchKey);
        ClientRegistry.registerKeyBinding((KeyBinding)freeRunnerModeSwitchKey);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onTick(InputEvent event) {
        this.keyTick();
    }

    @Override
    public void keyDown(KeyBinding kb, boolean isRepeat) {
        EntityPlayerSP player;
        ItemStack feetStack;
        Item feetItem;
        if (kb == modeSwitchKey) {
            EntityPlayerSP player2 = FMLClientHandler.instance().getClient().field_71439_g;
            ItemStack toolStack = player2.field_71071_by.func_70448_g();
            Item item = StackUtils.getItem(toolStack);
            if (player2.func_70093_af() && item instanceof ItemConfigurator) {
                ItemConfigurator configurator = (ItemConfigurator)item;
                int toSet = configurator.getState(toolStack).ordinal() < ItemConfigurator.ConfiguratorMode.values().length - 1 ? configurator.getState(toolStack).ordinal() + 1 : 0;
                configurator.setState(toolStack, ItemConfigurator.ConfiguratorMode.values()[toSet]);
                Mekanism.packetHandler.sendToServer(new PacketItemStack.ItemStackMessage(EnumHand.MAIN_HAND, Lists.newArrayList((Object[])new Object[]{toSet})));
                player2.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanica]" + " " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.configureState") + ": " + (Object)((Object)configurator.getColor(configurator.getState(toolStack))) + configurator.getStateDisplay(configurator.getState(toolStack))));
            } else if (player2.func_70093_af() && item instanceof ItemElectricBow) {
                ItemElectricBow bow;
                bow.setFireState(toolStack, !(bow = (ItemElectricBow)item).getFireState(toolStack));
                Mekanism.packetHandler.sendToServer(new PacketItemStack.ItemStackMessage(EnumHand.MAIN_HAND, Lists.newArrayList((Object[])new Object[]{bow.getFireState(toolStack)})));
                player2.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanica]" + " " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.fireMode") + ": " + (Object)((Object)(bow.getFireState(toolStack) ? EnumColor.DARK_GREEN : EnumColor.DARK_RED)) + LangUtils.transOnOff(bow.getFireState(toolStack))));
            } else if (player2.func_70093_af() && item instanceof ItemBlockMachine) {
                ItemBlockMachine machine = (ItemBlockMachine)item;
                if (BlockStateMachine.MachineType.get(toolStack) == BlockStateMachine.MachineType.FLUID_TANK) {
                    machine.setBucketMode(toolStack, !machine.getBucketMode(toolStack));
                    Mekanism.packetHandler.sendToServer(new PacketItemStack.ItemStackMessage(EnumHand.MAIN_HAND, Lists.newArrayList((Object[])new Object[]{machine.getBucketMode(toolStack)})));
                    player2.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanica]" + " " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.portableTank.bucketMode") + ": " + (Object)((Object)(machine.getBucketMode(toolStack) ? EnumColor.DARK_GREEN : EnumColor.DARK_RED)) + LangUtils.transOnOff(machine.getBucketMode(toolStack))));
                }
            } else if (player2.func_70093_af() && item instanceof ItemWalkieTalkie) {
                ItemWalkieTalkie wt = (ItemWalkieTalkie)item;
                if (wt.getOn(toolStack)) {
                    int newChan = wt.getChannel(toolStack) < 9 ? wt.getChannel(toolStack) + 1 : 1;
                    wt.setChannel(toolStack, newChan);
                    Mekanism.packetHandler.sendToServer(new PacketItemStack.ItemStackMessage(EnumHand.MAIN_HAND, Lists.newArrayList((Object[])new Object[]{newChan})));
                }
            } else if (player2.func_70093_af() && item instanceof ItemFlamethrower) {
                ItemFlamethrower flamethrower = (ItemFlamethrower)item;
                flamethrower.incrementMode(toolStack);
                Mekanism.packetHandler.sendToServer(new PacketFlamethrowerData.FlamethrowerDataMessage(PacketFlamethrowerData.FlamethrowerPacket.MODE, EnumHand.MAIN_HAND, null, false));
                player2.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanica]" + " " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.flamethrower.modeBump") + ": " + flamethrower.getMode(toolStack).getName()));
            }
        } else if (kb == armorModeSwitchKey) {
            EntityPlayerSP player3 = FMLClientHandler.instance().getClient().field_71439_g;
            ItemStack chestStack = player3.func_184582_a(EntityEquipmentSlot.CHEST);
            Item chestItem = StackUtils.getItem(chestStack);
            if (chestItem instanceof ItemJetpack) {
                ItemJetpack jetpack = (ItemJetpack)chestItem;
                if (player3.func_70093_af()) {
                    jetpack.setMode(chestStack, ItemJetpack.JetpackMode.DISABLED);
                } else {
                    jetpack.incrementMode(chestStack);
                }
                Mekanism.packetHandler.sendToServer(PacketJetpackData.JetpackDataMessage.MODE_CHANGE(player3.func_70093_af()));
                SoundHandler.playSound(MekanismSounds.HYDRAULIC);
            } else if (chestItem instanceof ItemScubaTank) {
                ItemScubaTank scubaTank = (ItemScubaTank)chestItem;
                scubaTank.toggleFlowing(chestStack);
                Mekanism.packetHandler.sendToServer(PacketScubaTankData.ScubaTankDataMessage.MODE_CHANGE(false));
                SoundHandler.playSound(MekanismSounds.HYDRAULIC);
            }
        } else if (kb == freeRunnerModeSwitchKey && (feetItem = StackUtils.getItem(feetStack = (player = FMLClientHandler.instance().getClient().field_71439_g).func_184582_a(EntityEquipmentSlot.FEET))) instanceof ItemFreeRunners) {
            ItemFreeRunners freeRunners = (ItemFreeRunners)feetItem;
            if (player.func_70093_af()) {
                freeRunners.setMode(feetStack, ItemFreeRunners.FreeRunnerMode.DISABLED);
            } else {
                freeRunners.incrementMode(feetStack);
            }
            Mekanism.packetHandler.sendToServer(new PacketFreeRunnerData.FreeRunnerDataMessage(PacketFreeRunnerData.FreeRunnerPacket.MODE, null, player.func_70093_af()));
            SoundHandler.playSound(MekanismSounds.HYDRAULIC);
        }
    }

    @Override
    public void keyUp(KeyBinding kb) {
    }
}

