/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.Arrays;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiRecipeType;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.gui.element.GuiSideConfigurationTab;
import mekanism.client.gui.element.GuiSortingTab;
import mekanism.client.gui.element.GuiTransporterConfigTab;
import mekanism.client.gui.element.GuiUpgradeTab;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.Tier;
import mekanism.common.base.IFactory;
import mekanism.common.inventory.container.ContainerFactory;
import mekanism.common.item.ItemGaugeDropper;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiFactory
extends GuiMekanismTile<TileEntityFactory> {
    public GuiFactory(InventoryPlayer inventory, TileEntityFactory tile) {
        super(tile, new ContainerFactory(inventory, tile));
        this.field_147000_g += 11;
        ResourceLocation resource = ((TileEntityFactory)this.tileEntity).tier.guiLocation;
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiUpgradeTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiRecipeType(this, (TileEntityFactory)this.tileEntity, resource));
        this.addGuiElement(new GuiSideConfigurationTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiTransporterConfigTab(this, 34, this.tileEntity, resource));
        this.addGuiElement(new GuiSortingTab(this, (TileEntityFactory)this.tileEntity, resource));
        this.addGuiElement(new GuiEnergyInfo(() -> {
            String multiplier = MekanismUtils.getEnergyDisplay(((TileEntityFactory)this.tileEntity).lastUsage);
            return Arrays.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityFactory)this.tileEntity).getMaxEnergy() - ((TileEntityFactory)this.tileEntity).getEnergy()));
        }, (IGuiWrapper)this, resource));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityFactory)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityFactory)this.tileEntity).func_70005_c_()) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 93 + 2, 0x404040);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 165 && xAxis <= 169 && yAxis >= 17 && yAxis <= 69) {
            this.func_146279_a(MekanismUtils.getEnergyDisplay(((TileEntityFactory)this.tileEntity).getEnergy(), ((TileEntityFactory)this.tileEntity).getMaxEnergy()), xAxis, yAxis);
        }
        if (xAxis >= 8 && xAxis <= 168 && yAxis >= 78 && yAxis <= 83) {
            if (((TileEntityFactory)this.tileEntity).getRecipeType().getFuelType() == IFactory.MachineFuelType.ADVANCED) {
                this.func_146279_a(((TileEntityFactory)this.tileEntity).gasTank.getGas() != null ? ((TileEntityFactory)this.tileEntity).gasTank.getGas().getGas().getLocalizedName() + ": " + ((TileEntityFactory)this.tileEntity).gasTank.getStored() : LangUtils.localize("gui.none"), xAxis, yAxis);
            } else if (((TileEntityFactory)this.tileEntity).getRecipeType() == IFactory.RecipeType.INFUSING) {
                this.func_146279_a(((TileEntityFactory)this.tileEntity).infuseStored.type != null ? ((TileEntityFactory)this.tileEntity).infuseStored.type.getLocalizedName() + ": " + ((TileEntityFactory)this.tileEntity).infuseStored.amount : LangUtils.localize("gui.empty"), xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        int xOffset;
        this.field_146297_k.field_71446_o.func_110577_a(this.getGuiLocation());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int displayInt = ((TileEntityFactory)this.tileEntity).getScaledEnergyLevel(52);
        this.func_73729_b(guiWidth + 165, guiHeight + 17 + 52 - displayInt, 176, 52 - displayInt, 4, displayInt);
        int n = ((TileEntityFactory)this.tileEntity).tier == Tier.FactoryTier.BASIC ? 59 : (xOffset = ((TileEntityFactory)this.tileEntity).tier == Tier.FactoryTier.ADVANCED ? 39 : 33);
        int xDistance = ((TileEntityFactory)this.tileEntity).tier == Tier.FactoryTier.BASIC ? 38 : (((TileEntityFactory)this.tileEntity).tier == Tier.FactoryTier.ADVANCED ? 26 : 19);
        for (int i = 0; i < ((TileEntityFactory)this.tileEntity).tier.processes; ++i) {
            int xPos = xOffset + i * xDistance;
            displayInt = ((TileEntityFactory)this.tileEntity).getScaledProgress(20, i);
            this.func_73729_b(guiWidth + xPos, guiHeight + 33, 176, 52, 8, displayInt);
        }
        if (((TileEntityFactory)this.tileEntity).getRecipeType().getFuelType() == IFactory.MachineFuelType.ADVANCED) {
            GasStack gas;
            if (((TileEntityFactory)this.tileEntity).getScaledGasLevel(160) > 0 && (gas = ((TileEntityFactory)this.tileEntity).gasTank.getGas()) != null) {
                int tint = gas.getGas().getTint();
                if (tint != -1) {
                    MekanismRenderer.color(tint);
                }
                this.displayGauge(8, 78, ((TileEntityFactory)this.tileEntity).getScaledGasLevel(160), 5, gas.getGas().getSprite());
                MekanismRenderer.resetColor();
            }
        } else if (((TileEntityFactory)this.tileEntity).getRecipeType() == IFactory.RecipeType.INFUSING && ((TileEntityFactory)this.tileEntity).getScaledInfuseLevel(160) > 0) {
            this.displayGauge(8, 78, ((TileEntityFactory)this.tileEntity).getScaledInfuseLevel(160), 5, ((TileEntityFactory)this.tileEntity).infuseStored.type.sprite);
        }
        super.func_146976_a(partialTick, mouseX, mouseY);
    }

    public void displayGauge(int xPos, int yPos, int sizeX, int sizeY, TextureAtlasSprite icon) {
        if (icon != null) {
            int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
            int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
            this.field_146297_k.field_71446_o.func_110577_a(MekanismRenderer.getBlocksTexture());
            this.func_175175_a(guiWidth + xPos, guiHeight + yPos, icon, sizeX, sizeY);
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        if (button == 0 || Keyboard.isKeyDown((int)42)) {
            ItemStack stack;
            int xAxis = x - (this.field_146294_l - this.field_146999_f) / 2;
            int yAxis = y - (this.field_146295_m - this.field_147000_g) / 2;
            if (xAxis > 8 && xAxis < 168 && yAxis > 78 && yAxis < 83 && !(stack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o()).func_190926_b() && stack.func_77973_b() instanceof ItemGaugeDropper) {
                TileNetworkList data = TileNetworkList.withContents(1);
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
                SoundHandler.playSound(SoundEvents.field_187909_gi);
            }
        }
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return ((TileEntityFactory)this.tileEntity).tier.guiLocation;
    }
}

