/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.Collections;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.gui.element.GuiSlot;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.ContainerFuelwoodHeater;
import mekanism.common.tile.TileEntityFuelwoodHeater;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiFuelwoodHeater
extends GuiMekanismTile<TileEntityFuelwoodHeater> {
    public GuiFuelwoodHeater(InventoryPlayer inventory, TileEntityFuelwoodHeater tile) {
        super(tile, new ContainerFuelwoodHeater(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, resource, 14, 28));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiHeatInfo(() -> {
            UnitDisplayUtils.TemperatureUnit unit = UnitDisplayUtils.TemperatureUnit.values()[MekanismConfig.general.tempUnit.ordinal()];
            String environment = UnitDisplayUtils.getDisplayShort(((TileEntityFuelwoodHeater)this.tileEntity).lastEnvironmentLoss * unit.intervalSize, false, unit);
            return Collections.singletonList(LangUtils.localize("gui.dissipated") + ": " + environment + "/t");
        }, (IGuiWrapper)this, resource));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityFuelwoodHeater)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityFuelwoodHeater)this.tileEntity).func_70005_c_()) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 94 + 2, 0x404040);
        this.renderScaledText(LangUtils.localize("gui.temp") + ": " + MekanismUtils.getTemperatureDisplay(((TileEntityFuelwoodHeater)this.tileEntity).temperature, UnitDisplayUtils.TemperatureUnit.AMBIENT), 50, 25, 52480, 76);
        this.renderScaledText(LangUtils.localize("gui.fuel") + ": " + ((TileEntityFuelwoodHeater)this.tileEntity).burnTime, 50, 41, 52480, 76);
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(this.getGuiLocation());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        if (((TileEntityFuelwoodHeater)this.tileEntity).burnTime > 0) {
            int displayInt = ((TileEntityFuelwoodHeater)this.tileEntity).burnTime * 13 / ((TileEntityFuelwoodHeater)this.tileEntity).maxBurnTime;
            this.func_73729_b(guiWidth + 143, guiHeight + 30 + 12 - displayInt, 176, 12 - displayInt, 14, displayInt + 1);
        }
        super.func_146976_a(partialTick, mouseX, mouseY);
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiFuelwoodHeater.png");
    }
}

