/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.element.GuiConfigTypeTab;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketConfigurationUpdate;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiSideConfiguration
extends GuiMekanismTile<TileEntityContainerBlock> {
    private Map<Integer, GuiPos> slotPosMap = new HashMap<Integer, GuiPos>();
    private ISideConfiguration configurable;
    private TransmissionType currentType;
    private List<GuiConfigTypeTab> configTabs = new ArrayList<GuiConfigTypeTab>();

    public GuiSideConfiguration(EntityPlayer player, ISideConfiguration tile) {
        super((TileEntityContainerBlock)((Object)tile), new ContainerNull(player, (TileEntityContainerBlock)((Object)tile)));
        this.field_147000_g = 95;
        this.configurable = tile;
        ResourceLocation resource = this.getGuiLocation();
        for (TransmissionType type : this.configurable.getConfig().transmissions) {
            GuiConfigTypeTab tab = new GuiConfigTypeTab(this, type, resource);
            this.addGuiElement(tab);
            this.configTabs.add(tab);
        }
        this.currentType = this.getTopTransmission();
        this.updateTabs();
        this.slotPosMap.put(0, new GuiPos(81, 64));
        this.slotPosMap.put(1, new GuiPos(81, 34));
        this.slotPosMap.put(2, new GuiPos(81, 49));
        this.slotPosMap.put(3, new GuiPos(66, 64));
        this.slotPosMap.put(4, new GuiPos(66, 49));
        this.slotPosMap.put(5, new GuiPos(96, 49));
    }

    public TransmissionType getTopTransmission() {
        return this.configurable.getConfig().transmissions.get(0);
    }

    public void setCurrentType(TransmissionType type) {
        this.currentType = type;
    }

    public void updateTabs() {
        int rendered = 0;
        for (GuiConfigTypeTab tab : this.configTabs) {
            tab.setVisible(this.currentType != tab.getTransmissionType());
            if (tab.isVisible()) {
                tab.setLeft(rendered >= 0 && rendered <= 2);
                tab.setY(2 + rendered % 3 * 28);
            }
            ++rendered;
        }
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        super.func_146976_a(partialTick, mouseX, mouseY);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.getGuiLocation());
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 6 && xAxis <= 20 && yAxis >= 6 && yAxis <= 20) {
            this.func_73729_b(guiWidth + 6, guiHeight + 6, 204, 0, 14, 14);
        } else {
            this.func_73729_b(guiWidth + 6, guiHeight + 6, 204, 14, 14, 14);
        }
        if (xAxis >= 156 && xAxis <= 170 && yAxis >= 6 && yAxis <= 20) {
            this.func_73729_b(guiWidth + 156, guiHeight + 6, 190, 0, 14, 14);
        } else {
            this.func_73729_b(guiWidth + 156, guiHeight + 6, 190, 14, 14, 14);
        }
        for (int i = 0; i < this.slotPosMap.size(); ++i) {
            MekanismRenderer.resetColor();
            int x = this.slotPosMap.get((Object)Integer.valueOf((int)i)).xPos;
            int y = this.slotPosMap.get((Object)Integer.valueOf((int)i)).yPos;
            SideData data = this.configurable.getConfig().getOutput(this.currentType, EnumFacing.func_82600_a((int)i));
            if (data != TileComponentConfig.EMPTY) {
                if (data.color != EnumColor.GREY) {
                    MekanismRenderer.color(data.color);
                }
                if (xAxis >= x && xAxis <= x + 14 && yAxis >= y && yAxis <= y + 14) {
                    this.func_73729_b(guiWidth + x, guiHeight + y, 176, 0, 14, 14);
                    continue;
                }
                this.func_73729_b(guiWidth + x, guiHeight + y, 176, 14, 14, 14);
                continue;
            }
            this.func_73729_b(guiWidth + x, guiHeight + y, 176, 28, 14, 14);
        }
        MekanismRenderer.resetColor();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        String title = this.currentType.localize() + " " + LangUtils.localize("gui.config");
        this.field_146289_q.func_78276_b(title, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(title) / 2, 5, 0x404040);
        if (this.configurable.getConfig().canEject(this.currentType)) {
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.eject") + ": " + (this.configurable.getConfig().isEjecting(this.currentType) ? "On" : "Off"), 53, 17, 52480);
        } else {
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.noEject"), 53, 17, 52480);
        }
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.slots"), 77, 81, 0x787878);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        for (int i = 0; i < this.slotPosMap.size(); ++i) {
            int x = this.slotPosMap.get((Object)Integer.valueOf((int)i)).xPos;
            int y = this.slotPosMap.get((Object)Integer.valueOf((int)i)).yPos;
            SideData data = this.configurable.getConfig().getOutput(this.currentType, EnumFacing.func_82600_a((int)i));
            if (data == TileComponentConfig.EMPTY || xAxis < x || xAxis > x + 14 || yAxis < y || yAxis > y + 14) continue;
            this.func_146279_a((Object)((Object)data.color) + data.localize() + " (" + data.color.getColoredName() + ")", xAxis, yAxis);
        }
        if (xAxis >= 156 && xAxis <= 170 && yAxis >= 6 && yAxis <= 20) {
            this.func_146279_a(LangUtils.localize("gui.autoEject"), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    public void func_73876_c() {
        super.func_73876_c();
        TileEntity tile = (TileEntity)this.configurable;
        if (tile == null || this.field_146297_k.field_71441_e.func_175625_s(tile.func_174877_v()) == null) {
            this.field_146297_k.func_147108_a(null);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        TileEntity tile = (TileEntity)this.configurable;
        if (button == 0) {
            if (xAxis >= 6 && xAxis <= 20 && yAxis >= 6 && yAxis <= 20) {
                int guiId = Mekanism.proxy.getGuiId(tile.func_145838_q(), tile.func_145832_p());
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                Mekanism.packetHandler.sendToServer(new PacketSimpleGui.SimpleGuiMessage(Coord4D.get(tile), 0, guiId));
            }
            if (xAxis >= 156 && xAxis <= 170 && yAxis >= 6 && yAxis <= 20) {
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate.ConfigurationUpdateMessage(PacketConfigurationUpdate.ConfigurationPacket.EJECT, Coord4D.get(tile), 0, 0, this.currentType));
            }
        }
        if (Keyboard.isKeyDown((int)42) && button == 0) {
            button = 2;
        }
        for (int i = 0; i < this.slotPosMap.size(); ++i) {
            int x = this.slotPosMap.get((Object)Integer.valueOf((int)i)).xPos;
            int y = this.slotPosMap.get((Object)Integer.valueOf((int)i)).yPos;
            if (xAxis < x || xAxis > x + 14 || yAxis < y || yAxis > y + 14) continue;
            SoundHandler.playSound(SoundEvents.field_187909_gi);
            Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate.ConfigurationUpdateMessage(PacketConfigurationUpdate.ConfigurationPacket.SIDE_DATA, Coord4D.get(tile), button, i, this.currentType));
        }
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiConfiguration.png");
    }

    public static class GuiPos {
        public int xPos;
        public int yPos;

        public GuiPos(int x, int y) {
            this.xPos = x;
            this.yPos = y;
        }
    }
}

