/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.client.ClientTickHandler;
import mekanism.client.MekanismClient;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiScrollList;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiUpgradeTab;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.inventory.container.ContainerTeleporter;
import mekanism.common.item.ItemPortableTeleporter;
import mekanism.common.network.PacketPortableTeleporter;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.IOwnerItem;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiTeleporter
extends GuiMekanismTile<TileEntityTeleporter> {
    private EnumHand currentHand;
    private ItemStack itemStack = ItemStack.field_190927_a;
    private EntityPlayer entityPlayer;
    private GuiButton publicButton;
    private GuiButton privateButton;
    private GuiButton setButton;
    private GuiButton deleteButton;
    private GuiButton teleportButton;
    private GuiScrollList scrollList;
    private GuiTextField frequencyField;
    private boolean privateMode;
    private Frequency clientFreq;
    private byte clientStatus;
    private List<Frequency> clientPublicCache = new ArrayList<Frequency>();
    private List<Frequency> clientPrivateCache = new ArrayList<Frequency>();
    private boolean isInit = true;
    private boolean isPortable;

    public GuiTeleporter(InventoryPlayer inventory, TileEntityTeleporter tile) {
        super(tile, new ContainerTeleporter(inventory, tile));
        this.isPortable = false;
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiUpgradeTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiPowerBar((IGuiWrapper)this, new GuiPowerBar.IPowerInfoHandler(){

            @Override
            public String getTooltip() {
                return MekanismUtils.getEnergyDisplay(GuiTeleporter.this.getEnergy(), GuiTeleporter.this.getMaxEnergy());
            }

            @Override
            public double getLevel() {
                return GuiTeleporter.this.getEnergy() / GuiTeleporter.this.getMaxEnergy();
            }
        }, resource, 158, 26));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, resource, 152, 6).with(GuiSlot.SlotOverlay.POWER));
        this.scrollList = new GuiScrollList(this, resource, 28, 37, 120, 4);
        this.addGuiElement(this.scrollList);
        if (((TileEntityTeleporter)this.tileEntity).frequency != null) {
            this.privateMode = !((TileEntityTeleporter)this.tileEntity).frequency.publicFreq;
        }
        this.field_147000_g += 64;
    }

    public GuiTeleporter(EntityPlayer player, EnumHand hand, ItemStack stack) {
        super(null, new ContainerNull());
        this.isPortable = true;
        this.currentHand = hand;
        this.itemStack = stack;
        this.entityPlayer = player;
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiPowerBar((IGuiWrapper)this, new GuiPowerBar.IPowerInfoHandler(){

            @Override
            public String getTooltip() {
                return MekanismUtils.getEnergyDisplay(GuiTeleporter.this.getEnergy(), GuiTeleporter.this.getMaxEnergy());
            }

            @Override
            public double getLevel() {
                return GuiTeleporter.this.getEnergy() / GuiTeleporter.this.getMaxEnergy();
            }
        }, resource, 158, 26));
        this.scrollList = new GuiScrollList(this, resource, 28, 37, 120, 4);
        this.addGuiElement(this.scrollList);
        ItemPortableTeleporter item = (ItemPortableTeleporter)this.itemStack.func_77973_b();
        if (item.getFrequency(stack) != null) {
            this.privateMode = !item.getFrequency((ItemStack)stack).publicFreq;
            this.setFrequency(item.getFrequency((ItemStack)stack).name);
        } else {
            Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.DATA_REQUEST, this.currentHand, this.clientFreq));
        }
        this.field_147000_g = 175;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.clear();
        this.publicButton = new GuiButton(0, guiWidth + 27, guiHeight + 14, 60, 20, LangUtils.localize("gui.public"));
        this.privateButton = new GuiButton(1, guiWidth + 89, guiHeight + 14, 60, 20, LangUtils.localize("gui.private"));
        this.setButton = new GuiButton(2, guiWidth + 27, guiHeight + 116, 60, 20, LangUtils.localize("gui.set"));
        this.deleteButton = new GuiButton(3, guiWidth + 89, guiHeight + 116, 60, 20, LangUtils.localize("gui.delete"));
        if (!this.itemStack.func_190926_b()) {
            this.teleportButton = new GuiButton(4, guiWidth + 42, guiHeight + 140, 92, 20, LangUtils.localize("gui.teleport"));
        }
        this.frequencyField = new GuiTextField(5, this.field_146289_q, guiWidth + 50, guiHeight + 104, 86, 11);
        this.frequencyField.func_146203_f(16);
        this.frequencyField.func_146185_a(false);
        this.updateButtons();
        this.field_146292_n.add(this.publicButton);
        this.field_146292_n.add(this.privateButton);
        this.field_146292_n.add(this.setButton);
        this.field_146292_n.add(this.deleteButton);
        if (!this.itemStack.func_190926_b()) {
            this.field_146292_n.add(this.teleportButton);
            if (!this.isInit) {
                Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.DATA_REQUEST, this.currentHand, this.clientFreq));
            } else {
                this.isInit = false;
            }
        }
    }

    public void setFrequency(Frequency newFrequency) {
        this.clientFreq = newFrequency;
    }

    public void setPublicCache(List<Frequency> cache) {
        this.clientPublicCache = cache;
    }

    public void setPrivateCache(List<Frequency> cache) {
        this.clientPrivateCache = cache;
    }

    public void setStatus(byte status) {
        this.clientStatus = status;
    }

    public String getSecurity(Frequency freq) {
        return !freq.publicFreq ? (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.private") : LangUtils.localize("gui.public");
    }

    public void updateButtons() {
        if (this.getOwner() == null) {
            return;
        }
        ArrayList<String> text = new ArrayList<String>();
        if (this.privateMode) {
            for (Frequency freq : this.getPrivateCache()) {
                text.add(freq.name);
            }
        } else {
            for (Frequency freq : this.getPublicCache()) {
                text.add(freq.name + " (" + freq.clientOwner + ")");
            }
        }
        this.scrollList.setText(text);
        if (this.privateMode) {
            this.publicButton.field_146124_l = true;
            this.privateButton.field_146124_l = false;
        } else {
            this.publicButton.field_146124_l = false;
            this.privateButton.field_146124_l = true;
        }
        if (this.scrollList.hasSelection()) {
            Frequency freq = this.privateMode ? this.getPrivateCache().get(this.scrollList.getSelection()) : this.getPublicCache().get(this.scrollList.getSelection());
            this.setButton.field_146124_l = this.getFrequency() == null || !this.getFrequency().equals(freq);
            this.deleteButton.field_146124_l = this.getOwner().equals(freq.ownerUUID);
        } else {
            this.setButton.field_146124_l = false;
            this.deleteButton.field_146124_l = false;
        }
        if (!this.itemStack.func_190926_b()) {
            this.teleportButton.field_146124_l = this.clientFreq != null && this.clientStatus == 1;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateButtons();
        this.frequencyField.func_146178_a();
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.updateButtons();
        this.frequencyField.func_146192_a(mouseX, mouseY, button);
        if (button == 0) {
            int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
            int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
            if (xAxis >= 137 && xAxis <= 148 && yAxis >= 103 && yAxis <= 114) {
                this.setFrequency(this.frequencyField.func_146179_b());
                this.frequencyField.func_146180_a("");
                SoundHandler.playSound(SoundEvents.field_187909_gi);
            }
        }
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.isPortable ? "GuiPortableTeleporter.png" : "GuiTeleporter.png");
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (!this.frequencyField.func_146206_l() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (i == 28 && this.frequencyField.func_146206_l()) {
            this.setFrequency(this.frequencyField.func_146179_b());
            this.frequencyField.func_146180_a("");
        }
        if (Character.isDigit(c) || Character.isLetter(c) || GuiTeleporter.isTextboxKey(c, i) || FrequencyManager.SPECIAL_CHARS.contains(Character.valueOf(c))) {
            this.frequencyField.func_146201_a(c, i);
        }
        this.updateButtons();
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == 0) {
            this.privateMode = false;
        } else if (guibutton.field_146127_k == 1) {
            this.privateMode = true;
        } else if (guibutton.field_146127_k == 2) {
            int selection = this.scrollList.getSelection();
            if (selection != -1) {
                Frequency freq = this.privateMode ? this.getPrivateCache().get(selection) : this.getPublicCache().get(selection);
                this.setFrequency(freq.name);
            }
        } else if (guibutton.field_146127_k == 3) {
            int selection = this.scrollList.getSelection();
            if (selection != -1) {
                Frequency freq;
                Frequency frequency = freq = this.privateMode ? this.getPrivateCache().get(selection) : this.getPublicCache().get(selection);
                if (this.tileEntity != null) {
                    TileNetworkList data = TileNetworkList.withContents(1, freq.name, freq.publicFreq);
                    Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
                } else {
                    Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.DEL_FREQ, this.currentHand, freq));
                    Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.DATA_REQUEST, this.currentHand, null));
                }
                this.scrollList.clearSelection();
            }
        } else if (guibutton.field_146127_k == 4 && this.clientFreq != null && this.clientStatus == 1) {
            this.field_146297_k.func_71381_h();
            ClientTickHandler.portableTeleport(this.entityPlayer, this.currentHand, this.clientFreq);
        }
        this.updateButtons();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getName(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.getName()) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.owner") + ": " + (this.getOwnerUsername() != null ? this.getOwnerUsername() : LangUtils.localize("gui.none")), 8, !this.itemStack.func_190926_b() ? this.field_147000_g - 12 : this.field_147000_g - 96 + 4, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.freq") + ":", 32, 81, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.security") + ":", 32, 91, 0x404040);
        this.field_146289_q.func_78276_b(" " + (this.getFrequency() != null ? this.getFrequency().name : (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.none")), 32 + this.field_146289_q.func_78256_a(LangUtils.localize("gui.freq") + ":"), 81, 0x797979);
        this.field_146289_q.func_78276_b(" " + (this.getFrequency() != null ? this.getSecurity(this.getFrequency()) : (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.none")), 32 + this.field_146289_q.func_78256_a(LangUtils.localize("gui.security") + ":"), 91, 0x797979);
        String str = LangUtils.localize("gui.set") + ":";
        this.renderScaledText(str, 27, 104, 0x404040, 20);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 6 && xAxis <= 24 && yAxis >= 6 && yAxis <= 24) {
            if (this.getFrequency() == null) {
                this.func_146279_a((Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.teleporter.noFreq"), xAxis, yAxis);
            } else {
                this.func_146279_a(this.getStatusDisplay(), xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(this.getGuiLocation());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 137 && xAxis <= 148 && yAxis >= 103 && yAxis <= 114) {
            this.func_73729_b(guiWidth + 137, guiHeight + 103, this.field_146999_f, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 137, guiHeight + 103, this.field_146999_f, 11, 11, 11);
        }
        int y = this.getFrequency() == null ? 94 : (this.getStatus() == 2 ? 22 : (this.getStatus() == 3 ? 40 : (this.getStatus() == 4 ? 58 : 76)));
        this.func_73729_b(guiWidth + 6, guiHeight + 6, 176, y, 18, 18);
        super.func_146976_a(partialTick, mouseX, mouseY);
        this.frequencyField.func_146194_f();
    }

    public String getStatusDisplay() {
        switch (this.getStatus()) {
            case 1: {
                return (Object)((Object)EnumColor.DARK_GREEN) + LangUtils.localize("gui.teleporter.ready");
            }
            case 2: {
                return (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.teleporter.noFrame");
            }
            case 3: {
                return (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.teleporter.noLink");
            }
            case 4: {
                return (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.teleporter.needsEnergy");
            }
        }
        return (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.teleporter.noLink");
    }

    private UUID getOwner() {
        if (this.tileEntity != null) {
            return ((TileEntityTeleporter)this.tileEntity).getSecurity().getOwnerUUID();
        }
        return ((IOwnerItem)this.itemStack.func_77973_b()).getOwnerUUID(this.itemStack);
    }

    private String getOwnerUsername() {
        if (this.tileEntity != null) {
            return ((TileEntityTeleporter)this.tileEntity).getSecurity().getClientOwner();
        }
        return MekanismClient.clientUUIDMap.get(((IOwnerItem)this.itemStack.func_77973_b()).getOwnerUUID(this.itemStack));
    }

    private byte getStatus() {
        return this.tileEntity != null ? ((TileEntityTeleporter)this.tileEntity).status : this.clientStatus;
    }

    private List<Frequency> getPublicCache() {
        return this.tileEntity != null ? ((TileEntityTeleporter)this.tileEntity).publicCache : this.clientPublicCache;
    }

    private List<Frequency> getPrivateCache() {
        return this.tileEntity != null ? ((TileEntityTeleporter)this.tileEntity).privateCache : this.clientPrivateCache;
    }

    private Frequency getFrequency() {
        return this.tileEntity != null ? ((TileEntityTeleporter)this.tileEntity).frequency : this.clientFreq;
    }

    public void setFrequency(String freq) {
        if (freq.isEmpty()) {
            return;
        }
        if (this.tileEntity != null) {
            TileNetworkList data = TileNetworkList.withContents(0, freq, !this.privateMode);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
        } else {
            Frequency newFreq = new Frequency(freq, null).setPublic(!this.privateMode);
            Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.SET_FREQ, this.currentHand, newFreq));
        }
    }

    private String getName() {
        return this.tileEntity != null ? ((TileEntityTeleporter)this.tileEntity).func_70005_c_() : this.itemStack.func_82833_r();
    }

    private double getEnergy() {
        if (!this.itemStack.func_190926_b()) {
            return ((ItemPortableTeleporter)this.itemStack.func_77973_b()).getEnergy(this.itemStack);
        }
        return ((TileEntityTeleporter)this.tileEntity).getEnergy();
    }

    private double getMaxEnergy() {
        if (!this.itemStack.func_190926_b()) {
            return ((ItemPortableTeleporter)this.itemStack.func_77973_b()).getMaxEnergy(this.itemStack);
        }
        return ((TileEntityTeleporter)this.tileEntity).getMaxEnergy();
    }

    public boolean isStackEmpty() {
        return this.itemStack.func_190926_b();
    }
}

