/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import java.util.Arrays;
import mekanism.api.Coord4D;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiGauge;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.base.ITankManager;
import mekanism.common.item.ItemGaugeDropper;
import mekanism.common.network.PacketDropperUse;
import mekanism.common.util.LangUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiFluidGauge
extends GuiGauge<Fluid> {
    private final IFluidInfoHandler infoHandler;

    public GuiFluidGauge(IFluidInfoHandler handler, GuiGauge.Type type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        super(type, gui, def, x, y);
        this.infoHandler = handler;
    }

    public static GuiFluidGauge getDummy(GuiGauge.Type type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        GuiFluidGauge gauge = new GuiFluidGauge(null, type, gui, def, x, y);
        gauge.dummy = true;
        return gauge;
    }

    @Override
    public int getRenderColor() {
        if (this.dummy) {
            return ((Fluid)this.dummyType).getColor();
        }
        FluidStack fluid = this.infoHandler.getTank().getFluid();
        return fluid == null ? ((Fluid)this.dummyType).getColor() : fluid.getFluid().getColor();
    }

    @Override
    protected boolean inBounds(int xAxis, int yAxis) {
        return xAxis >= this.xLocation + 1 && xAxis <= this.xLocation + this.width - 1 && yAxis >= this.yLocation + 1 && yAxis <= this.yLocation + this.height - 1;
    }

    @Override
    public TransmissionType getTransmission() {
        return TransmissionType.FLUID;
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
        if (this.inBounds(xAxis, yAxis)) {
            int index;
            Object tile;
            ItemStack stack = GuiFluidGauge.mc.field_71439_g.field_71071_by.func_70445_o();
            if (this.guiObj instanceof GuiMekanismTile && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemGaugeDropper && (tile = ((GuiMekanismTile)this.guiObj).getTileEntity()) instanceof ITankManager && ((ITankManager)tile).getTanks() != null && (index = Arrays.asList(((ITankManager)tile).getTanks()).indexOf(this.infoHandler.getTank())) != -1) {
                if (button == 0 && Keyboard.isKeyDown((int)42)) {
                    button = 2;
                }
                Mekanism.packetHandler.sendToServer(new PacketDropperUse.DropperUseMessage(Coord4D.get(tile), button, index));
            }
        }
    }

    @Override
    public int getScaledLevel() {
        if (this.dummy) {
            return this.height - 2;
        }
        if (this.infoHandler.getTank().getFluid() == null || this.infoHandler.getTank().getCapacity() == 0) {
            return 0;
        }
        if (this.infoHandler.getTank().getFluidAmount() == Integer.MAX_VALUE) {
            return this.height - 2;
        }
        return this.infoHandler.getTank().getFluidAmount() * (this.height - 2) / this.infoHandler.getTank().getCapacity();
    }

    @Override
    public TextureAtlasSprite getIcon() {
        if (this.dummy) {
            return MekanismRenderer.getFluidTexture((Fluid)this.dummyType, MekanismRenderer.FluidType.STILL);
        }
        FluidStack fluid = this.infoHandler.getTank().getFluid();
        return MekanismRenderer.getFluidTexture(fluid == null ? (Fluid)this.dummyType : fluid.getFluid(), MekanismRenderer.FluidType.STILL);
    }

    @Override
    public String getTooltipText() {
        if (this.dummy) {
            return ((Fluid)this.dummyType).getLocalizedName(null);
        }
        String amountStr = this.infoHandler.getTank().getFluidAmount() == Integer.MAX_VALUE ? LangUtils.localize("gui.infinite") : this.infoHandler.getTank().getFluidAmount() + " mB";
        return this.infoHandler.getTank().getFluid() != null ? LangUtils.localizeFluidStack(this.infoHandler.getTank().getFluid()) + ": " + amountStr : LangUtils.localize("gui.empty");
    }

    public static interface IFluidInfoHandler {
        public FluidTank getTank();
    }
}

