/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import java.io.IOException;
import mekanism.api.Coord4D;
import mekanism.client.gui.filter.GuiMaterialFilter;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismSounds;
import mekanism.common.content.transporter.TMaterialFilter;
import mekanism.common.network.PacketLogisticalSorterGui;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiTMaterialFilter
extends GuiMaterialFilter<TMaterialFilter, TileEntityLogisticalSorter> {
    public GuiTMaterialFilter(EntityPlayer player, TileEntityLogisticalSorter tile, int index) {
        super(player, tile);
        this.origFilter = (TMaterialFilter)((TileEntityLogisticalSorter)this.tileEntity).filters.get(index);
        this.filter = ((TMaterialFilter)((TileEntityLogisticalSorter)this.tileEntity).filters.get(index)).clone();
    }

    public GuiTMaterialFilter(EntityPlayer player, TileEntityLogisticalSorter tile) {
        super(player, tile);
        this.isNew = true;
        this.filter = new TMaterialFilter();
    }

    @Override
    protected void addButtons(int guiWidth, int guiHeight) {
        this.field_146292_n.add(new GuiButton(0, guiWidth + 47, guiHeight + 62, 60, 20, LangUtils.localize("gui.save")));
        this.field_146292_n.add(new GuiButton(1, guiWidth + 109, guiHeight + 62, 60, 20, LangUtils.localize("gui.delete")));
    }

    @Override
    protected void sendPacketToServer(int guiID) {
        Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, Coord4D.get(this.tileEntity), guiID, 0, 0));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b((this.isNew ? LangUtils.localize("gui.new") : LangUtils.localize("gui.edit")) + " " + LangUtils.localize("gui.materialFilter"), 43, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.status") + ": " + this.status, 35, 20, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.materialFilter.details") + ":", 35, 32, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui." + (((TMaterialFilter)this.filter).allowDefault ? "on" : "off")), 24, 66, 0x404040);
        if (!((TMaterialFilter)this.filter).getMaterialItem().func_190926_b()) {
            this.renderScaledText(((TMaterialFilter)this.filter).getMaterialItem().func_82833_r(), 35, 41, 52480, 107);
            GlStateManager.func_179094_E();
            RenderHelper.func_74520_c();
            this.field_146296_j.func_180450_b(((TMaterialFilter)this.filter).getMaterialItem(), 12, 19);
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
        }
        if (((TMaterialFilter)this.filter).color != null) {
            GlStateManager.func_179094_E();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)32826);
            this.field_146297_k.func_110434_K().func_110577_a(MekanismRenderer.getBlocksTexture());
            this.drawTexturedRectFromIcon(12, 44, MekanismRenderer.getColorIcon(((TMaterialFilter)this.filter).color), 16, 16);
            GL11.glDisable((int)2896);
            GlStateManager.func_179121_F();
        }
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 11 && xAxis <= 22 && yAxis >= 64 && yAxis <= 75) {
            this.func_146279_a(LangUtils.localize("gui.allowDefault"), xAxis, yAxis);
        }
        if (xAxis >= 12 && xAxis <= 28 && yAxis >= 44 && yAxis <= 60) {
            if (((TMaterialFilter)this.filter).color != null) {
                this.func_146279_a(((TMaterialFilter)this.filter).color.getColoredName(), xAxis, yAxis);
            } else {
                this.func_146279_a(LangUtils.localize("gui.none"), xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(this.getGuiLocation());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16) {
            this.func_73729_b(guiWidth + 5, guiHeight + 5, 176, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 5, guiHeight + 5, 176, 11, 11, 11);
        }
        if (xAxis >= 11 && xAxis <= 22 && yAxis >= 64 && yAxis <= 75) {
            this.func_73729_b(guiWidth + 11, guiHeight + 64, 198, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 11, guiHeight + 64, 198, 11, 11, 11);
        }
        if (xAxis >= 12 && xAxis <= 28 && yAxis >= 19 && yAxis <= 35) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            int x = guiWidth + 12;
            int y = guiHeight + 19;
            this.func_73733_a(x, y, x + 16, y + 16, -2130706433, -2130706433);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
        }
        super.func_146976_a(partialTick, mouseX, mouseY);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (button == 0) {
            if (xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16) {
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, Coord4D.get(this.tileEntity), this.isNew ? 4 : 0, 0, 0));
            }
            if (xAxis >= 12 && xAxis <= 28 && yAxis >= 19 && yAxis <= 35) {
                ItemStack stack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
                if (!stack.func_190926_b() && !Keyboard.isKeyDown((int)42)) {
                    if (stack.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_150357_h) {
                        ((TMaterialFilter)this.filter).setMaterialItem(stack.func_77946_l());
                        ((TMaterialFilter)this.filter).getMaterialItem().func_190920_e(1);
                    }
                } else if (stack.func_190926_b() && Keyboard.isKeyDown((int)42)) {
                    ((TMaterialFilter)this.filter).setMaterialItem(ItemStack.field_190927_a);
                }
                SoundHandler.playSound(SoundEvents.field_187909_gi);
            }
            if (xAxis >= 11 && xAxis <= 22 && yAxis >= 64 && yAxis <= 75) {
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                boolean bl = ((TMaterialFilter)this.filter).allowDefault = !((TMaterialFilter)this.filter).allowDefault;
            }
        }
        if (Keyboard.isKeyDown((int)42) && button == 0) {
            button = 2;
        }
        if (xAxis >= 12 && xAxis <= 28 && yAxis >= 44 && yAxis <= 60) {
            SoundHandler.playSound(MekanismSounds.DING);
            if (button == 0) {
                ((TMaterialFilter)this.filter).color = TransporterUtils.increment(((TMaterialFilter)this.filter).color);
            } else if (button == 1) {
                ((TMaterialFilter)this.filter).color = TransporterUtils.decrement(((TMaterialFilter)this.filter).color);
            } else if (button == 2) {
                ((TMaterialFilter)this.filter).color = null;
            }
        }
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiTMaterialFilter.png");
    }
}

