/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import java.io.IOException;
import mekanism.api.Coord4D;
import mekanism.client.gui.filter.GuiModIDFilter;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismSounds;
import mekanism.common.OreDictCache;
import mekanism.common.content.transporter.TModIDFilter;
import mekanism.common.network.PacketLogisticalSorterGui;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiTModIDFilter
extends GuiModIDFilter<TModIDFilter, TileEntityLogisticalSorter> {
    public GuiTModIDFilter(EntityPlayer player, TileEntityLogisticalSorter tile, int index) {
        super(player, tile);
        this.origFilter = (TModIDFilter)((TileEntityLogisticalSorter)this.tileEntity).filters.get(index);
        this.filter = ((TModIDFilter)((TileEntityLogisticalSorter)this.tileEntity).filters.get(index)).clone();
        this.updateStackList(((TModIDFilter)this.filter).getModID());
    }

    public GuiTModIDFilter(EntityPlayer player, TileEntityLogisticalSorter tile) {
        super(player, tile);
        this.isNew = true;
        this.filter = new TModIDFilter();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b((this.isNew ? LangUtils.localize("gui.new") : LangUtils.localize("gui.edit")) + " " + LangUtils.localize("gui.modIDFilter"), 43, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.status") + ": " + this.status, 35, 20, 52480);
        this.renderScaledText(LangUtils.localize("gui.id") + ": " + ((TModIDFilter)this.filter).getModID(), 35, 32, 52480, 107);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui." + (((TModIDFilter)this.filter).allowDefault ? "on" : "off")), 24, 66, 0x404040);
        if (!this.renderStack.func_190926_b()) {
            try {
                GlStateManager.func_179094_E();
                RenderHelper.func_74520_c();
                this.field_146296_j.func_180450_b(this.renderStack, 12, 19);
                RenderHelper.func_74518_a();
                GlStateManager.func_179121_F();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (((TModIDFilter)this.filter).color != null) {
            GlStateManager.func_179094_E();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)32826);
            this.field_146297_k.func_110434_K().func_110577_a(MekanismRenderer.getBlocksTexture());
            this.drawTexturedRectFromIcon(12, 44, MekanismRenderer.getColorIcon(((TModIDFilter)this.filter).color), 16, 16);
            GL11.glDisable((int)2896);
            GlStateManager.func_179121_F();
        }
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 11 && xAxis <= 22 && yAxis >= 64 && yAxis <= 75) {
            this.func_146279_a(LangUtils.localize("gui.allowDefault"), xAxis, yAxis);
        }
        if (xAxis >= 12 && xAxis <= 28 && yAxis >= 44 && yAxis <= 60) {
            if (((TModIDFilter)this.filter).color != null) {
                this.func_146279_a(((TModIDFilter)this.filter).color.getColoredName(), xAxis, yAxis);
            } else {
                this.func_146279_a(LangUtils.localize("gui.none"), xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(this.getGuiLocation());
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16) {
            this.func_73729_b(guiWidth + 5, guiHeight + 5, 176, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 5, guiHeight + 5, 176, 11, 11, 11);
        }
        if (xAxis >= 131 && xAxis <= 143 && yAxis >= 47 && yAxis <= 59) {
            this.func_73729_b(guiWidth + 131, guiHeight + 47, 187, 0, 12, 12);
        } else {
            this.func_73729_b(guiWidth + 131, guiHeight + 47, 187, 12, 12, 12);
        }
        if (xAxis >= 11 && xAxis <= 22 && yAxis >= 64 && yAxis <= 75) {
            this.func_73729_b(guiWidth + 11, guiHeight + 64, 199, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 11, guiHeight + 64, 199, 11, 11, 11);
        }
        this.modIDText.func_146194_f();
        super.func_146976_a(partialTick, mouseX, mouseY);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.modIDText.func_146192_a(mouseX, mouseY, button);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (button == 0) {
            if (xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16) {
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, Coord4D.get(this.tileEntity), this.isNew ? 4 : 0, 0, 0));
            }
            if (xAxis >= 131 && xAxis <= 143 && yAxis >= 47 && yAxis <= 59) {
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                this.setModID();
            }
            if (xAxis >= 11 && xAxis <= 22 && yAxis >= 64 && yAxis <= 75) {
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                boolean bl = ((TModIDFilter)this.filter).allowDefault = !((TModIDFilter)this.filter).allowDefault;
            }
        }
        if (Keyboard.isKeyDown((int)42) && button == 0) {
            button = 2;
        }
        if (xAxis >= 12 && xAxis <= 28 && yAxis >= 44 && yAxis <= 60) {
            SoundHandler.playSound(MekanismSounds.DING);
            if (button == 0) {
                ((TModIDFilter)this.filter).color = TransporterUtils.increment(((TModIDFilter)this.filter).color);
            } else if (button == 1) {
                ((TModIDFilter)this.filter).color = TransporterUtils.decrement(((TModIDFilter)this.filter).color);
            } else if (button == 2) {
                ((TModIDFilter)this.filter).color = null;
            }
        }
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiTModIDFilter.png");
    }

    @Override
    protected void updateStackList(String modName) {
        this.iterStacks = OreDictCache.getModIDStacks(modName, false);
        this.stackSwitch = 0;
        this.stackIndex = -1;
    }

    @Override
    protected void addButtons(int guiWidth, int guiHeight) {
        this.field_146292_n.add(new GuiButton(0, guiWidth + 47, guiHeight + 62, 60, 20, LangUtils.localize("gui.save")));
        this.field_146292_n.add(new GuiButton(1, guiWidth + 109, guiHeight + 62, 60, 20, LangUtils.localize("gui.delete")));
    }

    @Override
    protected void sendPacketToServer(int guiID) {
        Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, Coord4D.get(this.tileEntity), guiID, 0, 0));
    }
}

