/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine.other;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mekanism.api.infuse.InfuseObject;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.infuse.InfuseType;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.machine.other.MetallurgicInfuserRecipeWrapper;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;

public class MetallurgicInfuserRecipeCategory
extends BaseRecipeCategory {
    public MetallurgicInfuserRecipeCategory(IGuiHelper helper) {
        super(helper, "mekanism:gui/GuiMetallurgicInfuser.png", RecipeHandler.Recipe.METALLURGIC_INFUSER.getJEICategory(), "tile.MachineBlock.MetallurgicInfuser.name", GuiProgress.ProgressBar.MEDIUM, 5, 16, 166, 54);
    }

    public static List<ItemStack> getInfuseStacks(InfuseType type) {
        return InfuseRegistry.getObjectMap().entrySet().stream().filter(obj -> ((InfuseObject)obj.getValue()).type == type).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    protected void addGuiElements() {
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.EXTRA, this, this.guiLocation, 16, 34));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.INPUT, this, this.guiLocation, 50, 42));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.POWER, this, this.guiLocation, 142, 34).with(GuiSlot.SlotOverlay.POWER));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.OUTPUT, this, this.guiLocation, 108, 42));
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, new GuiPowerBar.IPowerInfoHandler(){

            @Override
            public double getLevel() {
                return 1.0;
            }
        }, this.guiLocation, 164, 15));
        this.guiElements.add(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return (double)MetallurgicInfuserRecipeCategory.this.timer.getValue() / 20.0;
            }
        }, GuiProgress.ProgressBar.MEDIUM, this, this.guiLocation, 70, 46));
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        if (recipeWrapper instanceof MetallurgicInfuserRecipeWrapper) {
            MetallurgicInfuserRecipe tempRecipe = ((MetallurgicInfuserRecipeWrapper)recipeWrapper).getRecipe();
            IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
            itemStacks.init(0, true, 45, 26);
            itemStacks.init(1, false, 103, 26);
            itemStacks.init(2, true, 11, 18);
            itemStacks.set(0, ((InfusionInput)tempRecipe.getInput()).inputStack);
            itemStacks.set(1, ((ItemStackOutput)tempRecipe.getOutput()).output);
            itemStacks.set(2, MetallurgicInfuserRecipeCategory.getInfuseStacks(((InfusionInput)tempRecipe.getInput()).infuse.type));
        }
    }
}

