/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.item.machine;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.client.render.item.ItemLayerWrapper;
import mekanism.client.render.item.SubTypeItemRenderer;
import mekanism.client.render.item.machine.RenderChemicalCrystallizerItem;
import mekanism.client.render.item.machine.RenderChemicalDissolutionChamberItem;
import mekanism.client.render.item.machine.RenderDigitalMinerItem;
import mekanism.client.render.item.machine.RenderFluidTankItem;
import mekanism.client.render.item.machine.RenderPersonalChestItem;
import mekanism.client.render.item.machine.RenderQuantumEntangloporterItem;
import mekanism.client.render.item.machine.RenderResistiveHeaterItem;
import mekanism.client.render.item.machine.RenderSeismicVibratorItem;
import mekanism.client.render.item.machine.RenderSolarNeutronActivatorItem;
import mekanism.common.block.states.BlockStateMachine;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderMachineItem
extends SubTypeItemRenderer<BlockStateMachine.MachineType> {
    public static Map<BlockStateMachine.MachineType, ItemLayerWrapper> modelMap = new HashMap<BlockStateMachine.MachineType, ItemLayerWrapper>();

    @Override
    protected boolean earlyExit() {
        return true;
    }

    @Override
    protected void renderBlockSpecific(@Nonnull ItemStack stack, ItemCameraTransforms.TransformType transformType) {
        BlockStateMachine.MachineType machineType = BlockStateMachine.MachineType.get(stack);
        if (machineType != null) {
            if (machineType == BlockStateMachine.MachineType.FLUID_TANK) {
                RenderFluidTankItem.renderStack(stack, transformType);
            } else if (machineType == BlockStateMachine.MachineType.PERSONAL_CHEST) {
                RenderPersonalChestItem.renderStack(stack, transformType);
            } else if (machineType == BlockStateMachine.MachineType.SOLAR_NEUTRON_ACTIVATOR) {
                RenderSolarNeutronActivatorItem.renderStack(stack, transformType);
            } else if (machineType == BlockStateMachine.MachineType.SEISMIC_VIBRATOR) {
                RenderSeismicVibratorItem.renderStack(stack, transformType);
            } else if (machineType == BlockStateMachine.MachineType.CHEMICAL_CRYSTALLIZER) {
                RenderChemicalCrystallizerItem.renderStack(stack, transformType);
            } else if (machineType == BlockStateMachine.MachineType.CHEMICAL_DISSOLUTION_CHAMBER) {
                RenderChemicalDissolutionChamberItem.renderStack(stack, transformType);
            } else if (machineType == BlockStateMachine.MachineType.QUANTUM_ENTANGLOPORTER) {
                RenderQuantumEntangloporterItem.renderStack(stack, transformType);
            } else if (machineType == BlockStateMachine.MachineType.RESISTIVE_HEATER) {
                RenderResistiveHeaterItem.renderStack(stack, transformType);
            } else if (machineType == BlockStateMachine.MachineType.DIGITAL_MINER) {
                RenderDigitalMinerItem.renderStack(stack, transformType);
            }
        }
    }

    @Override
    protected void renderItemSpecific(@Nonnull ItemStack stack, ItemCameraTransforms.TransformType transformType) {
    }

    @Override
    @Nullable
    protected ItemLayerWrapper getModel(BlockStateMachine.MachineType machineType) {
        return modelMap.get(machineType);
    }

    @Override
    @Nullable
    protected BlockStateMachine.MachineType getType(@Nonnull ItemStack stack) {
        return BlockStateMachine.MachineType.get(stack);
    }
}

