/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.obj;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import mekanism.client.render.obj.GlowPanelModel;
import mekanism.client.render.obj.MekanismOBJModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;

public class MekanismOBJLoader
implements ICustomModelLoader {
    public static final MekanismOBJLoader INSTANCE = new MekanismOBJLoader();
    public static final ImmutableMap<String, String> flipData = ImmutableMap.of((Object)"flip-v", (Object)String.valueOf(true));
    public static final String[] OBJ_RENDERS = new String[]{"glow_panel"};
    private final Map<ResourceLocation, MekanismOBJModel> modelCache = new HashMap<ResourceLocation, MekanismOBJModel>();

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        GlowPanelModel.forceRebake();
        for (String s : OBJ_RENDERS) {
            ModelResourceLocation model = new ModelResourceLocation("mekanism:" + s, "inventory");
            IBakedModel bakedModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)model);
            event.getModelRegistry().func_82595_a((Object)model, (Object)this.createBakedObjItemModel(bakedModel, "mekanism:models/block/" + s + ".obj.mek", (IModelState)new OBJModel.OBJState((List)Lists.newArrayList((Object[])new String[]{"OBJModel.Group.All.Key"}), true), DefaultVertexFormats.field_176599_b));
        }
    }

    public OBJModel.OBJBakedModel createBakedObjItemModel(IBakedModel existingModel, String name, IModelState state, VertexFormat format) {
        try {
            Function textureGetter = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
            ResourceLocation modelLocation = new ResourceLocation(name);
            OBJModel objModel = (OBJModel)OBJLoader.INSTANCE.loadModel(modelLocation);
            objModel = (OBJModel)objModel.process(flipData);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)ModelLoader.White.LOCATION.toString(), (Object)ModelLoader.White.INSTANCE);
            TextureAtlasSprite missing = (TextureAtlasSprite)textureGetter.apply((Object)new ResourceLocation("missingno"));
            for (String s : objModel.getMatLib().getMaterialNames()) {
                if (objModel.getMatLib().getMaterial(s).getTexture().getTextureLocation().func_110623_a().startsWith("#")) {
                    FMLLog.log((Level)Level.ERROR, (String)"OBJLoader: Unresolved texture '%s' for obj model '%s'", (Object[])new Object[]{objModel.getMatLib().getMaterial(s).getTexture().getTextureLocation().func_110623_a(), modelLocation});
                    builder.put((Object)s, (Object)missing);
                    continue;
                }
                builder.put((Object)s, textureGetter.apply((Object)objModel.getMatLib().getMaterial(s).getTexture().getTextureLocation()));
            }
            builder.put((Object)"missingno", (Object)missing);
            return new GlowPanelModel(existingModel, objModel, state, format, (ImmutableMap<String, TextureAtlasSprite>)builder.build(), new HashMap<ItemCameraTransforms.TransformType, Matrix4f>());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean accepts(@Nonnull ResourceLocation modelLocation) {
        return modelLocation.func_110623_a().endsWith(".obj.mek");
    }

    @Nonnull
    public IModel loadModel(@Nonnull ResourceLocation loc) throws Exception {
        MekanismOBJModel mekModel;
        IModel model;
        ResourceLocation file = new ResourceLocation(loc.func_110624_b(), loc.func_110623_a());
        if (!this.modelCache.containsKey(file) && (model = OBJLoader.INSTANCE.loadModel(file)) instanceof OBJModel) {
            if (file.func_110623_a().contains("glow_panel")) {
                MekanismOBJModel mekModel2 = new MekanismOBJModel(MekanismOBJModel.OBJModelType.GLOW_PANEL, ((OBJModel)model).getMatLib(), file);
                this.modelCache.put(file, mekModel2);
            } else if (file.func_110623_a().contains("transmitter")) {
                MekanismOBJModel mekModel3 = new MekanismOBJModel(MekanismOBJModel.OBJModelType.TRANSMITTER, ((OBJModel)model).getMatLib(), file);
                this.modelCache.put(file, mekModel3);
            }
        }
        if ((mekModel = this.modelCache.get(file)) == null) {
            return ModelLoaderRegistry.getMissingModel();
        }
        return mekModel;
    }

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        this.modelCache.clear();
    }
}

