/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.obj;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelState;

public abstract class OBJBakedModelBase
extends OBJModel.OBJBakedModel {
    private static Method m_updateStateVisibilityMap;
    private static Field f_textures;
    protected IBakedModel baseModel;
    protected TextureAtlasSprite tempSprite;
    protected VertexFormat vertexFormat;
    protected ImmutableMap<String, TextureAtlasSprite> textureMap;
    protected HashMap<ItemCameraTransforms.TransformType, Matrix4f> transformationMap;

    public OBJBakedModelBase(IBakedModel base, OBJModel model, IModelState state, VertexFormat format, ImmutableMap<String, TextureAtlasSprite> textures, HashMap<ItemCameraTransforms.TransformType, Matrix4f> transform) {
        OBJModel oBJModel = model;
        oBJModel.getClass();
        super(oBJModel, model, state, format, textures);
        this.tempSprite = ModelLoader.White.INSTANCE;
        this.baseModel = base;
        this.transformationMap = transform;
        this.textureMap = textures;
        this.vertexFormat = format;
        if (state instanceof OBJModel.OBJState) {
            this.updateStateVisibilityMap((OBJModel.OBJState)state);
        }
    }

    public static void putVertexData(UnpackedBakedQuad.Builder builder, OBJModel.Vertex v, OBJModel.Normal faceNormal, OBJModel.TextureCoordinate defUV, TextureAtlasSprite sprite, VertexFormat format, float[] color) {
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{v.getPos().x, v.getPos().y, v.getPos().z, v.getPos().w});
                    continue block6;
                }
                case COLOR: {
                    float d = v.hasNormal() ? LightUtil.diffuseLight((float)v.getNormal().x, (float)v.getNormal().y, (float)v.getNormal().z) : LightUtil.diffuseLight((float)faceNormal.x, (float)faceNormal.y, (float)faceNormal.z);
                    builder.put(e, new float[]{d * v.getMaterial().getColor().x * color[0], d * v.getMaterial().getColor().y * color[1], d * v.getMaterial().getColor().z * color[2], v.getMaterial().getColor().w * color[3]});
                    continue block6;
                }
                case UV: {
                    if (!v.hasTextureCoordinate()) {
                        builder.put(e, new float[]{sprite.func_94214_a((double)(defUV.u * 16.0f)), sprite.func_94207_b((double)((1.0f - defUV.v) * 16.0f)), 0.0f, 1.0f});
                        continue block6;
                    }
                    builder.put(e, new float[]{sprite.func_94214_a((double)(v.getTextureCoordinate().u * 16.0f)), sprite.func_94207_b((double)((1.0f - v.getTextureCoordinate().v) * 16.0f)), 0.0f, 1.0f});
                    continue block6;
                }
                case NORMAL: {
                    if (!v.hasNormal()) {
                        builder.put(e, new float[]{faceNormal.x, faceNormal.y, faceNormal.z, 0.0f});
                        continue block6;
                    }
                    builder.put(e, new float[]{v.getNormal().x, v.getNormal().y, v.getNormal().z, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public static ImmutableMap<String, TextureAtlasSprite> getTexturesForOBJModel(IBakedModel model) {
        try {
            if (f_textures == null) {
                f_textures = OBJModel.OBJBakedModel.class.getDeclaredField("textures");
                f_textures.setAccessible(true);
            }
            return (ImmutableMap)f_textures.get(model);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    public List<BakedQuad> func_188616_a(IBlockState blockState, EnumFacing side, long rand) {
        OBJModel.Vertex[] groupFaces;
        if (side != null) {
            return ImmutableList.of();
        }
        ArrayList<UnpackedBakedQuad> bakedQuads = new ArrayList<UnpackedBakedQuad>();
        Set<OBJModel.Face> faces = Collections.synchronizedSet(new LinkedHashSet());
        Optional transform = Optional.empty();
        HashMap<OBJModel.Face, String> groupNameMap = new HashMap<OBJModel.Face, String>();
        for (OBJModel.Group g : this.getModel().getMatLib().getGroups().values()) {
            if (this.getState() instanceof OBJModel.OBJState) {
                OBJModel.OBJState state = (OBJModel.OBJState)this.getState();
                if (state.parent != null) {
                    transform = state.parent.apply(Optional.empty());
                }
                this.updateStateVisibilityMap(state);
                if (!state.getGroupsWithVisibility(true).contains(g.getName())) continue;
                groupFaces = g.applyTransform(transform);
                for (OBJModel.Face face : groupFaces) {
                    groupNameMap.put(face, g.getName());
                    faces.add(face);
                }
                continue;
            }
            transform = this.getState().apply(Optional.empty());
            LinkedHashSet groupFaces2 = g.applyTransform(transform);
            for (OBJModel.Face f2 : groupFaces2) {
                groupNameMap.put(f2, g.getName());
                faces.add(f2);
            }
        }
        for (OBJModel.Face f : faces) {
            String groupName;
            if (this.getOverrideTexture(f, groupName = (String)groupNameMap.get(f)) != null) {
                this.tempSprite = this.getOverrideTexture(f, groupName);
            } else if (this.getModel().getMatLib().getMaterial(f.getMaterialName()).isWhite()) {
                void var14_18;
                groupFaces = f.getVertices();
                int f2 = groupFaces.length;
                boolean bl = false;
                while (var14_18 < f2) {
                    OBJModel.Vertex v = groupFaces[var14_18];
                    if (!v.getMaterial().equals(this.getModel().getMatLib().getMaterial(v.getMaterial().getName()))) {
                        v.setMaterial(this.getModel().getMatLib().getMaterial(v.getMaterial().getName()));
                    }
                    ++var14_18;
                }
                this.tempSprite = ModelLoader.White.INSTANCE;
            } else {
                this.tempSprite = (TextureAtlasSprite)this.textureMap.get((Object)f.getMaterialName());
            }
            float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            if (this.getOverrideColor(f, groupName) != null) {
                color = this.getOverrideColor(f, groupName);
            }
            EnumFacing facing = EnumFacing.func_176737_a((float)f.getNormal().x, (float)f.getNormal().y, (float)f.getNormal().z);
            UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.vertexFormat);
            builder.setContractUVs(true);
            builder.setQuadOrientation(facing);
            builder.setTexture(this.tempSprite);
            builder.setQuadTint(0);
            OBJModel.Normal faceNormal = f.getNormal();
            boolean rotate = this.shouldRotate(f, groupName);
            OBJBakedModelBase.putVertexData(builder, f.getVertices()[0], faceNormal, OBJModel.TextureCoordinate.getDefaultUVs()[0], this.tempSprite, this.vertexFormat, color);
            OBJBakedModelBase.putVertexData(builder, f.getVertices()[1], faceNormal, OBJModel.TextureCoordinate.getDefaultUVs()[1], this.tempSprite, this.vertexFormat, color);
            OBJBakedModelBase.putVertexData(builder, f.getVertices()[2], faceNormal, OBJModel.TextureCoordinate.getDefaultUVs()[2], this.tempSprite, this.vertexFormat, color);
            OBJBakedModelBase.putVertexData(builder, f.getVertices()[3], faceNormal, OBJModel.TextureCoordinate.getDefaultUVs()[3], this.tempSprite, this.vertexFormat, color);
            UnpackedBakedQuad quad = builder.build();
            if (rotate) {
                quad = MekanismRenderer.rotate((BakedQuad)quad, 1);
            }
            bakedQuads.add(quad);
        }
        List<BakedQuad> quadList = Collections.synchronizedList(Lists.newArrayList(bakedQuads));
        return quadList;
    }

    protected void updateStateVisibilityMap(OBJModel.OBJState state) {
        try {
            if (m_updateStateVisibilityMap == null) {
                m_updateStateVisibilityMap = OBJModel.OBJBakedModel.class.getDeclaredMethod("updateStateVisibilityMap", OBJModel.OBJState.class);
                m_updateStateVisibilityMap.setAccessible(true);
            }
            m_updateStateVisibilityMap.invoke((Object)this, state);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.tempSprite;
    }

    protected float[] getOverrideColor(OBJModel.Face f, String groupName) {
        return null;
    }

    protected TextureAtlasSprite getOverrideTexture(OBJModel.Face f, String groupName) {
        return null;
    }

    protected boolean shouldRotate(OBJModel.Face f, String groupName) {
        return false;
    }
}

