/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.Locale;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.OreGas;
import mekanism.common.Resource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class MekanismFluids {
    public static final Gas Hydrogen = new Gas("hydrogen", 0xFFFFFF);
    public static final Gas Oxygen = new Gas("oxygen", 7135999);
    public static final Gas Water = new Gas("water", "mekanism:blocks/liquid/LiquidSteam");
    public static final Gas Chlorine = new Gas("chlorine", 13625344);
    public static final Gas SulfurDioxide = new Gas("sulfurdioxide", 11115920);
    public static final Gas SulfurTrioxide = new Gas("sulfurtrioxide", 0xCE6C6C);
    public static final Gas SulfuricAcid = new Gas("sulfuricacid", 8552491);
    public static final Gas HydrogenChloride = new Gas("hydrogenchloride", 11071977);
    public static final Fluid HeavyWater = new Fluid("heavywater", new ResourceLocation("mekanism:blocks/liquid/LiquidHeavyWater"), new ResourceLocation("mekanism:blocks/liquid/LiquidHeavyWater"));
    public static final Fluid Steam = new Fluid("steam", new ResourceLocation("mekanism:blocks/liquid/LiquidSteam"), new ResourceLocation("mekanism:blocks/liquid/LiquidSteam")).setGaseous(true);
    public static final Gas LiquidOsmium = new Gas("liquidosmium", 9474211);
    public static final Gas Ethene = new Gas("ethene", 15387897);
    public static final Gas Sodium = new Gas("sodium", 15335156);
    public static final Gas Brine = new Gas("brine", 16707484);
    public static final Gas Deuterium = new Gas("deuterium", 0xFF3232);
    public static final Gas Tritium = new Gas("tritium", 6618992);
    public static final Gas FusionFuel = new Gas("fusionfuel", 8257661);
    public static final Gas Lithium = new Gas("lithium", 15442944);

    public static void register() {
        GasRegistry.register(Hydrogen).registerFluid("liquidhydrogen");
        GasRegistry.register(Oxygen).registerFluid("liquidoxygen");
        GasRegistry.register(Water).registerFluid();
        GasRegistry.register(Chlorine).registerFluid("liquidchlorine");
        GasRegistry.register(SulfurDioxide).registerFluid("liquidsulfurdioxide");
        GasRegistry.register(SulfurTrioxide).registerFluid("liquidsulfurtrioxide");
        GasRegistry.register(SulfuricAcid).registerFluid();
        GasRegistry.register(HydrogenChloride).registerFluid("liquidhydrogenchloride");
        GasRegistry.register(Ethene).registerFluid("liquidethene");
        GasRegistry.register(Sodium).registerFluid("liquidsodium");
        GasRegistry.register(Brine).registerFluid();
        GasRegistry.register(Deuterium).registerFluid("liquiddeuterium");
        GasRegistry.register(Tritium).registerFluid("liquidtritium");
        GasRegistry.register(FusionFuel).registerFluid("liquidfusionfuel");
        GasRegistry.register(Lithium).registerFluid("liquidlithium");
        GasRegistry.register(LiquidOsmium).setVisible(false);
        FluidRegistry.registerFluid((Fluid)HeavyWater);
        FluidRegistry.registerFluid((Fluid)Steam);
        for (Resource resource : Resource.values()) {
            String name = resource.getName();
            String nameLower = name.toLowerCase(Locale.ROOT);
            OreGas clean = new OreGas("clean" + name, "oregas." + nameLower, resource.tint);
            GasRegistry.register(clean);
            GasRegistry.register(new OreGas(nameLower, "oregas." + nameLower, resource.tint, clean));
        }
        FluidRegistry.enableUniversalBucket();
        FluidRegistry.addBucketForFluid((Fluid)HeavyWater);
        FluidRegistry.addBucketForFluid((Fluid)Brine.getFluid());
        FluidRegistry.addBucketForFluid((Fluid)Lithium.getFluid());
    }
}

