/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.HashSet;
import java.util.Set;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.PacketFlamethrowerData;
import mekanism.common.network.PacketJetpackData;
import mekanism.common.network.PacketScubaTankData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class PlayerState {
    private Set<String> activeJetpacks = new HashSet<String>();
    private Set<String> activeGasmasks = new HashSet<String>();
    private Set<String> activeFlamethrowers = new HashSet<String>();
    private World world;

    public void clear() {
        this.activeJetpacks.clear();
        this.activeGasmasks.clear();
        this.activeFlamethrowers.clear();
    }

    public void clearPlayer(EntityPlayer p) {
        this.activeJetpacks.remove(p.func_70005_c_());
        this.activeGasmasks.remove(p.func_70005_c_());
        this.activeFlamethrowers.remove(p.func_70005_c_());
    }

    public void init(World world) {
        this.world = world;
    }

    public void setJetpackState(String playerId, boolean isActive, boolean isLocal) {
        boolean changed;
        boolean alreadyActive = this.activeJetpacks.contains(playerId);
        boolean bl = changed = alreadyActive != isActive;
        if (alreadyActive && !isActive) {
            this.activeJetpacks.remove(playerId);
        } else if (!alreadyActive && isActive) {
            this.activeJetpacks.add(playerId);
        }
        if (changed && this.world.field_72995_K) {
            if (isLocal) {
                Mekanism.packetHandler.sendToServer(PacketJetpackData.JetpackDataMessage.UPDATE(playerId, isActive));
            }
            if (isActive && MekanismConfig.client.enablePlayerSounds) {
                SoundHandler.startSound(this.world.func_72924_a(playerId), "jetpack");
            }
        }
    }

    public boolean isJetpackOn(EntityPlayer p) {
        return this.activeJetpacks.contains(p.func_70005_c_());
    }

    public Set<String> getActiveJetpacks() {
        return this.activeJetpacks;
    }

    public void setActiveJetpacks(Set<String> newActiveJetpacks) {
        for (String activeUser : newActiveJetpacks) {
            this.setJetpackState(activeUser, true, false);
        }
    }

    public void setGasmaskState(String playerId, boolean isActive, boolean isLocal) {
        boolean changed;
        boolean alreadyActive = this.activeGasmasks.contains(playerId);
        boolean bl = changed = alreadyActive != isActive;
        if (alreadyActive && !isActive) {
            this.activeGasmasks.remove(playerId);
        } else if (!alreadyActive && isActive) {
            this.activeGasmasks.add(playerId);
        }
        if (changed && this.world.field_72995_K) {
            if (isLocal) {
                Mekanism.packetHandler.sendToServer(PacketScubaTankData.ScubaTankDataMessage.UPDATE(playerId, isActive));
            }
            if (isActive && MekanismConfig.client.enablePlayerSounds) {
                SoundHandler.startSound(this.world.func_72924_a(playerId), "gasmask");
            }
        }
    }

    public boolean isGasmaskOn(EntityPlayer p) {
        return this.activeGasmasks.contains(p.func_70005_c_());
    }

    public Set<String> getActiveGasmasks() {
        return this.activeGasmasks;
    }

    public void setActiveGasmasks(Set<String> newActiveGasmasks) {
        for (String activeUser : newActiveGasmasks) {
            this.setGasmaskState(activeUser, true, false);
        }
    }

    public void setFlamethrowerState(String playerId, boolean isActive, boolean isLocal) {
        boolean changed;
        boolean alreadyActive = this.activeFlamethrowers.contains(playerId);
        boolean bl = changed = alreadyActive != isActive;
        if (alreadyActive && !isActive) {
            this.activeFlamethrowers.remove(playerId);
        } else if (!alreadyActive && isActive) {
            this.activeFlamethrowers.add(playerId);
        }
        if (changed && this.world.field_72995_K) {
            if (isLocal) {
                Mekanism.packetHandler.sendToServer(new PacketFlamethrowerData.FlamethrowerDataMessage(PacketFlamethrowerData.FlamethrowerPacket.UPDATE, null, playerId, isActive));
            }
            if (isActive && MekanismConfig.client.enablePlayerSounds) {
                SoundHandler.startSound(this.world.func_72924_a(playerId), "flamethrower");
            }
        }
    }

    public boolean isFlamethrowerOn(EntityPlayer p) {
        return this.activeFlamethrowers.contains(p.func_70005_c_());
    }
}

