/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import java.util.HashMap;
import java.util.Map;
import mekanism.common.content.transporter.Finder;
import mekanism.common.content.transporter.InvStack;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;

public class TransitRequest {
    public Map<ItemStack, Integer> itemMap = new HashMap<ItemStack, Integer>();

    public static TransitRequest getFromTransport(TransporterStack stack) {
        return TransitRequest.getFromStack(stack.itemStack);
    }

    public static TransitRequest getFromStack(ItemStack stack) {
        TransitRequest ret = new TransitRequest();
        ret.setItem(stack, -1);
        return ret;
    }

    public static TransitRequest getTopStacks(TileEntity tile, EnumFacing side, int amount) {
        return TransitRequest.getTopStacks(tile, side, amount, new Finder.FirstFinder());
    }

    public static TransitRequest getTopStacks(TileEntity tile, EnumFacing side, int amount, Finder finder) {
        TransitRequest ret;
        block4: {
            block5: {
                block3: {
                    ret = new TransitRequest();
                    if (!InventoryUtils.isItemHandler(tile, side.func_176734_d())) break block3;
                    IItemHandler inventory = InventoryUtils.getItemHandler(tile, side.func_176734_d());
                    for (int i = inventory.getSlots() - 1; i >= 0; --i) {
                        ItemStack stack = inventory.extractItem(i, amount, true);
                        if (stack.func_190926_b() || ret.hasType(stack) || !finder.modifies(stack)) continue;
                        ret.setItem(stack, i);
                    }
                    break block4;
                }
                if (!(tile instanceof ISidedInventory)) break block5;
                ISidedInventory sidedInventory = (ISidedInventory)tile;
                int[] slots = sidedInventory.func_180463_a(side.func_176734_d());
                for (int get = slots.length - 1; get >= 0; --get) {
                    int slotID = slots[get];
                    if (sidedInventory.func_70301_a(slotID).func_190926_b() || sidedInventory.func_70301_a(slotID).func_190916_E() <= 0) continue;
                    ItemStack toSend = sidedInventory.func_70301_a(slotID).func_77946_l();
                    toSend.func_190920_e(Math.min(amount, toSend.func_190916_E()));
                    if (ret.hasType(toSend) || !sidedInventory.func_180461_b(slotID, toSend, side.func_176734_d()) || !finder.modifies(toSend)) continue;
                    ret.setItem(toSend, slotID);
                }
                break block4;
            }
            if (!(tile instanceof IInventory)) break block4;
            IInventory inventory = InventoryUtils.checkChestInv((IInventory)tile);
            for (int i = inventory.func_70302_i_() - 1; i >= 0; --i) {
                if (inventory.func_70301_a(i).func_190926_b() || inventory.func_70301_a(i).func_190916_E() <= 0) continue;
                ItemStack toSend = inventory.func_70301_a(i).func_77946_l();
                toSend.func_190920_e(Math.min(amount, toSend.func_190916_E()));
                if (ret.hasType(toSend) || !finder.modifies(toSend)) continue;
                ret.setItem(toSend, i);
            }
        }
        return ret;
    }

    public boolean isEmpty() {
        return this.itemMap.isEmpty();
    }

    public void setItem(ItemStack stack, int slot) {
        this.itemMap.put(stack.func_77946_l(), slot);
    }

    public ItemStack getSingleStack() {
        return this.itemMap.keySet().iterator().next();
    }

    public boolean hasType(ItemStack stack) {
        for (ItemStack s : this.itemMap.keySet()) {
            if (!InventoryUtils.areItemsStackable(stack, s)) continue;
            return true;
        }
        return false;
    }

    public static class TransitResponse {
        public static final TransitResponse EMPTY = new TransitResponse(-1, ItemStack.field_190927_a);
        public int slotID;
        public ItemStack stack;

        public TransitResponse(int s, ItemStack i) {
            this.slotID = s;
            this.stack = i;
        }

        public boolean isEmpty() {
            return this.stack.func_190926_b();
        }

        public ItemStack getRejected(ItemStack orig) {
            return StackUtils.size(orig, orig.func_190916_E() - this.stack.func_190916_E());
        }

        public InvStack getInvStack(TileEntity tile, EnumFacing side) {
            return new InvStack(tile, this.slotID, this.stack, side);
        }
    }
}

