/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.common.PacketHandler;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.content.transporter.TransporterPathfinder;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.apache.commons.lang3.tuple.Pair;

public class TransporterStack {
    public ItemStack itemStack = ItemStack.field_190927_a;
    public int progress;
    public EnumColor color = null;
    public boolean initiatedPath = false;
    public EnumFacing idleDir = null;
    public Coord4D originalLocation;
    public Coord4D homeLocation;
    public Coord4D clientNext;
    public Coord4D clientPrev;
    public Path pathType;
    private List<Coord4D> pathToTarget = new ArrayList<Coord4D>();

    public static TransporterStack readFromNBT(NBTTagCompound nbtTags) {
        TransporterStack stack = new TransporterStack();
        stack.read(nbtTags);
        return stack;
    }

    public static TransporterStack readFromPacket(ByteBuf dataStream) {
        TransporterStack stack = new TransporterStack();
        stack.read(dataStream);
        return stack;
    }

    public void write(ILogisticalTransporter transporter, TileNetworkList data) {
        if (this.color != null) {
            data.add(TransporterUtils.colors.indexOf((Object)this.color));
        } else {
            data.add(-1);
        }
        data.add(this.progress);
        this.originalLocation.write(data);
        data.add(this.pathType.ordinal());
        if (this.pathToTarget.indexOf(transporter.coord()) > 0) {
            data.add(true);
            this.getNext(transporter).write(data);
        } else {
            data.add(false);
        }
        this.getPrev(transporter).write(data);
        data.add(this.itemStack);
    }

    public void read(ByteBuf dataStream) {
        int c = dataStream.readInt();
        this.color = c != -1 ? TransporterUtils.colors.get(c) : null;
        this.progress = dataStream.readInt();
        this.originalLocation = Coord4D.read(dataStream);
        this.pathType = Path.values()[dataStream.readInt()];
        if (dataStream.readBoolean()) {
            this.clientNext = Coord4D.read(dataStream);
        }
        this.clientPrev = Coord4D.read(dataStream);
        this.itemStack = PacketHandler.readStack(dataStream);
    }

    public void write(NBTTagCompound nbtTags) {
        if (this.color != null) {
            nbtTags.func_74768_a("color", TransporterUtils.colors.indexOf((Object)this.color));
        }
        nbtTags.func_74768_a("progress", this.progress);
        nbtTags.func_74782_a("originalLocation", (NBTBase)this.originalLocation.write(new NBTTagCompound()));
        if (this.idleDir != null) {
            nbtTags.func_74768_a("idleDir", this.idleDir.ordinal());
        }
        if (this.homeLocation != null) {
            nbtTags.func_74782_a("homeLocation", (NBTBase)this.homeLocation.write(new NBTTagCompound()));
        }
        nbtTags.func_74768_a("pathType", this.pathType.ordinal());
        this.itemStack.func_77955_b(nbtTags);
    }

    public void read(NBTTagCompound nbtTags) {
        if (nbtTags.func_74764_b("color")) {
            this.color = TransporterUtils.colors.get(nbtTags.func_74762_e("color"));
        }
        this.progress = nbtTags.func_74762_e("progress");
        this.originalLocation = Coord4D.read(nbtTags.func_74775_l("originalLocation"));
        if (nbtTags.func_74764_b("idleDir")) {
            this.idleDir = EnumFacing.values()[nbtTags.func_74762_e("idleDir")];
        }
        if (nbtTags.func_74764_b("homeLocation")) {
            this.homeLocation = Coord4D.read(nbtTags.func_74775_l("homeLocation"));
        }
        this.pathType = Path.values()[nbtTags.func_74762_e("pathType")];
        this.itemStack = InventoryUtils.loadFromNBT(nbtTags);
    }

    public void setPath(List<Coord4D> path, Path type) {
        if (this.pathType != Path.NONE) {
            TransporterManager.remove(this);
        }
        this.pathToTarget = path;
        this.pathType = type;
        if (this.pathType != Path.NONE) {
            TransporterManager.add(this);
        }
    }

    public boolean hasPath() {
        return this.getPath() != null && this.getPath().size() >= 2;
    }

    public List<Coord4D> getPath() {
        return this.pathToTarget;
    }

    public TransitRequest.TransitResponse recalculatePath(TransitRequest request, ILogisticalTransporter transporter, int min) {
        TransporterPathfinder.Destination newPath = TransporterPathfinder.getNewBasePath(transporter, this, request, min);
        if (newPath == null) {
            return TransitRequest.TransitResponse.EMPTY;
        }
        this.idleDir = null;
        this.setPath(newPath.path, Path.DEST);
        this.initiatedPath = true;
        return newPath.response;
    }

    public TransitRequest.TransitResponse recalculateRRPath(TransitRequest request, TileEntityLogisticalSorter outputter, ILogisticalTransporter transporter, int min) {
        TransporterPathfinder.Destination newPath = TransporterPathfinder.getNewRRPath(transporter, this, request, outputter, min);
        if (newPath == null) {
            return TransitRequest.TransitResponse.EMPTY;
        }
        this.idleDir = null;
        this.setPath(newPath.path, Path.DEST);
        this.initiatedPath = true;
        return newPath.response;
    }

    public boolean calculateIdle(ILogisticalTransporter transporter) {
        Pair<List<Coord4D>, Path> newPath = TransporterPathfinder.getIdlePath(transporter, this);
        if (newPath == null) {
            return false;
        }
        if (newPath.getRight() == Path.HOME) {
            this.idleDir = null;
        }
        this.setPath((List)newPath.getLeft(), (Path)((Object)newPath.getRight()));
        this.originalLocation = transporter.coord();
        this.initiatedPath = true;
        return true;
    }

    public boolean isFinal(ILogisticalTransporter transporter) {
        return this.pathToTarget.indexOf(transporter.coord()) == (this.pathType == Path.NONE ? 0 : 1);
    }

    public Coord4D getNext(ILogisticalTransporter transporter) {
        if (!transporter.world().field_72995_K) {
            int index = this.pathToTarget.indexOf(transporter.coord()) - 1;
            if (index < 0) {
                return null;
            }
            return this.pathToTarget.get(index);
        }
        return this.clientNext;
    }

    public Coord4D getPrev(ILogisticalTransporter transporter) {
        if (!transporter.world().field_72995_K) {
            int index = this.pathToTarget.indexOf(transporter.coord()) + 1;
            if (index < this.pathToTarget.size()) {
                return this.pathToTarget.get(index);
            }
            return this.originalLocation;
        }
        return this.clientPrev;
    }

    public EnumFacing getSide(ILogisticalTransporter transporter) {
        if (this.progress < 50) {
            if (this.getPrev(transporter) != null) {
                return transporter.coord().sideDifference(this.getPrev(transporter));
            }
        } else if (this.progress == 50 ? this.getNext(transporter) != null : this.getNext(transporter) != null) {
            return this.getNext(transporter).sideDifference(transporter.coord());
        }
        return EnumFacing.DOWN;
    }

    public boolean canInsertToTransporter(TileEntity tileEntity, EnumFacing from) {
        if (!CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, from.func_176734_d())) {
            return false;
        }
        ILogisticalTransporter transporter = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, from.func_176734_d());
        if (!CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.BLOCKABLE_CONNECTION_CAPABILITY, from.func_176734_d()).canConnectMutual(from.func_176734_d())) {
            return false;
        }
        return transporter.getColor() == this.color || transporter.getColor() == null;
    }

    public boolean canInsertToTransporter(ILogisticalTransporter transporter, EnumFacing side) {
        if (!transporter.canConnectMutual(side)) {
            return false;
        }
        return transporter.getColor() == this.color || transporter.getColor() == null;
    }

    public Coord4D getDest() {
        return this.getPath().get(0);
    }

    public static enum Path {
        DEST,
        HOME,
        NONE;

    }
}

