/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.mc1120.commands.CTChatCommand;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import java.util.LinkedList;
import java.util.List;
import mekanism.common.Mekanism;
import mekanism.common.integration.crafttweaker.commands.GasesCommand;
import mekanism.common.integration.crafttweaker.commands.InfuseTypesCommand;
import mekanism.common.integration.crafttweaker.commands.MekRecipesCommand;

public class CrafttweakerIntegration {
    public static final List<IAction> LATE_REMOVALS = new LinkedList<IAction>();
    public static final List<IAction> LATE_ADDITIONS = new LinkedList<IAction>();

    public static void applyRecipeChanges() {
        CrafttweakerIntegration.applyChanges(LATE_REMOVALS);
        CrafttweakerIntegration.applyChanges(LATE_ADDITIONS);
    }

    private static void applyChanges(List<IAction> actions) {
        actions.forEach(action -> {
            try {
                CraftTweakerAPI.apply((IAction)action);
            }
            catch (Exception e) {
                Mekanism.logger.error("CT action failed", (Throwable)e);
                CraftTweakerAPI.logError((String)"Mekanica CT action failed", (Throwable)e);
            }
        });
    }

    public static void registerCommands() {
        CTChatCommand.registerCommand((CraftTweakerCommand)new GasesCommand());
        CTChatCommand.registerCommand((CraftTweakerCommand)new InfuseTypesCommand());
        CTChatCommand.registerCommand((CraftTweakerCommand)new MekRecipesCommand());
    }
}

