/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.handlers;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import mekanism.common.integration.crafttweaker.CrafttweakerIntegration;
import mekanism.common.integration.crafttweaker.helpers.IngredientHelper;
import mekanism.common.integration.crafttweaker.util.AddMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.IngredientWrapper;
import mekanism.common.integration.crafttweaker.util.RemoveAllMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.RemoveMekanismRecipe;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.DoubleMachineInput;
import mekanism.common.recipe.machines.CombinerRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.combiner")
@ZenRegister
public class Combiner {
    public static final String NAME = "Mekanica Combiner";

    @ZenMethod
    public static void addRecipe(IItemStack itemInput, IItemStack extraInput, IItemStack itemOutput) {
        if (IngredientHelper.checkNotNull(NAME, new IIngredient[]{itemInput, extraInput, itemOutput})) {
            CrafttweakerIntegration.LATE_ADDITIONS.add(new AddMekanismRecipe<DoubleMachineInput, ItemStackOutput, CombinerRecipe>(NAME, RecipeHandler.Recipe.COMBINER, new CombinerRecipe(new DoubleMachineInput(IngredientHelper.toStack(itemInput), IngredientHelper.toStack(extraInput)), new ItemStackOutput(IngredientHelper.toStack(itemOutput)))));
        }
    }

    @ZenMethod
    @Deprecated
    public static void addRecipe(IItemStack itemInput, IItemStack itemOutput) {
        if (IngredientHelper.checkNotNull(NAME, new IIngredient[]{itemInput, itemOutput})) {
            CrafttweakerIntegration.LATE_ADDITIONS.add(new AddMekanismRecipe<DoubleMachineInput, ItemStackOutput, CombinerRecipe>(NAME, RecipeHandler.Recipe.COMBINER, new CombinerRecipe(IngredientHelper.toStack(itemInput), IngredientHelper.toStack(itemOutput))));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient itemOutput, @Optional IIngredient itemInput, @Optional IIngredient extraInput) {
        if (IngredientHelper.checkNotNull(NAME, itemOutput)) {
            CrafttweakerIntegration.LATE_REMOVALS.add(new RemoveMekanismRecipe<DoubleMachineInput, ItemStackOutput, CombinerRecipe>(NAME, RecipeHandler.Recipe.COMBINER, new IngredientWrapper(itemOutput), new IngredientWrapper(itemInput, extraInput)));
        }
    }

    @ZenMethod
    public static void removeAllRecipes() {
        CrafttweakerIntegration.LATE_REMOVALS.add(new RemoveAllMekanismRecipe<DoubleMachineInput, ItemStackOutput, CombinerRecipe>(NAME, RecipeHandler.Recipe.COMBINER));
    }
}

