/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.handlers;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import mekanism.common.integration.crafttweaker.CrafttweakerIntegration;
import mekanism.common.integration.crafttweaker.gas.IGasStack;
import mekanism.common.integration.crafttweaker.helpers.GasHelper;
import mekanism.common.integration.crafttweaker.helpers.IngredientHelper;
import mekanism.common.integration.crafttweaker.util.AddMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.IngredientWrapper;
import mekanism.common.integration.crafttweaker.util.RemoveAllMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.RemoveMekanismRecipe;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.machines.OsmiumCompressorRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.compressor")
@ZenRegister
public class Compressor {
    public static final String NAME = "Mekanica Compressor";

    @ZenMethod
    public static void addRecipe(IItemStack itemInput, IItemStack itemOutput) {
        if (IngredientHelper.checkNotNull(NAME, new IIngredient[]{itemInput, itemOutput})) {
            CrafttweakerIntegration.LATE_ADDITIONS.add(new AddMekanismRecipe<AdvancedMachineInput, ItemStackOutput, OsmiumCompressorRecipe>(NAME, RecipeHandler.Recipe.OSMIUM_COMPRESSOR, new OsmiumCompressorRecipe(IngredientHelper.toStack(itemInput), IngredientHelper.toStack(itemOutput))));
        }
    }

    @ZenMethod
    public static void addRecipe(IItemStack itemInput, IGasStack gasInput, IItemStack itemOutput) {
        if (IngredientHelper.checkNotNull(NAME, new IIngredient[]{itemInput, gasInput, itemOutput})) {
            CrafttweakerIntegration.LATE_ADDITIONS.add(new AddMekanismRecipe<AdvancedMachineInput, ItemStackOutput, OsmiumCompressorRecipe>(NAME, RecipeHandler.Recipe.OSMIUM_COMPRESSOR, new OsmiumCompressorRecipe(new AdvancedMachineInput(IngredientHelper.toStack(itemInput), GasHelper.toGas(gasInput).getGas()), new ItemStackOutput(IngredientHelper.toStack(itemOutput)))));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient itemOutput, @Optional IIngredient itemInput, @Optional IIngredient gasInput) {
        if (IngredientHelper.checkNotNull(NAME, itemOutput)) {
            CrafttweakerIntegration.LATE_REMOVALS.add(new RemoveMekanismRecipe<AdvancedMachineInput, ItemStackOutput, OsmiumCompressorRecipe>(NAME, RecipeHandler.Recipe.OSMIUM_COMPRESSOR, new IngredientWrapper(itemOutput), new IngredientWrapper(itemInput, gasInput)));
        }
    }

    @ZenMethod
    public static void removeAllRecipes() {
        CrafttweakerIntegration.LATE_REMOVALS.add(new RemoveAllMekanismRecipe<AdvancedMachineInput, ItemStackOutput, OsmiumCompressorRecipe>(NAME, RecipeHandler.Recipe.OSMIUM_COMPRESSOR));
    }
}

