/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.handlers;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import mekanism.common.integration.crafttweaker.CrafttweakerIntegration;
import mekanism.common.integration.crafttweaker.helpers.IngredientHelper;
import mekanism.common.integration.crafttweaker.util.AddMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.IngredientWrapper;
import mekanism.common.integration.crafttweaker.util.RemoveAllMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.RemoveMekanismRecipe;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.EnrichmentRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.enrichment")
@ZenRegister
public class Enrichment {
    public static final String NAME = "Mekanica Enrichment Chamber";

    @ZenMethod
    public static void addRecipe(IItemStack itemInput, IItemStack itemOutput) {
        if (IngredientHelper.checkNotNull(NAME, new IIngredient[]{itemInput, itemOutput})) {
            CrafttweakerIntegration.LATE_ADDITIONS.add(new AddMekanismRecipe<ItemStackInput, ItemStackOutput, EnrichmentRecipe>(NAME, RecipeHandler.Recipe.ENRICHMENT_CHAMBER, new EnrichmentRecipe(IngredientHelper.toStack(itemInput), IngredientHelper.toStack(itemOutput))));
        }
    }

    @ZenMethod
    public static void removeRecipe(IIngredient itemInput, @Optional IIngredient itemOutput) {
        if (IngredientHelper.checkNotNull(NAME, itemInput)) {
            CrafttweakerIntegration.LATE_REMOVALS.add(new RemoveMekanismRecipe<ItemStackInput, ItemStackOutput, EnrichmentRecipe>(NAME, RecipeHandler.Recipe.ENRICHMENT_CHAMBER, new IngredientWrapper(itemOutput), new IngredientWrapper(itemInput)));
        }
    }

    @ZenMethod
    public static void removeAllRecipes() {
        CrafttweakerIntegration.LATE_REMOVALS.add(new RemoveAllMekanismRecipe<ItemStackInput, ItemStackOutput, EnrichmentRecipe>(NAME, RecipeHandler.Recipe.ENRICHMENT_CHAMBER));
    }
}

