/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.util;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import mekanism.common.integration.crafttweaker.helpers.RecipeInfoHelper;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.MachineRecipe;

public abstract class RecipeMapModification<INPUT extends MachineInput<INPUT>, RECIPE extends MachineRecipe<INPUT, ?, RECIPE>>
implements IAction {
    protected final HashMap<INPUT, RECIPE> recipes;
    protected final Map<INPUT, RECIPE> map;
    protected final String name;
    protected boolean add;

    protected RecipeMapModification(String name, boolean add, RecipeHandler.Recipe<INPUT, ?, RECIPE> recipeType) {
        this.name = name;
        this.map = recipeType.get();
        this.add = add;
        this.recipes = new HashMap();
    }

    public void apply() {
        block4: {
            if (this.recipes.isEmpty()) break block4;
            if (this.add) {
                for (Map.Entry<INPUT, RECIPE> entry : this.recipes.entrySet()) {
                    MachineRecipe value;
                    MachineInput key = (MachineInput)entry.getKey();
                    if (this.map.put(key, value = (MachineRecipe)entry.getValue()) == null) continue;
                    CraftTweakerAPI.logInfo((String)String.format("Overwritten %s Recipe for %s", this.name, RecipeInfoHelper.getRecipeInfo(new AbstractMap.SimpleEntry<INPUT, MachineRecipe>(entry.getKey(), value))));
                }
            } else {
                for (MachineInput key : this.recipes.keySet()) {
                    if (this.map.remove(key) != null) continue;
                    CraftTweakerAPI.logError((String)String.format("Error removing %s Recipe : null object", this.name));
                }
            }
        }
    }

    private String getRecipeInfo() {
        if (!this.recipes.isEmpty()) {
            return this.recipes.entrySet().stream().filter(Objects::nonNull).map(RecipeInfoHelper::getRecipeInfo).collect(Collectors.joining(", "));
        }
        return "Unknown item";
    }

    public String describe() {
        return String.format("Removing %d %s Recipe(s) for %s", this.recipes.size(), this.name, this.getRecipeInfo());
    }
}

