/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.EnumColor;
import mekanism.common.base.IItemNetwork;
import mekanism.common.item.ItemEnergized;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemElectricBow
extends ItemEnergized
implements IItemNetwork {
    public ItemElectricBow() {
        super(120000.0);
        this.func_77664_n();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
        super.func_77624_a(itemstack, world, list, flag);
        list.add((Object)((Object)EnumColor.PINK) + LangUtils.localize("tooltip.fireMode") + ": " + (Object)((Object)EnumColor.GREY) + LangUtils.transOnOff(this.getFireState(itemstack)));
    }

    public void func_77615_a(ItemStack itemstack, World world, EntityLivingBase entityLiving, int itemUseCount) {
        if (entityLiving instanceof EntityPlayer && this.getEnergy(itemstack) > 0.0) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            boolean flag = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)itemstack) > 0;
            ItemStack ammo = this.findAmmo(player);
            int maxItemUse = this.func_77626_a(itemstack) - itemUseCount;
            if ((maxItemUse = ForgeEventFactory.onArrowLoose((ItemStack)itemstack, (World)world, (EntityPlayer)player, (int)maxItemUse, (!itemstack.func_190926_b() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (flag || !ammo.func_190926_b()) {
                boolean noConsume;
                if (ammo.func_190926_b()) {
                    ammo = new ItemStack(Items.field_151032_g);
                }
                float f = (float)maxItemUse / 20.0f;
                if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                    return;
                }
                if (f > 1.0f) {
                    f = 1.0f;
                }
                boolean bl = noConsume = flag && itemstack.func_77973_b() instanceof ItemArrow;
                if (!world.field_72995_K) {
                    ItemArrow itemarrow = (ItemArrow)(ammo.func_77973_b() instanceof ItemArrow ? ammo.func_77973_b() : Items.field_151032_g);
                    EntityArrow entityarrow = itemarrow.func_185052_a(world, itemstack, (EntityLivingBase)player);
                    entityarrow.func_184547_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                    if (f == 1.0f) {
                        entityarrow.func_70243_d(true);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        this.setEnergy(itemstack, this.getEnergy(itemstack) - (double)(this.getFireState(itemstack) ? 1200 : 120));
                    }
                    if (noConsume) {
                        entityarrow.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
                    }
                    entityarrow.func_70015_d(this.getFireState(itemstack) ? 100 : 0);
                    world.func_72838_d((Entity)entityarrow);
                }
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                if (!noConsume) {
                    ammo.func_190918_g(1);
                    if (ammo.func_190916_E() == 0) {
                        player.field_71071_by.func_184437_d(ammo);
                    }
                }
                player.func_71029_a(StatList.func_188057_b((Item)this));
            }
        }
    }

    public int func_77626_a(ItemStack itemstack) {
        return 72000;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack itemstack) {
        return EnumAction.BOW;
    }

    private ItemStack findAmmo(EntityPlayer player) {
        if (this.isArrow(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isArrow(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isArrow(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    protected boolean isArrow(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemArrow;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand hand) {
        boolean flag;
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemStackIn, (World)worldIn, (EntityPlayer)playerIn, (EnumHand)hand, (boolean)(flag = !this.findAmmo(playerIn).func_190926_b()));
        if (ret != null) {
            return ret;
        }
        if (!playerIn.field_71075_bZ.field_75098_d && !flag) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStackIn);
        }
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public void setFireState(ItemStack itemstack, boolean state) {
        ItemDataUtils.setBoolean(itemstack, "fireState", state);
    }

    public boolean getFireState(ItemStack itemstack) {
        return ItemDataUtils.getBoolean(itemstack, "fireState");
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }

    @Override
    public void handlePacketData(ItemStack stack, ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            boolean state = dataStream.readBoolean();
            this.setFireState(stack, state);
        }
    }
}

