/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.HashSet;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IHeatTransfer;
import mekanism.api.MekanismAPI;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmitterNetworkRegistry;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.item.ItemEnergized;
import mekanism.common.util.CapabilityUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemNetworkReader
extends ItemEnergized {
    public static double ENERGY_PER_USE = 400.0;

    public ItemNetworkReader() {
        super(60000.0);
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            boolean drain;
            TileEntity tileEntity = world.func_175625_s(pos);
            boolean bl = drain = !player.field_71075_bZ.field_75098_d;
            if (this.getEnergy(stack) >= ENERGY_PER_USE && tileEntity != null) {
                if (CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d())) {
                    if (drain) {
                        this.setEnergy(stack, this.getEnergy(stack) - ENERGY_PER_USE);
                    }
                    IGridTransmitter transmitter = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d());
                    player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[Mekanica]" + (Object)((Object)EnumColor.GREY) + " -------------"));
                    player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + " *Transmitters: " + (Object)((Object)EnumColor.DARK_GREY) + transmitter.getTransmitterNetworkSize()));
                    player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + " *Acceptors: " + (Object)((Object)EnumColor.DARK_GREY) + transmitter.getTransmitterNetworkAcceptorSize()));
                    player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + " *Needed: " + (Object)((Object)EnumColor.DARK_GREY) + transmitter.getTransmitterNetworkNeeded()));
                    player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + " *Buffer: " + (Object)((Object)EnumColor.DARK_GREY) + transmitter.getTransmitterNetworkBuffer()));
                    player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + " *Throughput: " + (Object)((Object)EnumColor.DARK_GREY) + transmitter.getTransmitterNetworkFlow()));
                    player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + " *Capacity: " + (Object)((Object)EnumColor.DARK_GREY) + transmitter.getTransmitterNetworkCapacity()));
                    if (CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d())) {
                        IHeatTransfer transfer = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d());
                        player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + " *Temperature: " + (Object)((Object)EnumColor.DARK_GREY) + transfer.getTemp() + "K above ambient"));
                    }
                    player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[=======]" + (Object)((Object)EnumColor.GREY) + " -------------"));
                    return EnumActionResult.SUCCESS;
                }
                if (CapabilityUtils.hasCapability((ICapabilityProvider)tileEntity, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d())) {
                    if (drain) {
                        this.setEnergy(stack, this.getEnergy(stack) - ENERGY_PER_USE);
                    }
                    IHeatTransfer transfer = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d());
                    player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[Mekanica]" + (Object)((Object)EnumColor.GREY) + " -------------"));
                    player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + " *Temperature: " + (Object)((Object)EnumColor.DARK_GREY) + transfer.getTemp() + "K above ambient"));
                    player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[=======]" + (Object)((Object)EnumColor.GREY) + " -------------"));
                    return EnumActionResult.SUCCESS;
                }
                if (drain) {
                    this.setEnergy(stack, this.getEnergy(stack) - ENERGY_PER_USE);
                }
                HashSet iteratedNetworks = new HashSet();
                for (EnumFacing iterSide : EnumFacing.field_82609_l) {
                    Coord4D coord = Coord4D.get(tileEntity).offset(iterSide);
                    TileEntity tile = coord.getTileEntity((IBlockAccess)world);
                    if (!CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, iterSide.func_176734_d())) continue;
                    IGridTransmitter transmitter = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, iterSide.func_176734_d());
                    if (!((DynamicNetwork)transmitter.getTransmitterNetwork()).possibleAcceptors.containsKey(coord.offset(iterSide.func_176734_d())) || iteratedNetworks.contains(transmitter.getTransmitterNetwork())) continue;
                    player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[" + transmitter.getTransmissionType().getName() + "]" + (Object)((Object)EnumColor.GREY) + " -------------"));
                    player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + " *Connected sides: " + (Object)((Object)EnumColor.DARK_GREY) + ((DynamicNetwork)transmitter.getTransmitterNetwork()).acceptorDirections.get(coord.offset(iterSide.func_176734_d()))));
                    player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[=======]" + (Object)((Object)EnumColor.GREY) + " -------------"));
                    iteratedNetworks.add(transmitter.getTransmitterNetwork());
                }
                return EnumActionResult.SUCCESS;
            }
            if (player.func_70093_af() && MekanismAPI.debug) {
                String[] strings = TransmitterNetworkRegistry.getInstance().toStrings();
                player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + "---------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[Mekanica Debug]" + (Object)((Object)EnumColor.GREY) + " ----------"));
                for (String s : strings) {
                    player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_GREY) + s));
                }
                player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[=======]" + (Object)((Object)EnumColor.GREY) + " -------------"));
            }
        }
        return EnumActionResult.PASS;
    }

    @Override
    public boolean canSend(ItemStack itemstack) {
        return false;
    }
}

