/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.MekanismClient;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.frequency.Frequency;
import mekanism.common.item.ItemEnergized;
import mekanism.common.network.PacketSecurityUpdate;
import mekanism.common.security.IOwnerItem;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPortableTeleporter
extends ItemEnergized
implements IOwnerItem {
    public ItemPortableTeleporter() {
        super(1000000.0);
    }

    public static double calculateEnergyCost(Entity entity, Coord4D coords) {
        if (coords == null) {
            return 0.0;
        }
        int neededEnergy = MekanismConfig.usage.teleporterBaseUsage;
        if (entity.field_70170_p.field_73011_w.getDimension() != coords.dimensionId) {
            neededEnergy += MekanismConfig.usage.teleporterDimensionPenalty;
        }
        int distance = (int)entity.func_70011_f((double)coords.x, (double)coords.y, (double)coords.z);
        return neededEnergy += distance * MekanismConfig.usage.teleporterDistanceUsage;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
        list.add(SecurityUtils.getOwnerDisplay((EntityPlayer)Minecraft.func_71410_x().field_71439_g, MekanismClient.clientUUIDMap.get(this.getOwnerUUID(itemstack))));
        if (this.getFrequency(itemstack) != null) {
            list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("gui.frequency") + ": " + (Object)((Object)EnumColor.GREY) + this.getFrequency((ItemStack)itemstack).name);
            list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("gui.mode") + ": " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("gui." + (!this.getFrequency((ItemStack)itemstack).publicFreq ? "private" : "public")));
        }
        super.func_77624_a(itemstack, world, list, flag);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entityplayer, @Nonnull EnumHand hand) {
        ItemStack itemstack = entityplayer.func_184586_b(hand);
        if (!world.field_72995_K) {
            if (this.getOwnerUUID(itemstack) == null) {
                this.setOwnerUUID(itemstack, entityplayer.func_110124_au());
                Mekanism.packetHandler.sendToAll(new PacketSecurityUpdate.SecurityUpdateMessage(PacketSecurityUpdate.SecurityPacket.UPDATE, entityplayer.func_110124_au(), null));
                entityplayer.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanica]" + " " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("gui.nowOwn")));
            } else if (SecurityUtils.canAccess(entityplayer, itemstack)) {
                entityplayer.openGui((Object)Mekanism.instance, 14, world, hand.ordinal(), 0, 0);
            } else {
                SecurityUtils.displayNoAccess(entityplayer);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }

    @Override
    public UUID getOwnerUUID(ItemStack stack) {
        if (ItemDataUtils.hasData(stack, "ownerUUID")) {
            return UUID.fromString(ItemDataUtils.getString(stack, "ownerUUID"));
        }
        return null;
    }

    @Override
    public void setOwnerUUID(ItemStack stack, UUID owner) {
        this.setFrequency(stack, null);
        if (owner == null) {
            ItemDataUtils.removeData(stack, "ownerUUID");
            return;
        }
        ItemDataUtils.setString(stack, "ownerUUID", owner.toString());
    }

    @Override
    public boolean hasOwner(ItemStack stack) {
        return true;
    }

    public Frequency.Identity getFrequency(ItemStack stack) {
        if (ItemDataUtils.hasData(stack, "frequency")) {
            return Frequency.Identity.load(ItemDataUtils.getCompound(stack, "frequency"));
        }
        return null;
    }

    public void setFrequency(ItemStack stack, Frequency frequency) {
        if (frequency == null) {
            ItemDataUtils.removeData(stack, "frequency");
            return;
        }
        ItemDataUtils.setCompound(stack, "frequency", frequency.getIdentity().serialize());
    }
}

