/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe;

import javax.annotation.Nonnull;
import mekanism.common.MekanismItems;
import mekanism.common.Tier;
import mekanism.common.block.states.BlockStateBasic;
import mekanism.common.inventory.InventoryBin;
import mekanism.common.item.ItemProxy;
import mekanism.common.util.ItemDataUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BinRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private static boolean registered;

    public BinRecipe() {
        if (!registered) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            registered = true;
        }
        this.setRegistryName("bin");
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        return !this.func_77572_b(inv).func_190926_b();
    }

    private boolean isBin(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        return BlockStateBasic.BasicBlockType.get(itemStack) == BlockStateBasic.BasicBlockType.BIN && itemStack.func_190916_E() <= 1;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        return this.getResult((IInventory)inv);
    }

    public ItemStack getResult(IInventory inv) {
        ItemStack bin = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!this.isBin(stack)) continue;
            if (!bin.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            bin = stack.func_77946_l();
        }
        if (bin.func_190926_b() || bin.func_190916_E() > 1) {
            return ItemStack.field_190927_a;
        }
        ItemStack addStack = ItemStack.field_190927_a;
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || this.isBin(stack)) continue;
            if (!addStack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            addStack = stack.func_77946_l();
        }
        InventoryBin binInv = new InventoryBin(bin);
        if (!addStack.func_190926_b()) {
            if (!(addStack.func_77973_b() instanceof ItemProxy)) {
                if (!binInv.getItemType().func_190926_b() && !binInv.getItemType().func_77969_a(addStack)) {
                    return ItemStack.field_190927_a;
                }
                binInv.add(addStack);
            }
            return bin;
        }
        return binInv.removeStack();
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (!this.getResult(event.craftMatrix).func_190926_b()) {
            if (!this.isBin(event.crafting)) {
                for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
                    if (!this.isBin(event.craftMatrix.func_70301_a(i))) continue;
                    ItemStack bin = event.craftMatrix.func_70301_a(i);
                    InventoryBin inv = new InventoryBin(bin.func_77946_l());
                    int size = inv.getItemCount();
                    ItemStack testRemove = inv.removeStack();
                    int newCount = size - (!testRemove.func_190926_b() ? testRemove.func_190916_E() : 0);
                    if (inv.getTier() == Tier.BinTier.CREATIVE) {
                        newCount = size;
                    }
                    ItemDataUtils.setInt(bin, "newCount", newCount);
                }
            } else {
                int bin = -1;
                int other = -1;
                for (int i = 0; i < event.craftMatrix.func_70302_i_(); ++i) {
                    if (this.isBin(event.craftMatrix.func_70301_a(i))) {
                        bin = i;
                        continue;
                    }
                    if (this.isBin(event.craftMatrix.func_70301_a(i)) || event.craftMatrix.func_70301_a(i).func_190926_b()) continue;
                    other = i;
                }
                ItemStack binStack = event.craftMatrix.func_70301_a(bin);
                ItemStack otherStack = event.craftMatrix.func_70301_a(other);
                ItemStack testRemain = new InventoryBin(binStack.func_77946_l()).add(otherStack.func_77946_l());
                if (!testRemain.func_190926_b() && testRemain.func_190916_E() > 0) {
                    ItemStack proxy = new ItemStack(MekanismItems.ItemProxy);
                    ((ItemProxy)proxy.func_77973_b()).setSavedItem(proxy, testRemain.func_77946_l());
                    event.craftMatrix.func_70299_a(other, proxy);
                } else {
                    event.craftMatrix.func_70299_a(other, ItemStack.field_190927_a);
                }
            }
        }
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 1;
    }
}

