/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.common.Mekanism;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.RecipeUtils;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ShapedMekanismRecipe
extends ShapedOreRecipe {
    public ShapedMekanismRecipe(ResourceLocation group, Block result, Object ... recipe) {
        this(group, new ItemStack(result), recipe);
    }

    public ShapedMekanismRecipe(ResourceLocation group, Item result, Object ... recipe) {
        this(group, new ItemStack(result), recipe);
    }

    public ShapedMekanismRecipe(ResourceLocation group, @Nonnull ItemStack result, Object ... recipe) {
        this(group, result, CraftingHelper.parseShaped((Object[])recipe));
    }

    public ShapedMekanismRecipe(ResourceLocation group, @Nonnull ItemStack result, CraftingHelper.ShapedPrimer primer) {
        super(group, result, primer);
    }

    public static ShapedMekanismRecipe create(NBTTagCompound nbtTags) {
        if (!nbtTags.func_74764_b("result") || !nbtTags.func_74764_b("input")) {
            Mekanism.logger.error("[Mekanica] Shaped recipe parse error: missing input or result compound tag.");
            return null;
        }
        ItemStack result = InventoryUtils.loadFromNBT(nbtTags.func_74775_l("result"));
        NBTTagList list = nbtTags.func_150295_c("input", 10);
        if (result.func_190926_b() || list.func_74745_c() == 0) {
            Mekanism.logger.error("[Mekanica] Shaped recipe parse error: invalid result stack or input data list.");
            return null;
        }
        Object[] ret = new Object[list.func_74745_c()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            if (compound.func_74764_b("oredict")) {
                ret[i] = compound.func_74779_i("oredict");
                continue;
            }
            if (compound.func_74764_b("pattern")) {
                ret[i] = compound.func_74779_i("pattern");
                continue;
            }
            if (compound.func_74764_b("character")) {
                String s = compound.func_74779_i("character");
                if (s.length() > 1) {
                    Mekanism.logger.error("[Mekanica] Shaped recipe parse error: invalid pattern character data.");
                    return null;
                }
                ret[i] = Character.valueOf(compound.func_74779_i("character").toCharArray()[0]);
                continue;
            }
            if (compound.func_74764_b("itemstack")) {
                ret[i] = InventoryUtils.loadFromNBT(compound.func_74775_l("itemstack"));
                continue;
            }
            Mekanism.logger.error("[Mekanica] Shaped recipe parse error: invalid input tag data key.");
            return null;
        }
        return new ShapedMekanismRecipe(null, result, ret);
    }

    public static ShapedOreRecipe factory(JsonContext context, JsonObject json) {
        String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        HashMap ingMap = Maps.newHashMap();
        for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)json, (String)"key").entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            ingMap.put(Character.valueOf(((String)entry.getKey()).toCharArray()[0]), CraftingHelper.getIngredient((JsonElement)((JsonElement)entry.getValue()), (JsonContext)context));
        }
        ingMap.put(Character.valueOf(' '), Ingredient.field_193370_a);
        JsonArray patternJ = JsonUtils.func_151214_t((JsonObject)json, (String)"pattern");
        if (patternJ.size() == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        String[] pattern = new String[patternJ.size()];
        for (int x = 0; x < pattern.length; ++x) {
            String line = JsonUtils.func_151206_a((JsonElement)patternJ.get(x), (String)("pattern[" + x + "]"));
            if (x > 0 && pattern[0].length() != line.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must  be the same width");
            }
            pattern[x] = line;
        }
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.width = pattern[0].length();
        primer.height = pattern.length;
        primer.mirrored = JsonUtils.func_151209_a((JsonObject)json, (String)"mirrored", (boolean)true);
        primer.input = NonNullList.func_191197_a((int)(primer.width * primer.height), (Object)Ingredient.field_193370_a);
        HashSet keys = Sets.newHashSet(ingMap.keySet());
        keys.remove(Character.valueOf(' '));
        int x = 0;
        for (String line : pattern) {
            for (char chr : line.toCharArray()) {
                Ingredient ing = (Ingredient)ingMap.get(Character.valueOf(chr));
                if (ing == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                }
                primer.input.set(x++, (Object)ing);
                keys.remove(Character.valueOf(chr));
            }
        }
        if (!keys.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keys);
        }
        ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
        return new ShapedMekanismRecipe(group.isEmpty() ? null : new ResourceLocation(group), result, primer);
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        return RecipeUtils.getCraftingResult(inv, this.output.func_77946_l());
    }

    public static class RecipeFactory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            return ShapedMekanismRecipe.factory(context, json);
        }
    }
}

