/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.IntegerInput;
import mekanism.common.recipe.machines.AmbientGasRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.TileUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityAmbientAccumulator
extends TileEntityContainerBlock
implements IGasHandler,
ITubeConnection {
    public static Random gasRand = new Random();
    public GasTank collectedGas = new GasTank(1000);
    public int cachedDimensionId = 0;
    public AmbientGasRecipe cachedRecipe;

    public TileEntityAmbientAccumulator() {
        super("AmbientAccumulator");
        this.inventory = NonNullList.func_191197_a((int)0, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.cachedRecipe == null || this.field_145850_b.field_73011_w.getDimension() != this.cachedDimensionId) {
                this.cachedDimensionId = this.field_145850_b.field_73011_w.getDimension();
                this.cachedRecipe = RecipeHandler.getDimensionGas(new IntegerInput(this.cachedDimensionId));
            }
            if (this.cachedRecipe != null && gasRand.nextDouble() < 0.05 && ((GasOutput)this.cachedRecipe.getOutput()).applyOutputs(this.collectedGas, false, 1)) {
                ((GasOutput)this.cachedRecipe.getOutput()).applyOutputs(this.collectedGas, true, 1);
            }
        }
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return this.collectedGas.draw(amount, doTransfer);
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return false;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        return type == this.collectedGas.getGasType();
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.collectedGas};
    }

    @Override
    public boolean canTubeConnect(EnumFacing side) {
        return true;
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        TileUtils.addTankData(data, this.collectedGas);
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf data) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            TileUtils.readTankData(data, this.collectedGas);
        }
    }
}

