/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.base.ITileNetwork;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.network.PacketDataRequest;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;

public class TileEntityBoundingBlock
extends TileEntity
implements ITileNetwork {
    public BlockPos mainPos = BlockPos.field_177992_a;
    public boolean receivedCoords;
    public int prevPower;

    public void setMainLocation(BlockPos pos) {
        this.receivedCoords = true;
        if (!this.field_145850_b.field_72995_K) {
            this.mainPos = pos;
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new TileNetworkList())), new Range4D(Coord4D.get(this)));
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K) {
            Mekanism.packetHandler.sendToServer(new PacketDataRequest.DataRequestMessage(Coord4D.get(this)));
        }
    }

    public void onNeighborChange(Block block) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.mainPos);
        if (tile instanceof TileEntityBasicBlock) {
            TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)tile;
            int power = this.field_145850_b.func_175687_A(this.func_174877_v());
            if (this.prevPower != power) {
                if (power > 0) {
                    this.onPower();
                } else {
                    this.onNoPower();
                }
                this.prevPower = power;
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), tileEntity.getNetworkedData(new TileNetworkList())), new Range4D(Coord4D.get(this)));
            }
        }
    }

    public void onPower() {
    }

    public void onNoPower() {
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (this.field_145850_b.field_72995_K) {
            this.mainPos = new BlockPos(dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
            this.prevPower = dataStream.readInt();
        }
    }

    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.mainPos = new BlockPos(nbtTags.func_74762_e("mainX"), nbtTags.func_74762_e("mainY"), nbtTags.func_74762_e("mainZ"));
        this.prevPower = nbtTags.func_74762_e("prevPower");
        this.receivedCoords = nbtTags.func_74767_n("receivedCoords");
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("mainX", this.mainPos.func_177958_n());
        nbtTags.func_74768_a("mainY", this.mainPos.func_177956_o());
        nbtTags.func_74768_a("mainZ", this.mainPos.func_177952_p());
        nbtTags.func_74768_a("prevPower", this.prevPower);
        nbtTags.func_74757_a("receivedCoords", this.receivedCoords);
        return nbtTags;
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        data.add(this.mainPos.func_177958_n());
        data.add(this.mainPos.func_177956_o());
        data.add(this.mainPos.func_177952_p());
        data.add(this.prevPower);
        return data;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == Capabilities.TILE_NETWORK_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == Capabilities.TILE_NETWORK_CAPABILITY) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }
}

