/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.base.IFluidContainerManager;
import mekanism.common.block.BlockBasic;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.content.tank.TankCache;
import mekanism.common.content.tank.TankUpdateProtocol;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.TileUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityDynamicTank
extends TileEntityMultiblock<SynchronizedTankData>
implements IFluidContainerManager {
    public Set<SynchronizedTankData.ValveData> valveViewing = new HashSet<SynchronizedTankData.ValveData>();
    public int clientCapacity;
    public float prevScale;

    public TileEntityDynamicTank() {
        super("DynamicTank");
    }

    public TileEntityDynamicTank(String name) {
        super(name);
        this.inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K) {
            float targetScale;
            if (this.structure != null && this.clientHasStructure && this.isRendering && (double)Math.abs(this.prevScale - (targetScale = (float)(((SynchronizedTankData)this.structure).fluidStored != null ? ((SynchronizedTankData)this.structure).fluidStored.amount : 0) / (float)this.clientCapacity)) > 0.01) {
                this.prevScale = (9.0f * this.prevScale + targetScale) / 10.0f;
            }
            if (!this.clientHasStructure || !this.isRendering) {
                for (SynchronizedTankData.ValveData data : this.valveViewing) {
                    TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)data.location.getTileEntity((IBlockAccess)this.field_145850_b);
                    if (tileEntity == null) continue;
                    tileEntity.clientHasStructure = false;
                }
                this.valveViewing.clear();
            }
        }
        if (!this.field_145850_b.field_72995_K && this.structure != null) {
            if (((SynchronizedTankData)this.structure).fluidStored != null && ((SynchronizedTankData)this.structure).fluidStored.amount <= 0) {
                ((SynchronizedTankData)this.structure).fluidStored = null;
                this.func_70296_d();
            }
            if (this.isRendering) {
                boolean needsValveUpdate = false;
                for (SynchronizedTankData.ValveData data : ((SynchronizedTankData)this.structure).valves) {
                    if (data.activeTicks > 0) {
                        --data.activeTicks;
                    }
                    if (data.activeTicks > 0 != data.prevActive) {
                        needsValveUpdate = true;
                    }
                    data.prevActive = data.activeTicks > 0;
                }
                if (needsValveUpdate || ((SynchronizedTankData)this.structure).needsRenderUpdate()) {
                    this.sendPacketToRenderer();
                }
                ((SynchronizedTankData)this.structure).prevFluid = ((SynchronizedTankData)this.structure).fluidStored != null ? ((SynchronizedTankData)this.structure).fluidStored.copy() : null;
                this.manageInventory();
            }
        }
    }

    public void manageInventory() {
        int needed = ((SynchronizedTankData)this.structure).volume * 64000 - (((SynchronizedTankData)this.structure).fluidStored != null ? ((SynchronizedTankData)this.structure).fluidStored.amount : 0);
        if (FluidContainerUtils.isFluidContainer((ItemStack)((SynchronizedTankData)this.structure).inventory.get(0))) {
            ((SynchronizedTankData)this.structure).fluidStored = FluidContainerUtils.handleContainerItem(this, ((SynchronizedTankData)this.structure).inventory, ((SynchronizedTankData)this.structure).editMode, ((SynchronizedTankData)this.structure).fluidStored, needed, 0, 1, null);
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new TileNetworkList())), new Range4D(Coord4D.get(this)));
        }
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (!player.func_70093_af() && this.structure != null) {
            if (!BlockBasic.manageInventory(player, this, hand, stack)) {
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new TileNetworkList())), new Range4D(Coord4D.get(this)));
                player.openGui((Object)Mekanism.instance, 18, this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            } else {
                player.field_71071_by.func_70296_d();
                this.sendPacketToRenderer();
            }
            return true;
        }
        return false;
    }

    @Override
    protected SynchronizedTankData getNewStructure() {
        return new SynchronizedTankData();
    }

    public TankCache getNewCache() {
        return new TankCache();
    }

    protected TankUpdateProtocol getProtocol() {
        return new TankUpdateProtocol(this);
    }

    @Override
    public MultiblockManager<SynchronizedTankData> getManager() {
        return Mekanism.tankManager;
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        if (this.structure != null) {
            data.add(((SynchronizedTankData)this.structure).volume * 64000);
            data.add(((SynchronizedTankData)this.structure).editMode.ordinal());
            TileUtils.addFluidStack(data, ((SynchronizedTankData)this.structure).fluidStored);
            if (this.isRendering) {
                HashSet<SynchronizedTankData.ValveData> toSend = new HashSet<SynchronizedTankData.ValveData>();
                for (SynchronizedTankData.ValveData valveData : ((SynchronizedTankData)this.structure).valves) {
                    if (valveData.activeTicks <= 0) continue;
                    toSend.add(valveData);
                }
                data.add(toSend.size());
                for (SynchronizedTankData.ValveData valveData : toSend) {
                    valveData.location.write(data);
                    data.add(valveData.side);
                }
            }
        }
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() && this.clientHasStructure) {
            this.clientCapacity = dataStream.readInt();
            ((SynchronizedTankData)this.structure).editMode = FluidContainerUtils.ContainerEditMode.values()[dataStream.readInt()];
            ((SynchronizedTankData)this.structure).fluidStored = TileUtils.readFluidStack(dataStream);
            if (this.isRendering) {
                int size = dataStream.readInt();
                this.valveViewing.clear();
                for (int i = 0; i < size; ++i) {
                    SynchronizedTankData.ValveData data = new SynchronizedTankData.ValveData();
                    data.location = Coord4D.read(dataStream);
                    data.side = EnumFacing.func_82600_a((int)dataStream.readInt());
                    this.valveViewing.add(data);
                    TileEntityDynamicTank tileEntity = (TileEntityDynamicTank)data.location.getTileEntity((IBlockAccess)this.field_145850_b);
                    if (tileEntity == null) continue;
                    tileEntity.clientHasStructure = true;
                }
            }
        }
    }

    public int getScaledFluidLevel(long i) {
        if (this.clientCapacity == 0 || ((SynchronizedTankData)this.structure).fluidStored == null) {
            return 0;
        }
        return (int)((long)((SynchronizedTankData)this.structure).fluidStored.amount * i / (long)this.clientCapacity);
    }

    @Override
    public FluidContainerUtils.ContainerEditMode getContainerEditMode() {
        if (this.structure != null) {
            return ((SynchronizedTankData)this.structure).editMode;
        }
        return FluidContainerUtils.ContainerEditMode.BOTH;
    }

    @Override
    public void setContainerEditMode(FluidContainerUtils.ContainerEditMode mode) {
        if (this.structure == null) {
            return;
        }
        ((SynchronizedTankData)this.structure).editMode = mode;
    }
}

