/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.content.tank.DynamicFluidTank;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.tile.TileEntityDynamicTank;
import mekanism.common.util.LangUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileEntityDynamicValve
extends TileEntityDynamicTank
implements IFluidHandlerWrapper {
    public DynamicFluidTank fluidTank = new DynamicFluidTank(this);

    public TileEntityDynamicValve() {
        super("Dynamic Valve");
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        FluidTankInfo[] fluidTankInfoArray;
        if (!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) {
            FluidTankInfo[] fluidTankInfoArray2 = new FluidTankInfo[1];
            fluidTankInfoArray = fluidTankInfoArray2;
            fluidTankInfoArray2[0] = this.fluidTank.getInfo();
        } else {
            fluidTankInfoArray = PipeUtils.EMPTY;
        }
        return fluidTankInfoArray;
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return this.getTankInfo(null);
    }

    @Override
    public int fill(EnumFacing from, @Nullable FluidStack resource, boolean doFill) {
        return this.fluidTank.fill(resource, doFill);
    }

    @Override
    public FluidStack drain(EnumFacing from, @Nullable FluidStack resource, boolean doDrain) {
        if (this.structure != null && ((SynchronizedTankData)this.structure).fluidStored != null && resource != null && resource.getFluid() == ((SynchronizedTankData)this.structure).fluidStored.getFluid()) {
            return this.fluidTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    @Override
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (this.structure != null) {
            return this.fluidTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public boolean canFill(EnumFacing from, @Nullable FluidStack fluid) {
        return !this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure;
    }

    @Override
    public boolean canDrain(EnumFacing from, @Nullable FluidStack fluid) {
        return !this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure;
    }

    @Override
    @Nonnull
    public String func_70005_c_() {
        return LangUtils.localize("gui.dynamicTank");
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if ((!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if ((!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper(this, side);
        }
        return super.getCapability(capability, side);
    }
}

