/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.IConfigurable;
import mekanism.api.TileNetworkList;
import mekanism.common.MekanismFluids;
import mekanism.common.Upgrade;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedTank;
import mekanism.common.base.ITankManager;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.prefab.TileEntityElectricBlock;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.TileUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityElectricPump
extends TileEntityElectricBlock
implements IFluidHandlerWrapper,
ISustainedTank,
IConfigurable,
IRedstoneControl,
IUpgradeTile,
ITankManager,
IComputerIntegration,
ISecurityTile {
    private static final String[] methods = new String[]{"reset"};
    public FluidTank fluidTank = new FluidTank(10000);
    public Fluid activeType;
    public boolean suckedLastOperation;
    public double BASE_ENERGY_PER_TICK;
    public double energyPerTick = this.BASE_ENERGY_PER_TICK = MekanismConfig.usage.electricPumpUsage;
    public int BASE_TICKS_REQUIRED;
    public int ticksRequired = this.BASE_TICKS_REQUIRED = 20;
    public int operatingTicks;
    public Set<Coord4D> recurringNodes = new HashSet<Coord4D>();
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public TileComponentUpgrade upgradeComponent = new TileComponentUpgrade(this, 3);
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);

    public TileEntityElectricPump() {
        super("ElectricPump", 10000.0);
        this.inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        this.upgradeComponent.setSupported(Upgrade.FILTER);
    }

    @Override
    public void onUpdate() {
        TileEntity tileEntity;
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.discharge(2, this);
            if (this.fluidTank.getFluid() != null && FluidContainerUtils.isFluidContainer((ItemStack)this.inventory.get(0))) {
                FluidContainerUtils.handleContainerItemFill(this, this.fluidTank, 0, 1);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (MekanismUtils.canFunction(this) && this.getEnergy() >= this.energyPerTick) {
                if (this.suckedLastOperation) {
                    this.setEnergy(this.getEnergy() - this.energyPerTick);
                }
                if (this.operatingTicks + 1 < this.ticksRequired) {
                    ++this.operatingTicks;
                } else {
                    if (this.fluidTank.getFluid() == null || this.fluidTank.getFluid().amount + 1000 <= this.fluidTank.getCapacity()) {
                        if (!this.suck(true)) {
                            this.suckedLastOperation = false;
                            this.reset();
                        } else {
                            this.suckedLastOperation = true;
                        }
                    } else {
                        this.suckedLastOperation = false;
                    }
                    this.operatingTicks = 0;
                }
            } else {
                this.suckedLastOperation = false;
            }
        }
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K && this.fluidTank.getFluid() != null && CapabilityUtils.hasCapability((ICapabilityProvider)(tileEntity = Coord4D.get(this).offset(EnumFacing.UP).getTileEntity((IBlockAccess)this.field_145850_b)), CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN)) {
            IFluidHandler handler = (IFluidHandler)CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN);
            FluidStack toDrain = new FluidStack(this.fluidTank.getFluid(), Math.min(256 * (this.upgradeComponent.getUpgrades(Upgrade.SPEED) + 1), this.fluidTank.getFluidAmount()));
            this.fluidTank.drain(handler.fill(toDrain, true), true);
        }
    }

    public boolean hasFilter() {
        return this.upgradeComponent.getInstalledTypes().contains((Object)Upgrade.FILTER);
    }

    public boolean suck(boolean take) {
        List<Coord4D> tempPumpList = Arrays.asList(this.recurringNodes.toArray(new Coord4D[0]));
        Collections.shuffle(tempPumpList);
        for (EnumFacing orientation : EnumFacing.field_82609_l) {
            Coord4D wrapper = Coord4D.get(this).offset(orientation);
            FluidStack fluid = MekanismUtils.getFluid(this.field_145850_b, wrapper, this.hasFilter());
            if (fluid == null || this.activeType != null && fluid.getFluid() != this.activeType || this.fluidTank.getFluid() != null && !this.fluidTank.getFluid().isFluidEqual(fluid)) continue;
            if (take) {
                this.activeType = fluid.getFluid();
                this.recurringNodes.add(wrapper);
                this.fluidTank.fill(fluid, true);
                if (this.shouldTake(fluid, wrapper)) {
                    this.field_145850_b.func_175698_g(wrapper.getPos());
                }
            }
            return true;
        }
        for (Coord4D wrapper : tempPumpList) {
            FluidStack fluid = MekanismUtils.getFluid(this.field_145850_b, wrapper, this.hasFilter());
            if (!(fluid == null || this.activeType != null && fluid.getFluid() != this.activeType || this.fluidTank.getFluid() != null && !this.fluidTank.getFluid().isFluidEqual(fluid))) {
                if (take) {
                    this.activeType = fluid.getFluid();
                    this.fluidTank.fill(fluid, true);
                    if (this.shouldTake(fluid, wrapper)) {
                        this.field_145850_b.func_175698_g(wrapper.getPos());
                    }
                }
                return true;
            }
            for (EnumFacing orientation : EnumFacing.field_82609_l) {
                Coord4D side = wrapper.offset(orientation);
                if (Coord4D.get(this).distanceTo(side) > MekanismConfig.general.maxPumpRange || (fluid = MekanismUtils.getFluid(this.field_145850_b, side, this.hasFilter())) == null || this.activeType != null && fluid.getFluid() != this.activeType || this.fluidTank.getFluid() != null && !this.fluidTank.getFluid().isFluidEqual(fluid)) continue;
                if (take) {
                    this.activeType = fluid.getFluid();
                    this.recurringNodes.add(side);
                    this.fluidTank.fill(fluid, true);
                    if (this.shouldTake(fluid, side)) {
                        this.field_145850_b.func_175698_g(side.getPos());
                    }
                }
                return true;
            }
            this.recurringNodes.remove(wrapper);
        }
        return false;
    }

    public void reset() {
        this.activeType = null;
        this.recurringNodes.clear();
    }

    private boolean shouldTake(FluidStack fluid, Coord4D coord) {
        if (fluid.getFluid() == FluidRegistry.WATER || fluid.getFluid() == MekanismFluids.HeavyWater) {
            return MekanismConfig.general.pumpWaterSources;
        }
        return true;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            TileUtils.readTankData(dataStream, this.fluidTank);
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        TileUtils.addTankData(data, this.fluidTank);
        data.add(this.controlType.ordinal());
        return data;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        nbtTags.func_74757_a("suckedLastOperation", this.suckedLastOperation);
        if (this.activeType != null) {
            nbtTags.func_74778_a("activeType", FluidRegistry.getFluidName((Fluid)this.activeType));
        }
        if (this.fluidTank.getFluid() != null) {
            nbtTags.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        NBTTagList recurringList = new NBTTagList();
        for (Coord4D wrapper : this.recurringNodes) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            wrapper.write(tagCompound);
            recurringList.func_74742_a((NBTBase)tagCompound);
        }
        if (recurringList.func_74745_c() != 0) {
            nbtTags.func_74782_a("recurringNodes", (NBTBase)recurringList);
        }
        return nbtTags;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.suckedLastOperation = nbtTags.func_74767_n("suckedLastOperation");
        if (nbtTags.func_74764_b("activeType")) {
            this.activeType = FluidRegistry.getFluid((String)nbtTags.func_74779_i("activeType"));
        }
        if (nbtTags.func_74764_b("fluidTank")) {
            this.fluidTank.readFromNBT(nbtTags.func_74775_l("fluidTank"));
        }
        if (nbtTags.func_74764_b("controlType")) {
            this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        }
        if (nbtTags.func_74764_b("recurringNodes")) {
            NBTTagList tagList = nbtTags.func_150295_c("recurringNodes", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.recurringNodes.add(Coord4D.read(tagList.func_150305_b(i)));
            }
        }
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 1) {
            return false;
        }
        if (slotID == 0) {
            return FluidContainerUtils.isFluidContainer(itemstack) && FluidUtil.getFluidContained((ItemStack)itemstack) == null;
        }
        if (slotID == 2) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return true;
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 2) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 1;
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return this.facing.func_176734_d() == side;
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        if (side == EnumFacing.UP) {
            return new int[]{0};
        }
        if (side == EnumFacing.DOWN) {
            return new int[]{1};
        }
        return new int[]{2};
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing direction) {
        if (direction == EnumFacing.UP) {
            return new FluidTankInfo[]{this.fluidTank.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return this.getTankInfo(EnumFacing.UP);
    }

    @Override
    public void setFluidStack(FluidStack fluidStack, Object ... data) {
        this.fluidTank.setFluid(fluidStack);
    }

    @Override
    public FluidStack getFluidStack(Object ... data) {
        return this.fluidTank.getFluid();
    }

    @Override
    public boolean hasTank(Object ... data) {
        return true;
    }

    @Override
    public FluidStack drain(EnumFacing from, @Nullable FluidStack resource, boolean doDrain) {
        if (resource != null && this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() == resource.getFluid() && from == EnumFacing.func_82600_a((int)1)) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    @Override
    public int fill(EnumFacing from, @Nullable FluidStack resource, boolean doFill) {
        return 0;
    }

    @Override
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (from == EnumFacing.func_82600_a((int)1)) {
            return this.fluidTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public boolean canFill(EnumFacing from, @Nullable FluidStack fluid) {
        return false;
    }

    @Override
    public boolean canDrain(EnumFacing from, @Nullable FluidStack fluid) {
        return from == EnumFacing.func_82600_a((int)1);
    }

    @Override
    public EnumActionResult onSneakRightClick(EntityPlayer player, EnumFacing side) {
        this.reset();
        player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanica]" + " " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.configurator.pumpReset")));
        return EnumActionResult.SUCCESS;
    }

    @Override
    public EnumActionResult onRightClick(EntityPlayer player, EnumFacing side) {
        return EnumActionResult.PASS;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.CONFIGURABLE_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.CONFIGURABLE_CAPABILITY) {
            return (T)this;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper(this, side);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean canPulse() {
        return true;
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.fluidTank};
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        if (method == 0) {
            this.reset();
            return new Object[]{"Pump calculation reset."};
        }
        throw new NoSuchMethodException();
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case SPEED: {
                this.ticksRequired = MekanismUtils.getTicks(this, this.BASE_TICKS_REQUIRED);
            }
            case ENERGY: {
                this.energyPerTick = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK);
                this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
                this.setEnergy(Math.min(this.getMaxEnergy(), this.getEnergy()));
            }
        }
    }
}

