/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.base.ITileNetwork;
import mekanism.common.block.property.PropertyColor;
import mekanism.common.block.states.BlockStateFacing;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.multipart.MultipartTileNetworkJoiner;
import mekanism.common.network.PacketDataRequest;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class TileEntityGlowPanel
extends TileEntity
implements ITileNetwork {
    public EnumColor colour = EnumColor.WHITE;
    public EnumFacing side = EnumFacing.DOWN;

    public static int hash(IExtendedBlockState state) {
        int hash = 1;
        PropertyColor propColor = (PropertyColor)state.getValue((IUnlistedProperty)PropertyColor.INSTANCE);
        EnumColor color = propColor != null ? propColor.color : EnumColor.WHITE;
        hash = 31 * hash + color.ordinal();
        hash = 31 * hash + ((EnumFacing)state.func_177229_b((IProperty)BlockStateFacing.facingProperty)).ordinal();
        return hash;
    }

    public void setColour(EnumColor newColour) {
        this.colour = newColour;
    }

    public void setOrientation(EnumFacing newSide) {
        this.side = newSide;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        this.side = EnumFacing.func_82600_a((int)dataStream.readInt());
        this.colour = EnumColor.DYES[dataStream.readInt()];
        MekanismUtils.updateBlock(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        if (Mekanism.hooks.MCMPLoaded) {
            MultipartTileNetworkJoiner.addMultipartHeader(this, data, this.side);
        }
        data.add(this.side.ordinal());
        data.add(this.colour.getMetaValue());
        return data;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b.field_72995_K) {
            Mekanism.packetHandler.sendToServer(new PacketDataRequest.DataRequestMessage(Coord4D.get(this)));
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("side", this.side.ordinal());
        nbt.func_74768_a("colour", this.colour.getMetaValue());
        return nbt;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.side = EnumFacing.func_82600_a((int)nbt.func_74762_e("side"));
        this.colour = EnumColor.DYES[nbt.func_74762_e("colour")];
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return capability == Capabilities.TILE_NETWORK_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == Capabilities.TILE_NETWORK_CAPABILITY) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }
}

