/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.Map;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.config.MekanismConfig;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.machines.PurificationRecipe;
import mekanism.common.tile.prefab.TileEntityAdvancedElectricMachine;
import mekanism.common.util.GasUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class TileEntityPurificationChamber
extends TileEntityAdvancedElectricMachine<PurificationRecipe> {
    public TileEntityPurificationChamber() {
        super("purification", "PurificationChamber", BlockStateMachine.MachineType.PURIFICATION_CHAMBER.baseEnergy, MekanismConfig.usage.purificationChamberUsage, 200, 1);
    }

    @Override
    public Map<AdvancedMachineInput, PurificationRecipe> getRecipes() {
        return RecipeHandler.Recipe.PURIFICATION_CHAMBER.get();
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack.getGas())) {
            return this.gasTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return this.gasTank.canReceive(type) && this.isValidGas(type);
    }

    @Override
    public void handleSecondaryFuel() {
        GasStack gas;
        ItemStack itemStack = (ItemStack)this.inventory.get(1);
        if (!itemStack.func_190926_b() && this.gasTank.getNeeded() > 0 && itemStack.func_77973_b() instanceof IGasItem && (gas = ((IGasItem)itemStack.func_77973_b()).getGas(itemStack)) != null) {
            GasStack removed = GasUtils.removeGas(itemStack, gas.getGas(), this.gasTank.getNeeded());
            this.gasTank.receive(removed, true);
            return;
        }
        super.handleSecondaryFuel();
    }

    @Override
    public boolean canTubeConnect(EnumFacing side) {
        return true;
    }

    @Override
    public boolean isValidGas(Gas gas) {
        return RecipeHandler.Recipe.PURIFICATION_CHAMBER.containsRecipe(gas);
    }

    @Override
    public boolean upgradeableSecondaryEfficiency() {
        return true;
    }

    @Override
    public boolean useStatisticalMechanics() {
        return true;
    }
}

