/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.api.Range4D;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.prefab.TileEntityEffectsBlock;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityResistiveHeater
extends TileEntityEffectsBlock
implements IHeatTransfer,
IComputerIntegration,
IRedstoneControl,
ISecurityTile {
    private static final String[] methods = new String[]{"getEnergy", "getMaxEnergy", "getTemperature", "setEnergyUsage"};
    public double energyUsage = 100.0;
    public double temperature;
    public double heatToAbsorb = 0.0;
    public boolean isActive;
    public boolean clientActive;
    public int updateDelay;
    public float soundScale = 1.0f;
    public double lastEnvironmentLoss;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);

    public TileEntityResistiveHeater() {
        super("machine.resistiveheater", "ResistiveHeater", BlockStateMachine.MachineType.RESISTIVE_HEATER.baseEnergy);
        this.inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K && this.updateDelay > 0) {
            --this.updateDelay;
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            boolean packet = false;
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    packet = true;
                }
            }
            ChargeUtils.discharge(0, this);
            double toUse = 0.0;
            if (MekanismUtils.canFunction(this)) {
                toUse = Math.min(this.getEnergy(), this.energyUsage);
                this.heatToAbsorb += toUse / MekanismConfig.general.energyPerHeat;
                this.setEnergy(this.getEnergy() - toUse);
            }
            this.setActive(toUse > 0.0);
            double[] loss = this.simulateHeat();
            this.applyTemperatureChange();
            this.lastEnvironmentLoss = loss[1];
            float newSoundScale = (float)Math.max(0.0, toUse / 100000.0);
            if ((double)Math.abs(newSoundScale - this.soundScale) > 0.01) {
                packet = true;
            }
            this.soundScale = newSoundScale;
            if (packet) {
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new TileNetworkList())), new Range4D(Coord4D.get(this)));
            }
        }
    }

    @Override
    public boolean sideIsConsumer(EnumFacing side) {
        return side == MekanismUtils.getLeft(this.facing) || side == MekanismUtils.getRight(this.facing);
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public float getInitialVolume() {
        return super.getInitialVolume() * Math.max(0.001f, this.soundScale);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.energyUsage = nbtTags.func_74769_h("energyUsage");
        this.temperature = nbtTags.func_74769_h("temperature");
        this.clientActive = this.isActive = nbtTags.func_74767_n("isActive");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.maxEnergy = this.energyUsage * 400.0;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74780_a("energyUsage", this.energyUsage);
        nbtTags.func_74780_a("temperature", this.temperature);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        return nbtTags;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.energyUsage = MekanismUtils.convertToJoules(dataStream.readInt());
            this.maxEnergy = this.energyUsage * 400.0;
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.energyUsage = dataStream.readDouble();
            this.temperature = dataStream.readDouble();
            this.clientActive = dataStream.readBoolean();
            this.maxEnergy = dataStream.readDouble();
            this.soundScale = dataStream.readFloat();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            this.lastEnvironmentLoss = dataStream.readDouble();
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.updateDelay = MekanismConfig.general.UPDATE_DELAY;
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.energyUsage);
        data.add(this.temperature);
        data.add(this.isActive);
        data.add(this.maxEnergy);
        data.add(Float.valueOf(this.soundScale));
        data.add(this.controlType.ordinal());
        data.add(this.lastEnvironmentLoss);
        return data;
    }

    @Override
    public double getTemp() {
        return this.temperature;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return 5.0;
    }

    @Override
    public double getInsulationCoefficient(EnumFacing side) {
        return 1000.0;
    }

    @Override
    public void transferHeatTo(double heat) {
        this.heatToAbsorb += heat;
    }

    @Override
    public double[] simulateHeat() {
        return HeatUtils.simulate(this);
    }

    @Override
    public double applyTemperatureChange() {
        this.temperature += this.heatToAbsorb;
        this.heatToAbsorb = 0.0;
        return this.temperature;
    }

    @Override
    public boolean canConnectHeat(EnumFacing side) {
        return true;
    }

    @Override
    public IHeatTransfer getAdjacent(EnumFacing side) {
        TileEntity adj = Coord4D.get(this).offset(side).getTileEntity((IBlockAccess)this.field_145850_b);
        if (CapabilityUtils.hasCapability((ICapabilityProvider)adj, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d())) {
            return CapabilityUtils.getCapability((ICapabilityProvider)adj, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d());
        }
        return null;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.HEAT_TRANSFER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.HEAT_TRANSFER_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new TileNetworkList())), new Range4D(Coord4D.get(this)));
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 2: {
                return new Object[]{this.temperature};
            }
            case 3: {
                if (arguments.length == 1 && arguments[0] instanceof Double) {
                    this.energyUsage = (Double)arguments[0];
                    return new Object[]{"Set energy usage."};
                }
                return new Object[]{"Invalid parameters."};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }
}

