/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import javax.annotation.Nonnull;
import mekanism.api.EnumColor;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.MekanismItems;
import mekanism.common.SideData;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.BasicMachineRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityUpgradeableMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;

public abstract class TileEntityElectricMachine<RECIPE extends BasicMachineRecipe<RECIPE>>
extends TileEntityUpgradeableMachine<ItemStackInput, ItemStackOutput, RECIPE> {
    private static final String[] methods = new String[]{"getEnergy", "getProgress", "isActive", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};

    public TileEntityElectricMachine(String soundPath, String name, double maxEnergy, double perTick, int ticksRequired) {
        super(soundPath, name, maxEnergy, perTick, 3, ticksRequired, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiBasicMachine.png"));
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Input", EnumColor.DARK_RED, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Output", EnumColor.DARK_BLUE, new int[]{2}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Energy", EnumColor.DARK_GREEN, new int[]{1}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{3, 1, 0, 0, 0, 2});
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(2));
    }

    @Override
    protected void upgradeInventory(TileEntityFactory factory) {
        factory.inventory.set(5, this.inventory.get(0));
        factory.inventory.set(1, this.inventory.get(1));
        factory.inventory.set(8, this.inventory.get(2));
        factory.inventory.set(0, this.inventory.get(3));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.discharge(1, this);
            MachineRecipe recipe = this.getRecipe();
            if (this.canOperate((RECIPE)recipe) && MekanismUtils.canFunction(this) && this.getEnergy() >= this.energyPerTick) {
                this.setActive(true);
                this.electricityStored -= this.energyPerTick;
                if (this.operatingTicks + 1 < this.ticksRequired) {
                    ++this.operatingTicks;
                } else if (this.operatingTicks + 1 >= this.ticksRequired) {
                    this.operate((RECIPE)recipe);
                    this.operatingTicks = 0;
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (!this.canOperate((RECIPE)recipe)) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 2) {
            return false;
        }
        if (slotID == 3) {
            return itemstack.func_77973_b() == MekanismItems.SpeedUpgrade || itemstack.func_77973_b() == MekanismItems.EnergyUpgrade;
        }
        if (slotID == 0) {
            return RecipeHandler.isInRecipe(itemstack, this.getRecipes());
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public ItemStackInput getInput() {
        return new ItemStackInput((ItemStack)this.inventory.get(0));
    }

    @Override
    public RECIPE getRecipe() {
        ItemStackInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((ItemStackInput)((BasicMachineRecipe)this.cachedRecipe).getInput())) {
            this.cachedRecipe = RecipeHandler.getRecipe(input, this.getRecipes());
        }
        return (RECIPE)((BasicMachineRecipe)this.cachedRecipe);
    }

    @Override
    public void operate(RECIPE recipe) {
        ((BasicMachineRecipe)recipe).operate((NonNullList<ItemStack>)this.inventory, 0, 2);
        this.func_70296_d();
        this.ejectorComponent.outputItems();
    }

    @Override
    public boolean canOperate(RECIPE recipe) {
        return recipe != null && ((BasicMachineRecipe)recipe).canOperate((NonNullList<ItemStack>)this.inventory, 0, 2);
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 2;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.operatingTicks};
            }
            case 2: {
                return new Object[]{this.isActive};
            }
            case 3: {
                return new Object[]{this.facing};
            }
            case 4: {
                return new Object[]{this.canOperate((RECIPE)this.getRecipe())};
            }
            case 5: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 6: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
        }
        throw new NoSuchMethodException();
    }
}

