/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.Range4D;
import mekanism.api.TileNetworkList;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.Tier;
import mekanism.common.base.ILogisticalTransporter;
import mekanism.common.block.property.PropertyColor;
import mekanism.common.block.states.BlockStateTransmitter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransitRequest;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.integration.multipart.MultipartTileNetworkJoiner;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.transmitters.TransporterImpl;
import mekanism.common.transmitters.grid.InventoryNetwork;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TextComponentGroup;
import mekanism.common.util.TransporterUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityLogisticalTransporter
extends TileEntityTransmitter<TileEntity, InventoryNetwork> {
    public Tier.TransporterTier tier = Tier.TransporterTier.BASIC;
    public int pullDelay = 0;

    public TileEntityLogisticalTransporter() {
        this.transmitterDelegate = new TransporterImpl(this);
    }

    @Override
    public Tier.BaseTier getBaseTier() {
        return this.tier.getBaseTier();
    }

    @Override
    public void setBaseTier(Tier.BaseTier baseTier) {
        this.tier = Tier.TransporterTier.get(baseTier);
    }

    @Override
    public BlockStateTransmitter.TransmitterType getTransmitterType() {
        return BlockStateTransmitter.TransmitterType.LOGISTICAL_TRANSPORTER;
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.ITEM;
    }

    @Override
    public void onWorldSeparate() {
        super.onWorldSeparate();
        if (!this.func_145831_w().field_72995_K) {
            PathfinderCache.onChanged(new Coord4D(this.func_174877_v(), this.func_145831_w()));
        }
    }

    @Override
    public TileEntity getCachedAcceptor(EnumFacing side) {
        return this.getCachedTile(side);
    }

    @Override
    public boolean isValidTransmitter(TileEntity tileEntity) {
        ILogisticalTransporter transporter = CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY, null);
        if (this.getTransmitter().getColor() == null || transporter.getColor() == null || this.getTransmitter().getColor() == transporter.getColor()) {
            return super.isValidTransmitter(tileEntity);
        }
        return false;
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, EnumFacing side) {
        return TransporterUtils.isValidAcceptorOnSide(tile, side);
    }

    @Override
    public boolean handlesRedstone() {
        return false;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.getTransmitter().update();
    }

    public void pullItems() {
        if (this.pullDelay == 0) {
            boolean did = false;
            for (EnumFacing side : this.getConnections(TileEntitySidedPipe.ConnectionType.PULL)) {
                TransitRequest.TransitResponse response;
                TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(side));
                TransitRequest request = TransitRequest.getTopStacks(tile, side, this.tier.pullAmount);
                if (request.isEmpty() || (response = TransporterUtils.insert(tile, this.getTransmitter(), request, this.getTransmitter().getColor(), true, 0)).isEmpty()) continue;
                did = true;
                response.getInvStack(tile, side.func_176734_d()).use(response.stack.func_190916_E());
            }
            if (did) {
                this.pullDelay = 10;
            }
        } else {
            --this.pullDelay;
        }
    }

    @Override
    public void onWorldJoin() {
        super.onWorldJoin();
        PathfinderCache.onChanged(new Coord4D(this.func_174877_v(), this.func_145831_w()));
    }

    @Override
    public InventoryNetwork createNewNetwork() {
        return new InventoryNetwork();
    }

    @Override
    public InventoryNetwork createNetworkByMerging(Collection<InventoryNetwork> networks) {
        return new InventoryNetwork(networks);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) throws Exception {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            int type = dataStream.readInt();
            if (type == 0) {
                super.handlePacketData(dataStream);
                this.tier = Tier.TransporterTier.values()[dataStream.readInt()];
                int c = dataStream.readInt();
                EnumColor prev = this.getTransmitter().getColor();
                if (c != -1) {
                    this.getTransmitter().setColor(TransporterUtils.colors.get(c));
                } else {
                    this.getTransmitter().setColor(null);
                }
                if (prev != this.getTransmitter().getColor()) {
                    MekanismUtils.updateBlock(this.field_145850_b, this.field_174879_c);
                }
                this.getTransmitter().transit.clear();
                int amount = dataStream.readInt();
                for (int i = 0; i < amount; ++i) {
                    this.getTransmitter().transit.add(TransporterStack.readFromPacket(dataStream));
                }
            } else if (type == 1) {
                boolean kill = dataStream.readBoolean();
                int index = dataStream.readInt();
                if (kill) {
                    this.getTransmitter().transit.remove(index);
                } else {
                    TransporterStack stack = TransporterStack.readFromPacket(dataStream);
                    if (stack.progress == 0) {
                        stack.progress = 5;
                    }
                    this.getTransmitter().transit.replace(index, stack);
                }
            }
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        data.add(0);
        super.getNetworkedData(data);
        data.add(this.tier.ordinal());
        if (this.getTransmitter().getColor() != null) {
            data.add(TransporterUtils.colors.indexOf((Object)this.getTransmitter().getColor()));
        } else {
            data.add(-1);
        }
        data.add(this.getTransmitter().transit.size());
        for (TransporterStack stack : this.getTransmitter().transit) {
            stack.write(this.getTransmitter(), data);
        }
        return data;
    }

    public TileNetworkList getSyncPacket(TransporterStack stack, boolean kill) {
        TileNetworkList data = new TileNetworkList();
        if (Mekanism.hooks.MCMPLoaded) {
            MultipartTileNetworkJoiner.addMultipartHeader(this, data, null);
        }
        data.add(1);
        data.add(kill);
        data.add(this.getTransmitter().transit.indexOf(stack));
        if (!kill) {
            stack.write(this.getTransmitter(), data);
        }
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        if (nbtTags.func_74764_b("tier")) {
            this.tier = Tier.TransporterTier.values()[nbtTags.func_74762_e("tier")];
        }
        if (nbtTags.func_74764_b("color")) {
            this.getTransmitter().setColor(TransporterUtils.colors.get(nbtTags.func_74762_e("color")));
        }
        if (nbtTags.func_74764_b("stacks")) {
            NBTTagList tagList = nbtTags.func_150295_c("stacks", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                TransporterStack stack = TransporterStack.readFromNBT(tagList.func_150305_b(i));
                this.getTransmitter().transit.add(stack);
            }
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        if (this.getTransmitter().getColor() != null) {
            nbtTags.func_74768_a("color", TransporterUtils.colors.indexOf((Object)this.getTransmitter().getColor()));
        }
        NBTTagList stacks = new NBTTagList();
        for (TransporterStack stack : this.getTransmitter().transit) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            stack.write(tagCompound);
            stacks.func_74742_a((NBTBase)tagCompound);
        }
        if (stacks.func_74745_c() != 0) {
            nbtTags.func_74782_a("stacks", (NBTBase)stacks);
        }
        return nbtTags;
    }

    @Override
    protected EnumActionResult onConfigure(EntityPlayer player, int part, EnumFacing side) {
        TransporterUtils.incrementColor(this.getTransmitter());
        this.onPartChanged(null);
        PathfinderCache.onChanged(new Coord4D(this.func_174877_v(), this.func_145831_w()));
        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(new Coord4D(this.func_174877_v(), this.func_145831_w()), this.getNetworkedData(new TileNetworkList())), new Range4D(new Coord4D(this.func_174877_v(), this.func_145831_w())));
        TextComponentGroup msg = new TextComponentGroup(TextFormatting.GRAY).string("[Mekanica] ", TextFormatting.DARK_BLUE).translation("tooltip.configurator.toggleColor").string(": ");
        if (this.getTransmitter().getColor() != null) {
            msg.func_150257_a(this.getTransmitter().getColor().getTranslatedColouredComponent());
        } else {
            msg.translation("gui.none");
        }
        player.func_145747_a((ITextComponent)msg);
        return EnumActionResult.SUCCESS;
    }

    @Override
    public EnumActionResult onRightClick(EntityPlayer player, EnumFacing side) {
        super.onRightClick(player, side);
        TextComponentGroup msg = new TextComponentGroup(TextFormatting.GRAY).string("[Mekanica] ", TextFormatting.DARK_BLUE).translation("tooltip.configurator.viewColor").string(": ");
        if (this.getTransmitter().getColor() != null) {
            msg.func_150257_a(this.getTransmitter().getColor().getTranslatedColouredComponent());
        } else {
            msg.translation("gui.none");
        }
        player.func_145747_a((ITextComponent)msg);
        return EnumActionResult.SUCCESS;
    }

    @Override
    public EnumColor getRenderColor() {
        return this.getTransmitter().getColor();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.func_145831_w().field_72995_K) {
            for (TransporterStack stack : this.getTransmitter().transit) {
                TransporterUtils.drop(this.getTransmitter(), stack);
            }
        }
    }

    @Override
    public int getCapacity() {
        return 0;
    }

    @Override
    public Object getBuffer() {
        return null;
    }

    @Override
    public void takeShare() {
    }

    @Override
    public void updateShare() {
    }

    public TransporterImpl getTransmitter() {
        return (TransporterImpl)this.transmitterDelegate;
    }

    public double getCost() {
        return (double)Tier.TransporterTier.ULTIMATE.speed / (double)this.tier.speed;
    }

    @Override
    public boolean upgrade(int tierOrdinal) {
        if (this.tier.ordinal() < Tier.BaseTier.ULTIMATE.ordinal() && tierOrdinal == this.tier.ordinal() + 1) {
            this.tier = Tier.TransporterTier.values()[this.tier.ordinal() + 1];
            this.markDirtyTransmitters();
            this.sendDesc = true;
            return true;
        }
        return false;
    }

    @Override
    public IBlockState getExtendedState(IBlockState state) {
        return ((IExtendedBlockState)super.getExtendedState(state)).withProperty((IUnlistedProperty)PropertyColor.INSTANCE, (Object)new PropertyColor(this.getRenderColor()));
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.LOGISTICAL_TRANSPORTER_CAPABILITY) {
            return (T)this.getTransmitter();
        }
        return super.getCapability(capability, side);
    }
}

