/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.api.Range4D;
import mekanism.api.TileNetworkList;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.ColourRGBA;
import mekanism.common.Mekanism;
import mekanism.common.Tier;
import mekanism.common.block.states.BlockStateTransmitter;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.transmitters.grid.HeatNetwork;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.HeatUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class TileEntityThermodynamicConductor
extends TileEntityTransmitter<IHeatTransfer, HeatNetwork>
implements IHeatTransfer {
    public Tier.ConductorTier tier = Tier.ConductorTier.BASIC;
    public double temperature = 0.0;
    public double clientTemperature = 0.0;
    public double heatToAbsorb = 0.0;

    @Override
    public Tier.BaseTier getBaseTier() {
        return this.tier.getBaseTier();
    }

    @Override
    public void setBaseTier(Tier.BaseTier baseTier) {
        this.tier = Tier.ConductorTier.get(baseTier);
    }

    @Override
    public HeatNetwork createNewNetwork() {
        return new HeatNetwork();
    }

    @Override
    public HeatNetwork createNetworkByMerging(Collection<HeatNetwork> networks) {
        return new HeatNetwork(networks);
    }

    @Override
    public int getCapacity() {
        return 0;
    }

    @Override
    public Object getBuffer() {
        return null;
    }

    @Override
    public void takeShare() {
    }

    @Override
    public void updateShare() {
    }

    @Override
    public BlockStateTransmitter.TransmitterType getTransmitterType() {
        return BlockStateTransmitter.TransmitterType.THERMODYNAMIC_CONDUCTOR;
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, EnumFacing side) {
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d())) {
            IHeatTransfer transfer = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d());
            return transfer.canConnectHeat(side.func_176734_d());
        }
        return false;
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.HEAT;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.temperature = nbtTags.func_74769_h("temperature");
        if (nbtTags.func_74764_b("tier")) {
            this.tier = Tier.ConductorTier.values()[nbtTags.func_74762_e("tier")];
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74780_a("temperature", this.temperature);
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        return nbtTags;
    }

    public void sendTemp() {
        Coord4D coord = new Coord4D(this.func_174877_v(), this.func_145831_w());
        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(coord, this.getNetworkedData(new TileNetworkList())), new Range4D(coord));
    }

    @Override
    public IHeatTransfer getCachedAcceptor(EnumFacing side) {
        TileEntity tile = this.getCachedTile(side);
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d())) {
            return CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d());
        }
        return null;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) throws Exception {
        this.tier = Tier.ConductorTier.values()[dataStream.readInt()];
        super.handlePacketData(dataStream);
        this.temperature = dataStream.readDouble();
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        data.add(this.tier.ordinal());
        super.getNetworkedData(data);
        data.add(this.temperature);
        return data;
    }

    public ColourRGBA getBaseColour() {
        return this.tier.baseColour;
    }

    @Override
    public double getTemp() {
        return this.temperature;
    }

    @Override
    public double getInverseConductionCoefficient() {
        return this.tier.inverseConduction;
    }

    @Override
    public double getInsulationCoefficient(EnumFacing side) {
        return this.tier.inverseConductionInsulation;
    }

    @Override
    public void transferHeatTo(double heat) {
        this.heatToAbsorb += heat;
    }

    @Override
    public double[] simulateHeat() {
        return HeatUtils.simulate(this);
    }

    @Override
    public double applyTemperatureChange() {
        this.temperature += this.tier.inverseHeatCapacity * this.heatToAbsorb;
        this.heatToAbsorb = 0.0;
        if (Math.abs(this.temperature - this.clientTemperature) > this.temperature / 20.0) {
            this.clientTemperature = this.temperature;
            this.sendTemp();
        }
        return this.temperature;
    }

    @Override
    public boolean canConnectHeat(EnumFacing side) {
        return true;
    }

    @Override
    public IHeatTransfer getAdjacent(EnumFacing side) {
        TileEntity adj;
        if (TileEntityThermodynamicConductor.connectionMapContainsSide(this.getAllCurrentConnections(), side) && CapabilityUtils.hasCapability((ICapabilityProvider)(adj = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(side))), Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d())) {
            return CapabilityUtils.getCapability((ICapabilityProvider)adj, Capabilities.HEAT_TRANSFER_CAPABILITY, side.func_176734_d());
        }
        return null;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.HEAT_TRANSFER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.HEAT_TRANSFER_CAPABILITY) {
            return (T)this;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean upgrade(int tierOrdinal) {
        if (this.tier.ordinal() < Tier.BaseTier.ULTIMATE.ordinal() && tierOrdinal == this.tier.ordinal() + 1) {
            this.tier = Tier.ConductorTier.values()[this.tier.ordinal() + 1];
            this.markDirtyTransmitters();
            this.sendDesc = true;
            return true;
        }
        return false;
    }
}

