/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.MekanismFluids;
import mekanism.common.Tier;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.oredict.OreDictionary;

public final class GasUtils {
    public static IGasHandler[] getConnectedAcceptors(TileEntity tileEntity, Collection<EnumFacing> sides) {
        return GasUtils.getConnectedAcceptors(tileEntity.func_174877_v(), tileEntity.func_145831_w(), sides);
    }

    public static IGasHandler[] getConnectedAcceptors(BlockPos pos, World world, Collection<EnumFacing> sides) {
        IGasHandler[] acceptors = new IGasHandler[]{null, null, null, null, null, null};
        for (EnumFacing orientation : sides) {
            TileEntity acceptor = world.func_175625_s(pos.func_177972_a(orientation));
            if (!CapabilityUtils.hasCapability((ICapabilityProvider)acceptor, Capabilities.GAS_HANDLER_CAPABILITY, orientation.func_176734_d())) continue;
            acceptors[orientation.ordinal()] = CapabilityUtils.getCapability((ICapabilityProvider)acceptor, Capabilities.GAS_HANDLER_CAPABILITY, orientation.func_176734_d());
        }
        return acceptors;
    }

    public static IGasHandler[] getConnectedAcceptors(TileEntity tileEntity) {
        return GasUtils.getConnectedAcceptors(tileEntity.func_174877_v(), tileEntity.func_145831_w(), Arrays.asList(EnumFacing.field_82609_l));
    }

    public static IGasHandler[] getConnectedAcceptors(BlockPos pos, World world) {
        return GasUtils.getConnectedAcceptors(pos, world, Arrays.asList(EnumFacing.field_82609_l));
    }

    public static boolean isValidAcceptorOnSide(TileEntity tile, EnumFacing side) {
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d())) {
            return false;
        }
        if (CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.TUBE_CONNECTION_CAPABILITY, side.func_176734_d())) {
            ITubeConnection connection = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.TUBE_CONNECTION_CAPABILITY, side.func_176734_d());
            return connection.canTubeConnect(side.func_176734_d());
        }
        return false;
    }

    public static GasStack removeGas(ItemStack itemStack, Gas type, int amount) {
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof IGasItem) {
            IGasItem item = (IGasItem)itemStack.func_77973_b();
            if (type != null && item.getGas(itemStack) != null && item.getGas(itemStack).getGas() != type || !item.canProvideGas(itemStack, type)) {
                return null;
            }
            return item.removeGas(itemStack, amount);
        }
        return null;
    }

    public static int addGas(ItemStack itemStack, GasStack stack) {
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() instanceof IGasItem && ((IGasItem)itemStack.func_77973_b()).canReceiveGas(itemStack, stack.getGas())) {
            return ((IGasItem)itemStack.func_77973_b()).addGas(itemStack, stack.copy());
        }
        return 0;
    }

    public static int emit(GasStack stack, TileEntity from, Collection<EnumFacing> sides) {
        int toSend;
        if (stack == null) {
            return 0;
        }
        ArrayList<IGasHandler> availableAcceptors = new ArrayList<IGasHandler>();
        IGasHandler[] possibleAcceptors = GasUtils.getConnectedAcceptors(from, sides);
        for (int i = 0; i < possibleAcceptors.length; ++i) {
            IGasHandler handler = possibleAcceptors[i];
            if (handler == null || !handler.canReceiveGas(EnumFacing.func_82600_a((int)i).func_176734_d(), stack.getGas())) continue;
            availableAcceptors.add(handler);
        }
        Collections.shuffle(availableAcceptors);
        int prevSending = toSend = stack.amount;
        if (!availableAcceptors.isEmpty()) {
            int divider = availableAcceptors.size();
            int remaining = toSend % divider;
            int sending = (toSend - remaining) / divider;
            for (IGasHandler acceptor : availableAcceptors) {
                int currentSending = sending;
                if (remaining > 0) {
                    ++currentSending;
                    --remaining;
                }
                EnumFacing dir = EnumFacing.func_82600_a((int)Arrays.asList(possibleAcceptors).indexOf(acceptor)).func_176734_d();
                toSend -= acceptor.receiveGas(dir, new GasStack(stack.getGas(), currentSending), true);
            }
        }
        return prevSending - toSend;
    }

    public static void writeSustainedData(GasTank gasTank, ItemStack itemStack) {
        if (gasTank.stored != null && gasTank.stored.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "gasStored", gasTank.stored.write(new NBTTagCompound()));
        }
    }

    public static void readSustainedData(GasTank gasTank, ItemStack itemStack) {
        gasTank.stored = ItemDataUtils.hasData(itemStack, "gasStored") ? GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "gasStored")) : null;
    }

    public static GasStack getItemGas(ItemStack itemStack, BiFunction<Gas, Integer, GasStack> getIfValid) {
        IGasItem item;
        GasStack gas;
        GasStack gasStack = null;
        if (itemStack.func_77969_a(new ItemStack(Items.field_151145_ak)) && (gasStack = getIfValid.apply(MekanismFluids.Oxygen, 10)) != null) {
            return gasStack;
        }
        List<String> oreDictNames = MekanismUtils.getOreDictName(itemStack);
        if (oreDictNames.contains("dustSulfur") && (gasStack = getIfValid.apply(MekanismFluids.SulfuricAcid, 2)) != null) {
            return gasStack;
        }
        if (oreDictNames.contains("dustSalt") && (gasStack = getIfValid.apply(MekanismFluids.HydrogenChloride, 2)) != null) {
            return gasStack;
        }
        if (oreDictNames.contains("ingotOsmium") && (gasStack = getIfValid.apply(MekanismFluids.LiquidOsmium, 200)) != null) {
            return gasStack;
        }
        OreDictionary.getOres((String)"blockOsmium");
        if (oreDictNames.contains("blockOsmium") && (gasStack = getIfValid.apply(MekanismFluids.LiquidOsmium, 1800)) != null) {
            return gasStack;
        }
        if (itemStack.func_77973_b() instanceof IGasItem && (gas = (item = (IGasItem)itemStack.func_77973_b()).getGas(itemStack)) != null && item.canProvideGas(itemStack, gas.getGas()) && (gasStack = getIfValid.apply(gas.getGas(), 1)) != null) {
            return gasStack;
        }
        return gasStack;
    }

    public static List<ItemStack> getStacksForGas(Gas type) {
        if (type == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (type == MekanismFluids.SulfuricAcid) {
            stacks.addAll((Collection<ItemStack>)OreDictionary.getOres((String)"dustSulfur"));
        }
        if (type == MekanismFluids.HydrogenChloride) {
            stacks.addAll((Collection<ItemStack>)OreDictionary.getOres((String)"dustSalt"));
        }
        if (type == MekanismFluids.LiquidOsmium) {
            stacks.addAll((Collection<ItemStack>)OreDictionary.getOres((String)"ingotOsmium"));
            stacks.addAll((Collection<ItemStack>)OreDictionary.getOres((String)"blockOsmium"));
        }
        if (type == MekanismFluids.Oxygen) {
            stacks.add(new ItemStack(Items.field_151145_ak));
        }
        stacks.add(MekanismUtils.getFullGasTank(Tier.GasTankTier.BASIC, type));
        return stacks;
    }
}

