/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.util.CapabilityUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public final class PipeUtils {
    public static final FluidTankInfo[] EMPTY = new FluidTankInfo[0];

    public static boolean isValidAcceptorOnSide(TileEntity tile, EnumFacing side) {
        if (tile == null || CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, side.func_176734_d()) || !CapabilityUtils.hasCapability((ICapabilityProvider)tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) {
            return false;
        }
        IFluidHandler container = (IFluidHandler)CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
        if (container == null) {
            return false;
        }
        IFluidTankProperties[] infoArray = container.getTankProperties();
        if (infoArray != null && infoArray.length > 0) {
            for (IFluidTankProperties info : infoArray) {
                if (info == null) continue;
                return true;
            }
        }
        return false;
    }

    public static IFluidHandler[] getConnectedAcceptors(TileEntity tileEntity) {
        return PipeUtils.getConnectedAcceptors(tileEntity.func_174877_v(), tileEntity.func_145831_w());
    }

    public static IFluidHandler[] getConnectedAcceptors(BlockPos pos, World world) {
        IFluidHandler[] acceptors = new IFluidHandler[]{null, null, null, null, null, null};
        for (EnumFacing orientation : EnumFacing.field_82609_l) {
            IFluidHandler handler;
            TileEntity acceptor = world.func_175625_s(pos.func_177972_a(orientation));
            if (!CapabilityUtils.hasCapability((ICapabilityProvider)acceptor, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, orientation.func_176734_d())) continue;
            acceptors[orientation.ordinal()] = handler = (IFluidHandler)CapabilityUtils.getCapability((ICapabilityProvider)acceptor, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, orientation.func_176734_d());
        }
        return acceptors;
    }

    public static int emit(List<EnumFacing> sides, FluidStack stack, TileEntity from) {
        int toSend;
        IFluidHandler[] possibleAcceptors;
        if (stack == null) {
            return 0;
        }
        ArrayList<IFluidHandler> availableAcceptors = new ArrayList<IFluidHandler>();
        for (IFluidHandler handler : possibleAcceptors = PipeUtils.getConnectedAcceptors(from)) {
            if (handler == null || !PipeUtils.canFill(handler, stack)) continue;
            availableAcceptors.add(handler);
        }
        Collections.shuffle(availableAcceptors);
        int prevSending = toSend = stack.amount;
        if (!availableAcceptors.isEmpty()) {
            int divider = availableAcceptors.size();
            int remaining = toSend % divider;
            int sending = (toSend - remaining) / divider;
            for (IFluidHandler acceptor : availableAcceptors) {
                int currentSending = sending;
                if (remaining > 0) {
                    ++currentSending;
                    --remaining;
                }
                EnumFacing dir = EnumFacing.func_82600_a((int)Arrays.asList(possibleAcceptors).indexOf(acceptor)).func_176734_d();
                toSend -= acceptor.fill(PipeUtils.copy(stack, currentSending), true);
            }
        }
        return prevSending - toSend;
    }

    public static FluidStack copy(FluidStack fluid, int amount) {
        FluidStack ret = fluid.copy();
        ret.amount = amount;
        return ret;
    }

    public static boolean canFill(IFluidHandler handler, FluidStack stack) {
        for (IFluidTankProperties props : handler.getTankProperties()) {
            if (!props.canFillFluidType(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean canDrain(IFluidHandler handler, FluidStack stack) {
        for (IFluidTankProperties props : handler.getTankProperties()) {
            if (!props.canDrainFluidType(stack)) continue;
            return true;
        }
        return false;
    }
}

