/*
 * Decompiled with CFR 0.152.
 */
package nc.block.fluid;

import java.util.Random;
import javax.annotation.Nonnull;
import nc.block.fluid.BlockFluid;
import nc.config.NCConfig;
import nc.fluid.FluidPlasma;
import nc.tile.passive.TilePassive;
import nc.util.MaterialHelper;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class BlockFluidPlasma
extends BlockFluid {
    private static final Material GAS = new MaterialLiquid(MapColor.field_151660_b);
    public static DamageSource plasma_burn = new DamageSource("plasma_burn").func_76348_h();

    public BlockFluidPlasma(Fluid fluid) {
        super(fluid, GAS);
        this.setQuantaPerBlock(16);
    }

    public BlockFluidPlasma(FluidPlasma fluid) {
        super((Fluid)fluid, GAS);
        this.setQuantaPerBlock(16);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        entityIn.func_70097_a(plasma_burn, 8.0f);
        entityIn.func_70015_d(10);
    }

    public void func_180650_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        int free = 0;
        for (EnumFacing side : EnumFacing.values()) {
            Material mat;
            BlockPos offPos = pos.func_177972_a(side);
            if (side != EnumFacing.UP && side != EnumFacing.DOWN && NCConfig.fusion_plasma_craziness && (mat = worldIn.func_180495_p(offPos).func_185904_a()) != Material.field_151581_o && MaterialHelper.isReplaceable(mat) && !mat.func_76224_d() && worldIn.isSideSolid(offPos.func_177977_b(), EnumFacing.UP)) {
                worldIn.func_175656_a(offPos, Blocks.field_150480_ab.func_176223_P());
                break;
            }
            TileEntity tile = worldIn.func_175625_s(offPos);
            if (!(tile instanceof TilePassive.FusionElectromagnet)) {
                ++free;
                continue;
            }
            if (rand.nextInt(100) >= 1) continue;
            TilePassive.FusionElectromagnet magnet = (TilePassive.FusionElectromagnet)tile;
            if (magnet.isActive) continue;
            worldIn.func_72876_a(null, (double)offPos.func_177958_n(), (double)offPos.func_177956_o(), (double)offPos.func_177952_p(), 4.0f, true);
            return;
        }
        if (free >= 6 && this.isSourceBlock((IBlockAccess)worldIn, pos)) {
            worldIn.func_175698_g(pos);
            return;
        }
        super.func_180650_b(worldIn, pos, state, rand);
    }
}

